/*
 * Decompiled with CFR 0.152.
 */
package com.crankysupertoon.electrostatic.capability;

import com.crankysupertoon.electrostatic.ElectricToolRegistry;
import com.crankysupertoon.electrostatic.capability.MemeEnergyWrapper;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class CapabilityEventHandler {
    private static final ResourceLocation CAP_SRC = new ResourceLocation("electrostatic", "memeEnergyCapability");

    @SubscribeEvent
    public void modify(AttachCapabilitiesEvent<ItemStack> event) {
        if (ElectricToolRegistry.isPotentiallyElectric((ItemStack)event.getObject())) {
            event.addCapability(CAP_SRC, (ICapabilityProvider)new MemeCapabilityProvider((ItemStack)event.getObject()));
        }
    }

    private static class MemeCapabilityProvider
    implements ICapabilityProvider {
        private final ItemStack stack;

        public MemeCapabilityProvider(ItemStack stack) {
            this.stack = stack;
        }

        public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
            return capability == CapabilityEnergy.ENERGY && this.stack.func_77942_o() && this.stack.func_77978_p().func_74764_b("memeEnergyCapacity");
        }

        @Nullable
        public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
            if (capability == CapabilityEnergy.ENERGY) {
                return (T)new MemeEnergyWrapper(this.stack);
            }
            return null;
        }
    }
}

