/*
 * Decompiled with CFR 0.152.
 */
package com.crankysupertoon.electrostatic.client;

import com.crankysupertoon.electrostatic.ElectricToolRegistry;
import java.awt.Color;
import java.util.Objects;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import slimeknights.tconstruct.library.client.CustomFontColor;

public class MemeEnergyTooltipHandler {
    @SubscribeEvent
    public void onTooltip(ItemTooltipEvent event) {
        if (ElectricToolRegistry.isElectric(event.getItemStack())) {
            IEnergyStorage energy = (IEnergyStorage)Objects.requireNonNull(event.getItemStack().getCapability(CapabilityEnergy.ENERGY, EnumFacing.NORTH));
            int stored = energy.getEnergyStored();
            int max = energy.getMaxEnergyStored();
            event.getToolTip().add(1, String.format("%s%,d / %,d RF", CustomFontColor.encodeColor((int)Color.HSBtoRGB(0.33f * (float)stored / (float)max, 1.0f, 0.67f)), stored, max));
        }
    }
}

