/*
 * Decompiled with CFR 0.152.
 */
package com.crankysupertoon.electrostatic.integration;

import com.crankysupertoon.electrostatic.integration.MemeIntegration;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.relauncher.Side;

public class IntegrationManager {
    @Nullable
    private static List<MemeIntegration> INTEGRATIONS = null;

    private static List<MemeIntegration> getIntegrations() {
        if (INTEGRATIONS == null) {
            INTEGRATIONS = Stream.of(new Provider("conarm", "MemeIntegrationConArm", "client.MemeIntegrationConArmClient")).filter(p -> Loader.isModLoaded((String)p.modId)).map(Provider::loadIntegration).collect(Collectors.toList());
        }
        return INTEGRATIONS;
    }

    public static void preInit() {
        IntegrationManager.getIntegrations().forEach(MemeIntegration::preInit);
    }

    public static void postInit() {
        IntegrationManager.getIntegrations().forEach(MemeIntegration::postInit);
    }

    private static class Provider {
        final String modId;
        private final String serverClass;
        private final String clientClass;

        Provider(String modId, String serverClass, String clientClass) {
            this.modId = modId;
            this.serverClass = serverClass;
            this.clientClass = clientClass;
        }

        MemeIntegration loadIntegration() {
            try {
                return (MemeIntegration)Class.forName(this.getSidedClass()).newInstance();
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                throw new IllegalStateException("Could not initialize integration for " + this.modId + "!", e);
            }
        }

        private String getSidedClass() {
            return "com.crankysupertoon.electrostatic.integration." + this.modId + "." + (FMLCommonHandler.instance().getSide() == Side.CLIENT ? this.clientClass : this.serverClass);
        }
    }
}

