/*
 * Decompiled with CFR 0.152.
 */
package com.rcx.materialis;

import com.rcx.materialis.resources.BlockMoltenCustom;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class MaterialisRegistry {
    public static List<ItemBlock> blocks = new ArrayList<ItemBlock>();
    public static List<Item> items = new ArrayList<Item>();

    public static void registerBlock(Block block) {
        blocks.add((ItemBlock)new ItemBlock(block).setRegistryName(block.getRegistryName()));
    }

    public static void registerItem(Item item) {
        items.add(item);
    }

    public static void registerFluid(Fluid fluid, int color) {
        fluid.setUnlocalizedName(fluid.getName());
        FluidRegistry.registerFluid((Fluid)fluid);
        FluidRegistry.addBucketForFluid((Fluid)fluid);
        BlockMoltenCustom block = new BlockMoltenCustom(fluid, color);
        block.setRegistryName("materialis", "molten_" + fluid.getName());
        MaterialisRegistry.registerBlock((Block)block);
    }

    public static void addRecipe(@Nonnull ItemStack output, String name, Object ... params) {
        MaterialisRegistry.addRecipe(output, name, name, params);
    }

    public static void addRecipe(@Nonnull ItemStack output, String name, String group, Object ... params) {
        GameRegistry.addShapedRecipe((ResourceLocation)new ResourceLocation("materialis", "recipe_" + name), (ResourceLocation)new ResourceLocation(group), (ItemStack)output, (Object[])params);
    }

    public static void addShapelessRecipe(@Nonnull ItemStack output, String name, Ingredient ... params) {
        MaterialisRegistry.addShapelessRecipe(output, name, name, params);
    }

    public static void addShapelessRecipe(@Nonnull ItemStack output, String name, String group, Ingredient ... params) {
        GameRegistry.addShapelessRecipe((ResourceLocation)new ResourceLocation("materialis", "recipe_" + name), (ResourceLocation)new ResourceLocation(group), (ItemStack)output, (Ingredient[])params);
    }
}

