/*
 * Decompiled with CFR 0.152.
 */
package com.rcx.materialis.render;

import com.google.common.collect.ImmutableList;
import com.rcx.materialis.render.TriColorTexture;
import java.awt.Color;
import java.util.Collection;
import java.util.function.Function;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import slimeknights.tconstruct.library.client.RenderUtil;

public class TexturedTriColorTexture
extends TriColorTexture {
    protected final ResourceLocation textureLocation;
    protected TextureAtlasSprite texture;
    protected int[] textureData;
    protected int textureWidth;
    protected int textureHeight;
    protected float scale;
    protected String mode;

    TexturedTriColorTexture(ResourceLocation baseTexture, String spriteName, ResourceLocation texture, String underlay, int bright, int mid, int dark, int midThreshold, int darkThreshold) {
        super(baseTexture, spriteName, bright, mid, dark, midThreshold, darkThreshold);
        this.textureLocation = texture;
        this.mode = underlay;
    }

    public Collection<ResourceLocation> getDependencies() {
        return ImmutableList.builder().addAll((Iterable)super.getDependencies()).add((Object)this.textureLocation).build();
    }

    public boolean load(IResourceManager manager, ResourceLocation location, Function<ResourceLocation, TextureAtlasSprite> textureGetter) {
        this.texture = textureGetter.apply(this.textureLocation);
        super.load(manager, location, textureGetter);
        return false;
    }

    protected void preProcess(int[] data) {
        super.preProcess(data);
        this.textureData = this.texture.func_147965_a(0)[0];
        this.textureWidth = this.texture.func_94211_a();
        this.textureHeight = this.texture.func_94216_b();
        this.scale = (float)this.textureHeight / (float)this.textureWidth;
    }

    protected void postProcess(int[] data) {
        super.postProcess(data);
        this.textureData = null;
    }

    @Override
    protected int colorPixel(int pixel, int pxCoord) {
        int a = RenderUtil.alpha((int)pixel);
        if (a == 0) {
            return pixel;
        }
        int texCoord = pxCoord;
        if (this.field_130223_c > this.textureWidth || this.field_130223_c < this.textureWidth) {
            int texX = pxCoord % this.field_130223_c % this.textureWidth;
            int texY = pxCoord / this.field_130224_d % this.textureHeight;
            texCoord = texY * this.textureWidth + texX;
        }
        int tc = this.textureData[texCoord];
        if (this.mode.equals("underlay")) {
            int r = RenderUtil.red((int)pixel);
            int g = RenderUtil.green((int)pixel);
            int b = RenderUtil.blue((int)pixel);
            r = TexturedTriColorTexture.mult((int)r, (int)RenderUtil.red((int)tc)) & 0xFF;
            g = TexturedTriColorTexture.mult((int)g, (int)RenderUtil.green((int)tc)) & 0xFF;
            b = TexturedTriColorTexture.mult((int)b, (int)RenderUtil.blue((int)tc)) & 0xFF;
            return super.colorPixel(RenderUtil.compose((int)r, (int)g, (int)b, (int)a), pxCoord);
        }
        int c = super.colorPixel(pixel, pxCoord);
        int r = RenderUtil.red((int)c);
        int g = RenderUtil.green((int)c);
        int b = RenderUtil.blue((int)c);
        if (this.mode.equals("overlay_multiply")) {
            r = TexturedTriColorTexture.mult((int)r, (int)RenderUtil.red((int)tc)) & 0xFF;
            g = TexturedTriColorTexture.mult((int)g, (int)RenderUtil.green((int)tc)) & 0xFF;
            b = TexturedTriColorTexture.mult((int)b, (int)RenderUtil.blue((int)tc)) & 0xFF;
        } else if (this.mode.equals("overlay_huesat")) {
            float[] overlay = Color.RGBtoHSB(RenderUtil.red((int)tc), RenderUtil.green((int)tc), RenderUtil.blue((int)tc), null);
            float[] base = Color.RGBtoHSB(r, g, b, null);
            Color color = Color.getHSBColor(overlay[0], overlay[1] * base[1], base[2]);
            r = color.getRed();
            g = color.getGreen();
            b = color.getBlue();
        }
        return RenderUtil.compose((int)r, (int)g, (int)b, (int)a);
    }
}

