/*
 * Decompiled with CFR 0.152.
 */
package com.rcx.materialis.render;

import net.minecraft.util.ResourceLocation;
import slimeknights.tconstruct.library.client.RenderUtil;
import slimeknights.tconstruct.library.client.texture.AbstractColoredTexture;

public class TriColorTexture
extends AbstractColoredTexture {
    protected int bright;
    protected int mid;
    protected int dark;
    protected float midCap;
    protected float darkCap;

    TriColorTexture(ResourceLocation baseTextureLocation, String spriteName, int bright, int mid, int dark, int midThreshold, int darkThreshold) {
        super(baseTextureLocation, spriteName);
        this.bright = bright;
        this.mid = mid;
        this.dark = dark;
        this.midCap = midThreshold;
        this.darkCap = darkThreshold;
    }

    protected int colorPixel(int pixel, int pxCoord) {
        int a = RenderUtil.alpha((int)pixel);
        if (a == 0) {
            return pixel;
        }
        int gray = (RenderUtil.red((int)pixel) + RenderUtil.green((int)pixel) + RenderUtil.blue((int)pixel)) / 3;
        if ((float)gray <= this.darkCap) {
            return TriColorTexture.interpolateColors(0, this.dark, (float)gray / this.darkCap);
        }
        if ((float)gray >= this.midCap) {
            return TriColorTexture.interpolateColors(this.mid, this.bright, ((float)gray - this.midCap) / (255.0f - this.midCap));
        }
        return TriColorTexture.interpolateColors(this.dark, this.mid, ((float)gray - this.darkCap) / (this.midCap - this.darkCap));
    }

    public static int interpolateColors(int colorDark, int colorBright, float p) {
        return RenderUtil.compose((int)((int)((float)RenderUtil.red((int)colorBright) * p + (float)RenderUtil.red((int)colorDark) * (1.0f - p))), (int)((int)((float)RenderUtil.green((int)colorBright) * p + (float)RenderUtil.green((int)colorDark) * (1.0f - p))), (int)((int)((float)RenderUtil.blue((int)colorBright) * p + (float)RenderUtil.blue((int)colorDark) * (1.0f - p))), (int)255);
    }
}

