/*
 * Decompiled with CFR 0.152.
 */
package forestry.climatology.tiles;

import forestry.api.climate.ClimateCapabilities;
import forestry.api.climate.ClimateType;
import forestry.api.climate.IClimateHousing;
import forestry.api.climate.IClimateManipulator;
import forestry.api.climate.IClimateState;
import forestry.api.climate.IClimateTransformer;
import forestry.api.core.EnumHumidity;
import forestry.api.core.EnumTemperature;
import forestry.api.core.IErrorLogic;
import forestry.api.recipes.IHygroregulatorRecipe;
import forestry.climatology.gui.ContainerHabitatFormer;
import forestry.climatology.gui.GuiHabitatFormer;
import forestry.climatology.inventory.InventoryHabitatFormer;
import forestry.core.climate.ClimateTransformer;
import forestry.core.errors.EnumErrorCode;
import forestry.core.fluids.FilteredTank;
import forestry.core.fluids.FluidHelper;
import forestry.core.fluids.ITankManager;
import forestry.core.fluids.TankManager;
import forestry.core.network.PacketBufferForestry;
import forestry.core.recipes.HygroregulatorManager;
import forestry.core.tiles.IClimatised;
import forestry.core.tiles.ILiquidTankTile;
import forestry.core.tiles.TilePowered;
import forestry.energy.EnergyManager;
import java.io.IOException;
import javax.annotation.Nullable;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileHabitatFormer
extends TilePowered
implements IClimateHousing,
IClimatised,
ILiquidTankTile {
    private static final String TRANSFORMER_KEY = "Transformer";
    private final ClimateTransformer transformer = new ClimateTransformer(this);
    private final FilteredTank resourceTank;
    private final TankManager tankManager;
    @Nullable
    private FluidStack cachedStack = null;

    public TileHabitatFormer() {
        super(1200, 10000);
        this.setInternalInventory(new InventoryHabitatFormer(this));
        this.resourceTank = new FilteredTank(10000).setFilters(HygroregulatorManager.getRecipeFluids());
        this.tankManager = new TankManager(this, this.resourceTank);
        this.setTicksPerWorkCycle(10);
        this.setEnergyPerWorkCycle(0);
    }

    @Override
    public ITankManager getTankManager() {
        return this.tankManager;
    }

    @Override
    public void onRemoval() {
        this.transformer.removeTransformer();
    }

    @Override
    protected void updateServerSide() {
        super.updateServerSide();
        this.transformer.update();
        if (this.updateOnInterval(20)) {
            FluidHelper.drainContainers(this.tankManager, (IInventory)this, 0);
        }
    }

    @Override
    public boolean hasWork() {
        return true;
    }

    @Override
    protected boolean workCycle() {
        IErrorLogic errorLogic = this.getErrorLogic();
        IClimateState currentState = this.transformer.getCurrent();
        IClimateState changedState = this.transformer.getTarget().subtract(currentState);
        IClimateState difference = this.getClimateDifference();
        this.cachedStack = null;
        if (difference.getHumidity() != 0.0f) {
            this.updateHumidity(errorLogic, changedState);
        }
        if (difference.getTemperature() != 0.0f) {
            this.updateTemperature(errorLogic, changedState);
        }
        return true;
    }

    private void updateHumidity(IErrorLogic errorLogic, IClimateState changedState) {
        IClimateManipulator manipulator = this.transformer.createManipulator(ClimateType.HUMIDITY).build();
        if (manipulator.canAdd()) {
            errorLogic.setCondition(false, EnumErrorCode.WRONG_RESOURCE);
            int currentCost = this.getFluidCost(changedState);
            if (this.resourceTank.drain(currentCost, false) != null) {
                IClimateState simulatedState = changedState.toImmutable().add(manipulator.addChange(true));
                int fluidCost = this.getFluidCost(simulatedState);
                if (this.resourceTank.drain(fluidCost, false) != null) {
                    this.cachedStack = this.resourceTank.drain(fluidCost, true);
                    manipulator.addChange(false);
                } else {
                    this.cachedStack = this.resourceTank.drain(currentCost, true);
                }
                errorLogic.setCondition(false, EnumErrorCode.NO_RESOURCE_LIQUID);
            } else {
                manipulator.removeChange(false);
                errorLogic.setCondition(true, EnumErrorCode.NO_RESOURCE_LIQUID);
            }
        } else if (this.resourceTank.isEmpty()) {
            errorLogic.setCondition(true, EnumErrorCode.NO_RESOURCE_LIQUID);
        } else {
            errorLogic.setCondition(true, EnumErrorCode.WRONG_RESOURCE);
            errorLogic.setCondition(false, EnumErrorCode.NO_RESOURCE_LIQUID);
        }
        manipulator.finish();
    }

    private void updateTemperature(IErrorLogic errorLogic, IClimateState changedState) {
        int currentCost;
        IClimateManipulator manipulator = this.transformer.createManipulator(ClimateType.TEMPERATURE).setAllowBackwards().build();
        EnergyManager energyManager = this.getEnergyManager();
        if (energyManager.extractEnergy(currentCost = this.getEnergyCost(changedState), true) > 0) {
            IClimateState simulatedState = manipulator.addChange(true);
            int energyCost = this.getEnergyCost(simulatedState);
            if (energyManager.extractEnergy(energyCost, true) > 0) {
                energyManager.extractEnergy(energyCost, false);
                manipulator.addChange(false);
            } else {
                energyManager.extractEnergy(currentCost, false);
            }
            errorLogic.setCondition(false, EnumErrorCode.NO_POWER);
        } else {
            manipulator.removeChange(false);
            errorLogic.setCondition(true, EnumErrorCode.NO_POWER);
        }
        manipulator.finish();
    }

    private int getFluidCost(IClimateState state) {
        FluidStack fluid = this.resourceTank.getFluid();
        if (fluid == null) {
            return 0;
        }
        IHygroregulatorRecipe recipe = HygroregulatorManager.findMatchingRecipe(fluid);
        if (recipe == null) {
            return 0;
        }
        return Math.round((1.0f + MathHelper.func_76135_e((float)state.getHumidity())) * this.transformer.getCostModifier() * (float)recipe.getResource().amount);
    }

    private int getEnergyCost(IClimateState state) {
        return Math.round((1.0f + MathHelper.func_76135_e((float)state.getTemperature())) * this.transformer.getCostModifier());
    }

    @Override
    public float getChangeForState(ClimateType type, IClimateManipulator manipulator) {
        IHygroregulatorRecipe recipe;
        FluidStack fluid;
        if (type == ClimateType.HUMIDITY && (fluid = this.resourceTank.getFluid()) != null && (recipe = HygroregulatorManager.findMatchingRecipe(fluid)) != null) {
            return recipe.getHumidChange() / this.transformer.getSpeedModifier();
        }
        float fluidChange = 0.0f;
        if (this.cachedStack != null && (recipe = HygroregulatorManager.findMatchingRecipe(this.cachedStack)) != null) {
            fluidChange = Math.abs(recipe.getTempChange());
        }
        return (0.05f + fluidChange) * 0.5f / this.transformer.getSpeedModifier();
    }

    private IClimateState getClimateDifference() {
        IClimateState defaultState = this.transformer.getDefault();
        IClimateState targetedState = this.transformer.getTarget();
        return targetedState.subtract(defaultState);
    }

    @Override
    public void markNetworkUpdate() {
        this.setNeedsNetworkUpdate();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiContainer getGui(EntityPlayer player, int data) {
        return new GuiHabitatFormer(player, this);
    }

    @Override
    public Container getContainer(EntityPlayer player, int data) {
        return new ContainerHabitatFormer(player.field_71071_by, this);
    }

    @Override
    public EnumTemperature getTemperature() {
        return EnumTemperature.getFromValue(this.getExactTemperature());
    }

    @Override
    public EnumHumidity getHumidity() {
        return EnumHumidity.getFromValue(this.getExactHumidity());
    }

    @Override
    public Biome getBiome() {
        return this.field_145850_b.func_180494_b(this.func_174877_v());
    }

    @Override
    public float getExactTemperature() {
        return this.transformer.getCurrent().getTemperature();
    }

    @Override
    public float getExactHumidity() {
        return this.transformer.getCurrent().getHumidity();
    }

    @Override
    public IClimateTransformer getTransformer() {
        return this.transformer;
    }

    @Override
    public void writeGuiData(PacketBufferForestry data) {
        super.writeGuiData(data);
        this.transformer.writeData(data);
    }

    @Override
    public void readGuiData(PacketBufferForestry data) throws IOException {
        super.readGuiData(data);
        this.transformer.readData(data);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound data) {
        super.func_189515_b(data);
        this.tankManager.writeToNBT(data);
        data.func_74782_a(TRANSFORMER_KEY, (NBTBase)this.transformer.writeToNBT(new NBTTagCompound()));
        return data;
    }

    @Override
    public void func_145839_a(NBTTagCompound data) {
        super.func_145839_a(data);
        this.tankManager.readFromNBT(data);
        if (data.func_74764_b(TRANSFORMER_KEY)) {
            NBTTagCompound nbtTag = data.func_74775_l(TRANSFORMER_KEY);
            this.transformer.readFromNBT(nbtTag);
        }
    }

    @Override
    public void writeData(PacketBufferForestry data) {
        super.writeData(data);
        this.tankManager.writeData(data);
        this.transformer.writeData(data);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void readData(PacketBufferForestry data) throws IOException {
        super.readData(data);
        this.tankManager.readData(data);
        this.transformer.readData(data);
    }

    @Override
    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)this.tankManager);
        }
        if (capability == ClimateCapabilities.CLIMATE_TRANSFORMER) {
            return (T)ClimateCapabilities.CLIMATE_TRANSFORMER.cast((Object)this.transformer);
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || capability == ClimateCapabilities.CLIMATE_TRANSFORMER || super.hasCapability(capability, facing);
    }
}

