/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui;

import com.google.common.collect.ImmutableList;
import forestry.api.apiculture.IApiaristTracker;
import forestry.api.genetics.IAlleleSpecies;
import forestry.api.genetics.IBreedingTracker;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.IMutation;
import forestry.api.genetics.ISpeciesRoot;
import forestry.core.genetics.mutations.EnumMutateChance;
import forestry.core.gui.CycleTimer;
import forestry.core.gui.GuiForestry;
import forestry.core.gui.GuiUtil;
import forestry.core.gui.buttons.GuiBetterButton;
import forestry.core.gui.buttons.StandardButtonTextureSets;
import forestry.core.network.packets.PacketGuiSelectRequest;
import forestry.core.render.ColourProperties;
import forestry.core.utils.NetworkUtil;
import forestry.core.utils.Translator;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

public class GuiNaturalistInventory
extends GuiForestry<Container> {
    private final ISpeciesRoot speciesRoot;
    private final IBreedingTracker breedingTracker;
    private final HashMap<String, ItemStack> iconStacks = new HashMap();
    private final int pageCurrent;
    private final int pageMax;
    private final CycleTimer timer = new CycleTimer(0);

    public GuiNaturalistInventory(ISpeciesRoot speciesRoot, EntityPlayer player, Container container, int page, int maxPages) {
        super("textures/gui/apiaristinventory.png", container);
        this.speciesRoot = speciesRoot;
        this.pageCurrent = page;
        this.pageMax = maxPages;
        this.field_146999_f = 196;
        this.field_147000_g = 202;
        for (IIndividual iIndividual : speciesRoot.getIndividualTemplates()) {
            this.iconStacks.put(iIndividual.getIdent(), speciesRoot.getMemberStack(iIndividual, speciesRoot.getIconType()));
        }
        this.breedingTracker = speciesRoot.getBreedingTracker(player.field_70170_p, player.func_146103_bH());
    }

    @Override
    protected void func_146976_a(float f, int i, int j) {
        super.func_146976_a(f, i, j);
        this.timer.onDraw();
        String header = Translator.translateToLocal("for.gui.page") + " " + (this.pageCurrent + 1) + "/" + this.pageMax;
        this.field_146289_q.func_78276_b(header, this.field_147003_i + 95 + this.textLayout.getCenteredOffset(header, 98), this.field_147009_r + 10, ColourProperties.INSTANCE.get("gui.title"));
        IIndividual individual = this.getIndividualAtPosition(i, j);
        if (individual == null) {
            this.displayBreedingStatistics(10);
        }
        if (individual != null) {
            RenderHelper.func_74520_c();
            this.textLayout.startPage();
            boolean pureBred = individual.isPureBred(individual.getGenome().getSpeciesRoot().getSpeciesChromosomeType());
            this.displaySpeciesInformation(true, individual.getGenome().getPrimary(), this.iconStacks.get(individual.getIdent()), 10, pureBred ? 25 : 10);
            if (!pureBred) {
                this.textLayout.line = 66;
                this.displaySpeciesInformation(individual.isAnalyzed(), individual.getGenome().getSecondary(), this.iconStacks.get(individual.getGenome().getSecondary().getUID()), 10, 10);
            }
            this.textLayout.endPage();
        }
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146292_n.add(new GuiBetterButton(1, this.field_147003_i + 99, this.field_147009_r + 7, StandardButtonTextureSets.LEFT_BUTTON_SMALL));
        this.field_146292_n.add(new GuiBetterButton(2, this.field_147003_i + 180, this.field_147009_r + 7, StandardButtonTextureSets.RIGHT_BUTTON_SMALL));
    }

    private static void flipPage(int page) {
        NetworkUtil.sendToServer(new PacketGuiSelectRequest(page, 0));
    }

    protected void func_146284_a(GuiButton guibutton) throws IOException {
        super.func_146284_a(guibutton);
        if (guibutton.field_146127_k == 1 && this.pageCurrent > 0) {
            GuiNaturalistInventory.flipPage(this.pageCurrent - 1);
        } else if (guibutton.field_146127_k == 2 && this.pageCurrent < this.pageMax - 1) {
            GuiNaturalistInventory.flipPage(this.pageCurrent + 1);
        }
    }

    @Nullable
    private IIndividual getIndividualAtPosition(int x, int y) {
        Slot slot = this.func_146975_c(x, y);
        if (slot == null) {
            return null;
        }
        if (!slot.func_75216_d()) {
            return null;
        }
        if (!slot.func_75211_c().func_77942_o()) {
            return null;
        }
        if (!this.speciesRoot.isMember(slot.func_75211_c())) {
            return null;
        }
        return this.speciesRoot.getMember(slot.func_75211_c());
    }

    private void displayBreedingStatistics(int x) {
        this.textLayout.startPage();
        this.textLayout.drawLine(Translator.translateToLocal("for.gui.speciescount") + ": " + this.breedingTracker.getSpeciesBred() + "/" + this.speciesRoot.getSpeciesCount(), x);
        this.textLayout.newLine();
        this.textLayout.newLine();
        if (this.breedingTracker instanceof IApiaristTracker) {
            IApiaristTracker tracker = (IApiaristTracker)this.breedingTracker;
            this.textLayout.drawLine(Translator.translateToLocal("for.gui.queens") + ": " + tracker.getQueenCount(), x);
            this.textLayout.newLine();
            this.textLayout.drawLine(Translator.translateToLocal("for.gui.princesses") + ": " + tracker.getPrincessCount(), x);
            this.textLayout.newLine();
            this.textLayout.drawLine(Translator.translateToLocal("for.gui.drones") + ": " + tracker.getDroneCount(), x);
            this.textLayout.newLine();
        }
        this.textLayout.endPage();
    }

    private void displaySpeciesInformation(boolean analyzed, IAlleleSpecies species, ItemStack iconStack, int x, int maxMutationCount) {
        if (!analyzed) {
            this.textLayout.drawLine(Translator.translateToLocal("for.gui.unknown"), x);
            return;
        }
        this.textLayout.drawLine(species.getAlleleName(), x);
        GuiUtil.drawItemStack(this, iconStack, this.field_147003_i + x + 69, this.field_147009_r + this.textLayout.getLineY() - 2);
        this.textLayout.newLine();
        int columnWidth = 16;
        int column = 10;
        List<List<? extends IMutation>> mutations = GuiNaturalistInventory.splitMutations(this.speciesRoot.getCombinations(species), maxMutationCount);
        for (IMutation combination : this.timer.getCycledItem(mutations, Collections::emptyList)) {
            if (this.breedingTracker.isDiscovered(combination)) {
                this.drawMutationIcon(combination, species, column);
            } else {
                this.drawUnknownIcon(combination, column);
            }
            if ((column += columnWidth) <= 75) continue;
            column = 10;
            this.textLayout.newLine(18);
        }
    }

    private void drawMutationIcon(IMutation combination, IAlleleSpecies species, int x) {
        int column;
        GuiUtil.drawItemStack(this, this.iconStacks.get(combination.getPartner(species).getUID()), this.field_147003_i + x, this.field_147009_r + this.textLayout.getLineY());
        int line = 48;
        EnumMutateChance chance = EnumMutateChance.rateChance(combination.getBaseChance());
        if (chance == EnumMutateChance.HIGHEST) {
            line += 16;
            column = 228;
        } else if (chance == EnumMutateChance.HIGHER) {
            line += 16;
            column = 212;
        } else if (chance == EnumMutateChance.HIGH) {
            line += 16;
            column = 196;
        } else if (chance == EnumMutateChance.NORMAL) {
            line += 0;
            column = 228;
        } else if (chance == EnumMutateChance.LOW) {
            line += 0;
            column = 212;
        } else {
            line += 0;
            column = 196;
        }
        this.bindTexture(this.textureFile);
        this.func_73729_b(this.field_147003_i + x, this.field_147009_r + this.textLayout.getLineY(), column, line, 16, 16);
    }

    private void drawUnknownIcon(IMutation mutation, int x) {
        int column;
        int line;
        float chance = mutation.getBaseChance();
        if (chance >= 20.0f) {
            line = 16;
            column = 228;
        } else if (chance >= 15.0f) {
            line = 16;
            column = 212;
        } else if (chance >= 12.0f) {
            line = 16;
            column = 196;
        } else if (chance >= 10.0f) {
            line = 0;
            column = 228;
        } else if (chance >= 5.0f) {
            line = 0;
            column = 212;
        } else {
            line = 0;
            column = 196;
        }
        this.bindTexture(this.textureFile);
        this.func_73729_b(this.field_147003_i + x, this.field_147009_r + this.textLayout.getLineY(), column, line, 16, 16);
    }

    private static List<List<? extends IMutation>> splitMutations(List<? extends IMutation> mutations, int maxMutationCount) {
        int size = mutations.size();
        if (size <= maxMutationCount) {
            return Collections.singletonList(mutations);
        }
        ImmutableList.Builder subGroups = new ImmutableList.Builder();
        LinkedList<IMutation> subList = new LinkedList<IMutation>();
        subGroups.add(subList);
        int count = 0;
        for (IMutation iMutation : mutations) {
            if (iMutation.isSecret()) continue;
            if (count % maxMutationCount == 0 && count != 0) {
                subList = new LinkedList();
                subGroups.add(subList);
            }
            subList.add(iMutation);
            ++count;
        }
        return subGroups.build();
    }

    @Override
    protected void addLedgers() {
        this.addHintLedger("naturalist.chest");
    }
}

