/*
 * Decompiled with CFR 0.152.
 */
package workbench.botanianeedsit.common.tile;

import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.api.mana.IManaItem;
import vazkii.botania.api.mana.IManaPool;

public class ManaChargerTile
extends TileEntity
implements ITickable {
    private static final int RATE = 1000;
    private ItemHandler itemHandler;
    private static final Random rand = new Random();
    public int _rotation = rand.nextInt(360);

    public ItemHandler getItemHandler() {
        if (this.itemHandler == null) {
            this.itemHandler = new ItemHandler(this);
        }
        return this.itemHandler;
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        ItemStack stack = this.itemHandler.getStackInSlot(0);
        if (stack.func_190926_b()) {
            return;
        }
        Item item = stack.func_77973_b();
        if (item instanceof IManaItem) {
            IManaItem manaItem = (IManaItem)item;
            TileEntity tilePool = this.field_145850_b.func_175625_s(this.field_174879_c.func_177977_b());
            if (tilePool instanceof IManaPool) {
                IManaPool pool = (IManaPool)tilePool;
                if (pool.isOutputtingPower()) {
                    if (manaItem.canReceiveManaFromPool(stack, tilePool) && manaItem.getMana(stack) != manaItem.getMaxMana(stack) && pool.getCurrentMana() > 0) {
                        int mana = Math.min(manaItem.getMaxMana(stack) - manaItem.getMana(stack), 1000);
                        mana = Math.min(pool.getCurrentMana(), mana);
                        pool.recieveMana(-mana);
                        manaItem.addMana(stack, mana);
                        this.func_70296_d();
                    }
                } else if (manaItem.canExportManaToPool(stack, tilePool)) {
                    int currentManaInStack = manaItem.getMana(stack);
                    if (!pool.isFull() && currentManaInStack > 0) {
                        int mana = Math.min(currentManaInStack, 1000);
                        pool.recieveMana(mana);
                        manaItem.addMana(stack, -mana);
                        this.func_70296_d();
                    }
                }
            }
        }
    }

    public boolean handleClick(EntityPlayer playerIn, EnumHand hand) {
        if (playerIn.func_70093_af()) {
            return false;
        }
        ItemStack heldItem = playerIn.func_184586_b(hand);
        ItemHandler itemHandler = this.getItemHandler();
        if (!heldItem.func_190926_b() && heldItem.func_77973_b() instanceof IManaItem) {
            playerIn.func_184611_a(hand, itemHandler.insertItem(0, heldItem, false));
            return true;
        }
        if (heldItem.func_190926_b()) {
            ItemHandlerHelper.giveItemToPlayer((EntityPlayer)playerIn, (ItemStack)itemHandler.extractItem(0, 1, false));
            return true;
        }
        return false;
    }

    public int getComparatorOutput() {
        ItemStack stack = this.itemHandler.getStackInSlot(0).func_77946_l();
        if (stack.func_190926_b()) {
            return 0;
        }
        IManaItem manaItem = (IManaItem)stack.func_77973_b();
        int currentMana = manaItem.getMana(stack);
        int maxMana = manaItem.getMaxMana(stack);
        if (maxMana < 1 || currentMana < 1) {
            return 1;
        }
        return 1 + (int)((float)currentMana / (float)maxMana * 14.0f) + 1;
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public void handleUpdateTag(NBTTagCompound tag) {
        this.func_145839_a(tag);
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.field_174879_c, -999, this.func_189515_b(new NBTTagCompound()));
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public NBTTagCompound func_189515_b(NBTTagCompound compound) {
        return this.getItemHandler().write(super.func_189515_b(compound));
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        this.getItemHandler().read(compound);
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        return (T)(capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY ? CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.getItemHandler()) : super.getCapability(capability, facing));
    }

    public static class ItemHandler
    implements IItemHandler {
        private final ManaChargerTile tile;
        private ItemStack item = ItemStack.field_190927_a;

        public ItemHandler(ManaChargerTile tile) {
            this.tile = tile;
        }

        public int getSlots() {
            return 1;
        }

        @Nonnull
        public ItemStack getStackInSlot(int slot) {
            return this.item;
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            if (this.isItemValid(slot, stack)) {
                if (!this.item.func_190926_b()) {
                    return stack;
                }
                ItemStack ret = stack.func_77946_l();
                ret.func_190918_g(1);
                if (!simulate) {
                    ItemStack toInsert = stack.func_77946_l();
                    toInsert.func_190920_e(1);
                    this.item = toInsert;
                    this.onContentChanged();
                }
                return ret;
            }
            return stack;
        }

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (this.item.func_190926_b()) {
                return ItemStack.field_190927_a;
            }
            ItemStack ret = this.item;
            if (!simulate) {
                this.item = ItemStack.field_190927_a;
                this.onContentChanged();
            }
            return ret;
        }

        public int getSlotLimit(int slot) {
            return 1;
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return stack.func_77973_b() instanceof IManaItem;
        }

        private NBTTagCompound write(NBTTagCompound nbt) {
            nbt.func_74782_a("Item", (NBTBase)this.item.serializeNBT());
            return nbt;
        }

        private void read(NBTTagCompound nbt) {
            this.item = new ItemStack(nbt.func_74775_l("Item"));
        }

        private void onContentChanged() {
            this.tile.func_70296_d();
            VanillaPacketDispatcher.dispatchTEToNearbyPlayers((TileEntity)this.tile);
        }
    }
}

