/*
 * Decompiled with CFR 0.152.
 */
package eutros.framedcompactdrawers.integration;

import eutros.framedcompactdrawers.integration.IIntegrationPlugin;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.fml.common.Loader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class IntegrationRegistry {
    private final Logger LOGGER = LogManager.getLogger((String)"Framed Compact Drawers Integration");
    private final List<IIntegrationPlugin> registry = new ArrayList<IIntegrationPlugin>();

    public void add(IIntegrationPlugin module) {
        if (module.versionCheck()) {
            this.registry.add(module);
        }
    }

    public void init() {
        for (int i = 0; i < this.registry.size(); ++i) {
            IIntegrationPlugin module = this.registry.get(i);
            if (!Loader.isModLoaded((String)module.getModID())) {
                this.registry.remove(i--);
                continue;
            }
            try {
                module.init();
                continue;
            }
            catch (Throwable t) {
                this.registry.remove(i--);
                this.LOGGER.warn("Could not load integration module: " + module.getClass().getName());
            }
        }
    }

    public void postInit() {
        for (IIntegrationPlugin module : this.registry) {
            module.postInit();
        }
    }
}

