/*
 * Decompiled with CFR 0.152.
 */
package eutros.framedcompactdrawers.model;

import com.google.common.collect.ImmutableList;
import com.jaquadro.minecraft.chameleon.Chameleon;
import com.jaquadro.minecraft.chameleon.model.CachedBuilderModel;
import com.jaquadro.minecraft.chameleon.model.ChamModel;
import com.jaquadro.minecraft.chameleon.model.ProxyBuilderModel;
import com.jaquadro.minecraft.chameleon.render.ChamRender;
import com.jaquadro.minecraft.chameleon.resources.IconUtil;
import com.jaquadro.minecraft.chameleon.resources.register.DefaultRegister;
import com.jaquadro.minecraft.storagedrawers.block.BlockDrawersCustom;
import com.jaquadro.minecraft.storagedrawers.block.modeldata.MaterialModelData;
import com.jaquadro.minecraft.storagedrawers.client.model.component.DrawerSealedModel;
import eutros.framedcompactdrawers.block.BlockSlaveCustom;
import eutros.framedcompactdrawers.model.SlaveRenderer;
import eutros.framedcompactdrawers.registry.ModBlocks;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.property.IExtendedBlockState;

public class CustomSlaveModel
extends ChamModel {
    private static final ItemHandler itemHandler = new ItemHandler();
    private TextureAtlasSprite iconParticle;

    private CustomSlaveModel(IBlockState state, boolean mergeLayers) {
        this(state, ItemStack.field_190927_a, ItemStack.field_190927_a, ItemStack.field_190927_a, ItemStack.field_190927_a, ItemStack.field_190927_a, ItemStack.field_190927_a, mergeLayers);
    }

    private CustomSlaveModel(IBlockState state, @Nonnull ItemStack effMatSide, @Nonnull ItemStack effMatTrim, @Nonnull ItemStack effMatTopB, @Nonnull ItemStack matSide, @Nonnull ItemStack matTrim, @Nonnull ItemStack matTopB, boolean mergeLayers) {
        super(state, mergeLayers, new Object[]{effMatSide, effMatTrim, effMatTopB, matSide, matTrim, matTopB});
    }

    public static IBakedModel fromBlock(IBlockState state) {
        if (!(state instanceof IExtendedBlockState)) {
            return new CustomSlaveModel(state, false);
        }
        IExtendedBlockState xState = (IExtendedBlockState)state;
        MaterialModelData matModel = (MaterialModelData)xState.getValue(BlockDrawersCustom.MAT_MODEL);
        if (matModel == null) {
            return new CustomSlaveModel(state, false);
        }
        ItemStack effMatSide = matModel.getEffectiveMaterialSide();
        ItemStack effMatTrim = matModel.getEffectiveMaterialTrim();
        ItemStack effMatTopB = matModel.getEffectiveMaterialFront();
        ItemStack matSide = matModel.getMaterialSide();
        ItemStack matTrim = matModel.getMaterialTrim();
        ItemStack matTopB = matModel.getMaterialFront();
        return new CustomSlaveModel(state, effMatSide, effMatTrim, effMatTopB, matSide, matTrim, matTopB, false);
    }

    public static IBakedModel fromItem(@Nonnull ItemStack stack) {
        IBlockState state = ModBlocks.framedSlave.func_176223_P();
        if (!stack.func_77942_o()) {
            return new CustomSlaveModel(state, true);
        }
        NBTTagCompound tag = stack.func_77978_p();
        ItemStack matSide = ItemStack.field_190927_a;
        ItemStack matTrim = ItemStack.field_190927_a;
        ItemStack matTopB = ItemStack.field_190927_a;
        assert (tag != null);
        if (tag.func_150297_b("MatS", 10)) {
            matSide = new ItemStack(tag.func_74775_l("MatS"));
        }
        if (tag.func_150297_b("MatT", 10)) {
            matTrim = new ItemStack(tag.func_74775_l("MatT"));
        }
        if (tag.func_150297_b("MatF", 10)) {
            matTopB = new ItemStack(tag.func_74775_l("MatF"));
        }
        ItemStack effMatTopB = !matTopB.func_190926_b() ? matTopB : matSide;
        ItemStack effMatTrim = !matTrim.func_190926_b() ? matTrim : matSide;
        ItemStack effMatSide = matSide;
        CustomSlaveModel model = new CustomSlaveModel(state, effMatSide, effMatTrim, effMatTopB, matSide, matTrim, matTopB, true);
        if (!stack.func_77978_p().func_150297_b("tile", 10)) {
            return model;
        }
        return new DrawerSealedModel((IBakedModel)model, state, true);
    }

    protected void renderMippedLayer(ChamRender renderer, IBlockState state, Object ... args) {
        TextureAtlasSprite iconTopB;
        ItemStack itemSide = (ItemStack)args[0];
        ItemStack itemTrim = (ItemStack)args[1];
        ItemStack itemTopB = (ItemStack)args[2];
        TextureAtlasSprite iconSide = !itemSide.func_190926_b() ? IconUtil.getIconFromStack((ItemStack)itemSide) : null;
        TextureAtlasSprite iconTrim = !itemTrim.func_190926_b() ? IconUtil.getIconFromStack((ItemStack)itemTrim) : null;
        TextureAtlasSprite textureAtlasSprite = iconTopB = !itemTopB.func_190926_b() ? IconUtil.getIconFromStack((ItemStack)itemTopB) : null;
        if (iconTrim == null) {
            iconTrim = iconSide;
        }
        if (iconSide == null) {
            iconSide = Chameleon.instance.iconRegistry.getIcon(Register.iconDefaultSide);
        }
        if (iconTrim == null) {
            iconTrim = Chameleon.instance.iconRegistry.getIcon(Register.iconDefaultSide);
        }
        if (iconTopB == null) {
            iconTopB = Chameleon.instance.iconRegistry.getIcon(Register.iconDefaultTopBottom);
        }
        this.iconParticle = iconSide;
        SlaveRenderer slaveRenderer = new SlaveRenderer(renderer);
        slaveRenderer.renderBasePass(null, state, BlockPos.field_177992_a, iconSide, iconTrim, iconTopB);
    }

    protected void renderTransLayer(ChamRender renderer, IBlockState state, Object ... args) {
        TextureAtlasSprite iconOverlaySide = Chameleon.instance.iconRegistry.getIcon(Register.iconOverlaySide);
        SlaveRenderer slaveRenderer = new SlaveRenderer(renderer);
        slaveRenderer.renderOverlayPass(null, state, BlockPos.field_177992_a, iconOverlaySide);
    }

    @Nonnull
    public TextureAtlasSprite func_177554_e() {
        return this.iconParticle;
    }

    public ItemOverrideList func_188617_f() {
        return null;
    }

    private static class ItemHandler
    extends ItemOverrideList {
        public ItemHandler() {
            super((List)ImmutableList.of());
        }

        @Nonnull
        public IBakedModel handleItemState(@Nonnull IBakedModel originalModel, @Nonnull ItemStack stack, World world, EntityLivingBase entity) {
            return CustomSlaveModel.fromItem(stack);
        }
    }

    public static class Model
    extends ProxyBuilderModel {
        public Model() {
            super(Chameleon.instance.iconRegistry.getIcon(Register.iconDefaultSide));
        }

        protected IBakedModel buildModel(IBlockState state, IBakedModel parent) {
            try {
                return CustomSlaveModel.fromBlock(state);
            }
            catch (Throwable t) {
                return parent;
            }
        }

        public ItemOverrideList func_188617_f() {
            return itemHandler;
        }

        public List<Object> getKey(IBlockState state) {
            try {
                ArrayList<Object> key = new ArrayList<Object>();
                IExtendedBlockState xState = (IExtendedBlockState)state;
                key.add(xState.getValue(BlockDrawersCustom.MAT_MODEL));
                return key;
            }
            catch (Throwable t) {
                return super.getKey(state);
            }
        }
    }

    public static class Register
    extends DefaultRegister<BlockSlaveCustom> {
        public static final ResourceLocation iconDefaultSide = new ResourceLocation("framedcompactdrawers:blocks/raw_side");
        public static final ResourceLocation iconDefaultTopBottom = new ResourceLocation("framedcompactdrawers:blocks/slave_raw_top_bottom");
        public static final ResourceLocation iconOverlaySide = new ResourceLocation("framedcompactdrawers", "blocks/overlay/shading_side");

        public Register() {
            super((Block)ModBlocks.framedSlave);
        }

        public List<IBlockState> getBlockStates() {
            return Collections.singletonList(ModBlocks.framedSlave.func_176223_P());
        }

        public IBakedModel getModel(IBlockState state, IBakedModel existingModel) {
            return new CachedBuilderModel((ProxyBuilderModel)new Model());
        }

        public IBakedModel getModel(ItemStack stack, IBakedModel existingModel) {
            return new CachedBuilderModel((ProxyBuilderModel)new Model());
        }

        public List<ResourceLocation> getTextureResources() {
            ArrayList<ResourceLocation> resource = new ArrayList<ResourceLocation>();
            resource.add(iconDefaultSide);
            resource.add(iconOverlaySide);
            resource.add(iconDefaultTopBottom);
            return resource;
        }
    }
}

