/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.init;

import cofh.core.enchantment.EnchantmentHolding;
import cofh.core.enchantment.EnchantmentInsight;
import cofh.core.enchantment.EnchantmentLeech;
import cofh.core.enchantment.EnchantmentMultishot;
import cofh.core.enchantment.EnchantmentSmashing;
import cofh.core.enchantment.EnchantmentSmelting;
import cofh.core.enchantment.EnchantmentSoulbound;
import cofh.core.enchantment.EnchantmentVorpal;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class CoreEnchantments {
    public static final CoreEnchantments INSTANCE = new CoreEnchantments();
    public static boolean disableAll = false;
    public static boolean registered = false;
    public static Enchantment holding;
    public static Enchantment insight;
    public static Enchantment leech;
    public static Enchantment multishot;
    public static Enchantment smashing;
    public static Enchantment smelting;
    public static Enchantment soulbound;
    public static Enchantment vorpal;

    private CoreEnchantments() {
    }

    public static void preInit() {
        holding = new EnchantmentHolding("cofhcore:holding");
        insight = new EnchantmentInsight("cofhcore:insight");
        leech = new EnchantmentLeech("cofhcore:leech");
        multishot = new EnchantmentMultishot("cofhcore:multishot");
        smashing = new EnchantmentSmashing("cofhcore:smashing");
        smelting = new EnchantmentSmelting("cofhcore:smelting");
        soulbound = new EnchantmentSoulbound("cofhcore:soulbound");
        vorpal = new EnchantmentVorpal("cofhcore:vorpal");
    }

    public static void register() {
        if (disableAll || registered) {
            return;
        }
        ModContainer callingContainer = Loader.instance().activeModContainer();
        ModContainer cofhContainer = FMLCommonHandler.instance().findContainerFor((Object)"cofhcore");
        Loader.instance().setActiveModContainer(cofhContainer);
        MinecraftForge.EVENT_BUS.register((Object)INSTANCE);
        registered = true;
        Loader.instance().setActiveModContainer(callingContainer);
    }

    public static boolean registered() {
        return registered;
    }

    @SubscribeEvent
    public void registerEnchantments(RegistryEvent.Register<Enchantment> event) {
        IForgeRegistry registry = event.getRegistry();
        registry.register((IForgeRegistryEntry)holding);
        registry.register((IForgeRegistryEntry)insight);
        registry.register((IForgeRegistryEntry)leech);
        registry.register((IForgeRegistryEntry)multishot);
        registry.register((IForgeRegistryEntry)smashing);
        registry.register((IForgeRegistryEntry)smelting);
        registry.register((IForgeRegistryEntry)soulbound);
        registry.register((IForgeRegistryEntry)vorpal);
    }

    public static void addEnchantment(ItemStack stack, Enchantment ench, int level) {
        CoreEnchantments.addEnchantment(stack.func_77978_p(), Enchantment.func_185258_b((Enchantment)ench), level);
    }

    public static void addEnchantment(NBTTagCompound nbt, Enchantment ench, int level) {
        CoreEnchantments.addEnchantment(nbt, Enchantment.func_185258_b((Enchantment)ench), level);
    }

    public static void addEnchantment(ItemStack stack, int id, int level) {
        CoreEnchantments.addEnchantment(stack.func_77978_p(), id, level);
    }

    public static void addEnchantment(NBTTagCompound nbt, int id, int level) {
        if (nbt == null) {
            nbt = new NBTTagCompound();
        }
        NBTTagList list = CoreEnchantments.getEnchantmentTagList(nbt);
        boolean found = false;
        for (int i = 0; i < list.func_74745_c() && !found; ++i) {
            NBTTagCompound tag = list.func_150305_b(i);
            if (tag.func_74765_d("id") != id) continue;
            tag.func_74777_a("id", (short)id);
            tag.func_74777_a("lvl", (short)level);
            found = true;
        }
        if (!found) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74777_a("id", (short)id);
            tag.func_74777_a("lvl", (short)level);
            list.func_74742_a((NBTBase)tag);
        }
        nbt.func_74782_a("ench", (NBTBase)list);
    }

    private static NBTTagList getEnchantmentTagList(NBTTagCompound nbt) {
        return nbt.func_150295_c("ench", 10);
    }
}

