/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.util.helpers;

import cofh.core.util.helpers.BlockHelper;
import cofh.core.util.helpers.StringHelper;
import com.google.common.collect.Lists;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionUtils;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;

public class FluidHelper {
    public static final int BUCKET_VOLUME = 1000;
    public static final Fluid WATER_FLUID = FluidRegistry.WATER;
    public static final Fluid LAVA_FLUID = FluidRegistry.LAVA;
    public static final FluidStack WATER = new FluidStack(WATER_FLUID, 1000);
    public static final FluidStack LAVA = new FluidStack(LAVA_FLUID, 1000);
    @CapabilityInject(value=IFluidHandler.class)
    public static final Capability<IFluidHandler> FLUID_HANDLER = null;
    @CapabilityInject(value=IFluidHandlerItem.class)
    public static final Capability<IFluidHandler> FLUID_HANDLER_ITEM = null;
    public static final FluidTankInfo[] NULL_TANK_INFO = new FluidTankInfo[0];

    private FluidHelper() {
    }

    public static boolean isPlayerHoldingFluidHandler(EntityPlayer player) {
        return FluidHelper.isFluidHandler(player.func_184614_ca());
    }

    public static FluidStack getFluidStackFromHandler(ItemStack container) {
        if (FluidHelper.isFluidHandler(container)) {
            IFluidTankProperties[] tank = ((IFluidHandler)container.getCapability(FLUID_HANDLER_ITEM, null)).getTankProperties();
            return tank.length <= 0 ? null : tank[0].getContents();
        }
        return null;
    }

    public static boolean isFluidHandler(ItemStack stack) {
        return !stack.func_190926_b() && stack.hasCapability(FLUID_HANDLER_ITEM, null);
    }

    public static boolean isFillableEmptyContainer(ItemStack empty) {
        IFluidTankProperties[] tankProperties;
        IFluidHandlerItem fluidHandler = FluidUtil.getFluidHandler((ItemStack)empty);
        if (fluidHandler == null) {
            return false;
        }
        for (IFluidTankProperties properties : tankProperties = fluidHandler.getTankProperties()) {
            if (!properties.canFill()) {
                return false;
            }
            FluidStack contents = properties.getContents();
            if (contents == null || contents.amount <= 0) continue;
            return false;
        }
        return true;
    }

    public static boolean isDrainableFilledContainer(ItemStack container) {
        IFluidTankProperties[] tankProperties;
        IFluidHandlerItem fluidHandler = FluidUtil.getFluidHandler((ItemStack)container);
        if (fluidHandler == null) {
            return false;
        }
        for (IFluidTankProperties properties : tankProperties = fluidHandler.getTankProperties()) {
            if (!properties.canDrain()) {
                return false;
            }
            FluidStack contents = properties.getContents();
            if (contents != null && contents.amount >= properties.getCapacity()) continue;
            return false;
        }
        return true;
    }

    public static ItemStack setDefaultFluidTag(ItemStack container, FluidStack resource) {
        container.func_77982_d(new NBTTagCompound());
        NBTTagCompound fluidTag = resource.writeToNBT(new NBTTagCompound());
        container.func_77978_p().func_74782_a("Fluid", (NBTBase)fluidTag);
        return container;
    }

    public static FluidStack extractFluidFromAdjacentFluidHandler(TileEntity tile, EnumFacing side, int maxDrain, boolean doDrain) {
        TileEntity handler = BlockHelper.getAdjacentTileEntity(tile, side);
        if (handler != null && handler.hasCapability(FLUID_HANDLER, side.func_176734_d())) {
            IFluidHandler cap = (IFluidHandler)handler.getCapability(FLUID_HANDLER, side.func_176734_d());
            return cap != null ? cap.drain(maxDrain, doDrain) : null;
        }
        return null;
    }

    public static int insertFluidIntoAdjacentFluidHandler(TileEntity tile, EnumFacing side, FluidStack fluid, boolean doFill) {
        TileEntity handler = BlockHelper.getAdjacentTileEntity(tile, side);
        if (handler != null && handler.hasCapability(FLUID_HANDLER, side.func_176734_d())) {
            IFluidHandler cap = (IFluidHandler)handler.getCapability(FLUID_HANDLER, side.func_176734_d());
            return cap != null ? cap.fill(fluid, doFill) : 0;
        }
        return 0;
    }

    public static int insertFluidIntoAdjacentFluidHandler(World world, BlockPos pos, EnumFacing side, FluidStack fluid, boolean doFill) {
        TileEntity handler = BlockHelper.getAdjacentTileEntity(world, pos, side);
        if (handler != null && handler.hasCapability(FLUID_HANDLER, side.func_176734_d())) {
            IFluidHandler cap = (IFluidHandler)handler.getCapability(FLUID_HANDLER, side.func_176734_d());
            return cap != null ? cap.fill(fluid, doFill) : 0;
        }
        return 0;
    }

    public static boolean isAdjacentFluidHandler(TileEntity tile, EnumFacing side) {
        TileEntity handler = BlockHelper.getAdjacentTileEntity(tile, side);
        return handler != null && handler.hasCapability(FLUID_HANDLER, side.func_176734_d());
    }

    public static boolean isFluidHandler(TileEntity tile, EnumFacing face) {
        return tile != null && tile.hasCapability(FLUID_HANDLER, face);
    }

    public static boolean isFluidHandler(TileEntity tile) {
        return tile != null && tile.hasCapability(FLUID_HANDLER, null);
    }

    public static boolean drainItemToHandler(ItemStack stack, IFluidHandler handler, EntityPlayer player, EnumHand hand) {
        if (stack.func_190926_b() || handler == null || player == null) {
            return false;
        }
        InvWrapper playerInv = new InvWrapper((IInventory)player.field_71071_by);
        FluidActionResult result = FluidUtil.tryEmptyContainerAndStow((ItemStack)stack, (IFluidHandler)handler, (IItemHandler)playerInv, (int)Integer.MAX_VALUE, (EntityPlayer)player);
        if (result.isSuccess()) {
            player.func_184611_a(hand, result.getResult());
            return true;
        }
        return false;
    }

    public static boolean fillItemFromHandler(ItemStack stack, IFluidHandler handler, EntityPlayer player, EnumHand hand) {
        if (stack.func_190926_b() || handler == null || player == null) {
            return false;
        }
        InvWrapper playerInv = new InvWrapper((IInventory)player.field_71071_by);
        FluidActionResult result = FluidUtil.tryFillContainerAndStow((ItemStack)stack, (IFluidHandler)handler, (IItemHandler)playerInv, (int)Integer.MAX_VALUE, (EntityPlayer)player);
        if (result.isSuccess()) {
            player.func_184611_a(hand, result.getResult());
            return true;
        }
        return false;
    }

    public static boolean interactWithHandler(ItemStack stack, IFluidHandler handler, EntityPlayer player, EnumHand hand) {
        return FluidHelper.fillItemFromHandler(stack, handler, player, hand) || FluidHelper.drainItemToHandler(stack, handler, player, hand);
    }

    public static void writeFluidStackToPacket(FluidStack fluid, DataOutput data) throws IOException {
        if (!FluidHelper.isValidFluidStack(fluid)) {
            data.writeShort(-1);
        } else {
            ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
            CompressedStreamTools.func_74799_a((NBTTagCompound)fluid.writeToNBT(new NBTTagCompound()), (OutputStream)byteStream);
            byte[] abyte = byteStream.toByteArray();
            data.writeShort((short)abyte.length);
            data.write(abyte);
        }
    }

    public static FluidStack readFluidStackFromPacket(DataInput data) throws IOException {
        short length = data.readShort();
        if (length < 0) {
            return null;
        }
        byte[] abyte = new byte[length];
        data.readFully(abyte);
        ByteArrayInputStream byteStream = new ByteArrayInputStream(abyte);
        return FluidStack.loadFluidStackFromNBT((NBTTagCompound)CompressedStreamTools.func_74796_a((InputStream)byteStream));
    }

    public static boolean isValidFluidStack(FluidStack fluid) {
        return fluid != null && FluidRegistry.getFluidName((FluidStack)fluid) != null;
    }

    public static int getFluidLuminosity(FluidStack fluid) {
        return fluid == null ? 0 : FluidHelper.getFluidLuminosity(fluid.getFluid());
    }

    public static int getFluidLuminosity(Fluid fluid) {
        return fluid == null ? 0 : fluid.getLuminosity();
    }

    public static FluidStack getFluidFromWorld(World world, BlockPos pos, boolean doDrain) {
        IBlockState state = world.func_180495_p(pos);
        Block bId = state.func_177230_c();
        int bMeta = bId.func_176201_c(state);
        if (Block.func_149680_a((Block)bId, (Block)Blocks.field_150355_j)) {
            if (bMeta == 0) {
                return WATER.copy();
            }
            return null;
        }
        if (Block.func_149680_a((Block)bId, (Block)Blocks.field_150353_l) || Block.func_149680_a((Block)bId, (Block)Blocks.field_150356_k)) {
            if (bMeta == 0) {
                return LAVA.copy();
            }
            return null;
        }
        if (bId instanceof IFluidBlock) {
            IFluidBlock block = (IFluidBlock)bId;
            return block.drain(world, pos, doDrain);
        }
        return null;
    }

    public static FluidStack getFluidFromWorld(World world, BlockPos pos) {
        return FluidHelper.getFluidFromWorld(world, pos, false);
    }

    public static Fluid lookupFluidForBlock(Block block) {
        if (block == Blocks.field_150358_i) {
            return WATER_FLUID;
        }
        if (block == Blocks.field_150356_k) {
            return LAVA_FLUID;
        }
        return FluidRegistry.lookupFluidForBlock((Block)block);
    }

    public static FluidStack getFluidForFilledItem(ItemStack container) {
        if (container != null && FluidHelper.isFluidHandler(container)) {
            return FluidHelper.getFluidStackFromHandler(container);
        }
        return null;
    }

    public static boolean isFluidEqualOrNull(FluidStack resourceA, FluidStack resourceB) {
        return resourceA == null || resourceB == null || resourceA.isFluidEqual(resourceB);
    }

    public static boolean isFluidEqualOrNull(Fluid fluidA, FluidStack resourceB) {
        return fluidA == null || resourceB == null || fluidA == resourceB.getFluid();
    }

    public static boolean isFluidEqualOrNull(Fluid fluidA, Fluid fluidB) {
        return fluidA == null || fluidB == null || fluidA == fluidB;
    }

    public static boolean isFluidEqual(FluidStack resourceA, FluidStack resourceB) {
        return resourceA != null && resourceA.isFluidEqual(resourceB);
    }

    public static boolean isFluidEqual(Fluid fluidA, FluidStack resourceB) {
        return fluidA != null && resourceB != null && fluidA == resourceB.getFluid();
    }

    public static boolean isFluidEqual(Fluid fluidA, Fluid fluidB) {
        return fluidA != null && fluidB != null && fluidA.equals(fluidB);
    }

    public static int getFluidHash(FluidStack stack) {
        return stack.tag != null ? stack.getFluid().getName().hashCode() + 31 * stack.tag.toString().hashCode() : stack.getFluid().getName().hashCode();
    }

    public static boolean isPotionFluid(FluidStack stack) {
        return stack != null && stack.tag != null && stack.tag.func_74764_b("Potion");
    }

    public static void addPotionTooltip(FluidStack stack, List<String> list) {
        FluidHelper.addPotionTooltip(stack, list, 1.0f);
    }

    public static void addPotionTooltip(FluidStack stack, List<String> list, float durationFactor) {
        if (stack == null) {
            return;
        }
        List effects = PotionUtils.func_185185_a((NBTTagCompound)stack.tag);
        ArrayList list1 = Lists.newArrayList();
        if (effects.isEmpty()) {
            String s = StringHelper.localize("effect.none").trim();
            list.add(TextFormatting.GRAY + s);
        } else {
            for (PotionEffect effect : effects) {
                String s1 = StringHelper.localize(effect.func_76453_d()).trim();
                Potion potion = effect.func_188419_a();
                Map map = potion.func_111186_k();
                if (!map.isEmpty()) {
                    for (Map.Entry entry : map.entrySet()) {
                        AttributeModifier attributemodifier = (AttributeModifier)entry.getValue();
                        AttributeModifier attributemodifier1 = new AttributeModifier(attributemodifier.func_111166_b(), potion.func_111183_a(effect.func_76458_c(), attributemodifier), attributemodifier.func_111169_c());
                        list1.add(new Tuple((Object)((IAttribute)entry.getKey()).func_111108_a(), (Object)attributemodifier1));
                    }
                }
                if (effect.func_76458_c() > 0) {
                    s1 = s1 + " " + StringHelper.localize("potion.potency." + effect.func_76458_c()).trim();
                }
                if (effect.func_76459_b() > 20) {
                    s1 = s1 + " (" + Potion.func_188410_a((PotionEffect)effect, (float)durationFactor) + ")";
                }
                if (potion.func_76398_f()) {
                    list.add(TextFormatting.RED + s1);
                    continue;
                }
                list.add(TextFormatting.BLUE + s1);
            }
        }
        if (!list1.isEmpty()) {
            list.add("");
            list.add(TextFormatting.DARK_PURPLE + StringHelper.localize("potion.whenDrank"));
            for (Tuple tuple : list1) {
                AttributeModifier attributemodifier2 = (AttributeModifier)tuple.func_76340_b();
                double d0 = attributemodifier2.func_111164_d();
                double d1 = attributemodifier2.func_111169_c() != 1 && attributemodifier2.func_111169_c() != 2 ? attributemodifier2.func_111164_d() : attributemodifier2.func_111164_d() * 100.0;
                if (d0 > 0.0) {
                    list.add(TextFormatting.BLUE + StringHelper.localizeFormat("attribute.modifier.plus." + attributemodifier2.func_111169_c(), ItemStack.field_111284_a.format(d1), StringHelper.localize("attribute.name." + (String)tuple.func_76341_a())));
                    continue;
                }
                if (!(d0 < 0.0)) continue;
                list.add(TextFormatting.RED + StringHelper.localizeFormat("attribute.modifier.take." + attributemodifier2.func_111169_c(), ItemStack.field_111284_a.format(d1 *= -1.0), StringHelper.localize("attribute.name." + (String)tuple.func_76341_a())));
            }
        }
    }
}

