/*
 * Decompiled with CFR 0.152.
 */
package br.com.brforgers.mods.industrialexpansion.items;

import br.com.brforgers.mods.industrialexpansion.helper.DurabillityHelper;
import br.com.brforgers.mods.industrialexpansion.manager.ItemManager;
import cofh.core.init.CoreEnchantments;
import cofh.core.item.IEnchantableItem;
import cofh.core.item.ItemArmorCore;
import cofh.core.util.helpers.EnergyHelper;
import cofh.core.util.helpers.ItemHelper;
import cofh.core.util.helpers.MathHelper;
import cofh.core.util.helpers.StringHelper;
import cofh.redstoneflux.api.IEnergyContainerItem;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.common.ISpecialArmor;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class QuantumArmor
extends ItemArmorCore
implements ISpecialArmor,
IEnergyContainerItem,
IEnchantableItem {
    public static final ISpecialArmor.ArmorProperties QUANTUM = new ISpecialArmor.ArmorProperties(0, 0.2, Integer.MAX_VALUE);
    public int maxEnergy = 25000000;
    public int maxTransfer = 50000;
    public double absorbRatio = 1.0E7;
    public int energyPerDamage = 20000;
    public String[] textures = new String[2];

    public QuantumArmor(ItemArmor.ArmorMaterial material, EntityEquipmentSlot type) {
        super(material, type);
    }

    public QuantumArmor setEnergyParams(int maxEnergy, int maxTransfer) {
        this.maxEnergy = maxEnergy;
        this.maxTransfer = maxTransfer;
        return this;
    }

    public boolean func_82789_a(ItemStack itemToRepair, ItemStack stack) {
        return false;
    }

    public EnumRarity func_77613_e(ItemStack stack) {
        return EnumRarity.UNCOMMON;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        if (StringHelper.displayShiftForDetail && !StringHelper.isShiftKeyDown()) {
            tooltip.add(StringHelper.shiftForDetails());
        }
        if (!StringHelper.isShiftKeyDown()) {
            return;
        }
        if (stack.func_77978_p() == null) {
            EnergyHelper.setDefaultEnergyTag((ItemStack)stack, (int)0);
        }
        tooltip.add(StringHelper.localize((String)"info.cofh.charge") + ": " + stack.func_77978_p().func_74762_e("Energy") + " / " + this.maxEnergy + " RF");
    }

    public void setDamage(ItemStack stack, int damage) {
        super.setDamage(stack, 0);
    }

    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return !ItemHelper.areItemStacksEqualIgnoreTags((ItemStack)oldStack, (ItemStack)newStack, (String[])new String[]{"Energy"});
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        if (stack.func_77978_p() == null) {
            EnergyHelper.setDefaultEnergyTag((ItemStack)stack, (int)0);
        }
        return 1.0 - (double)stack.func_77978_p().func_74762_e("Energy") / (double)this.maxEnergy;
    }

    public int getMaxDamage(ItemStack stack) {
        return 0;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return DurabillityHelper.showArmorCharge;
    }

    public boolean isDamaged(ItemStack stack) {
        return true;
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        if (this.func_194125_a(tab) && this.showInCreative) {
            list.add((Object)EnergyHelper.setDefaultEnergyTag((ItemStack)new ItemStack((Item)this, 1, 0), (int)0));
            list.add((Object)EnergyHelper.setDefaultEnergyTag((ItemStack)new ItemStack((Item)this, 1, 0), (int)this.maxEnergy));
        }
    }

    protected int getBaseAbsorption() {
        return 20;
    }

    protected int getAbsorptionRatio() {
        switch (this.field_77881_a) {
            case HEAD: {
                return 15;
            }
            case CHEST: {
                return 40;
            }
            case LEGS: {
                return 30;
            }
            case FEET: {
                return 15;
            }
        }
        return 0;
    }

    protected int getEnergyPerDamage(ItemStack stack) {
        int unbreakingLevel = MathHelper.clamp((int)EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185307_s, (ItemStack)stack), (int)0, (int)4);
        return this.energyPerDamage * (5 - unbreakingLevel) / 5;
    }

    public ISpecialArmor.ArmorProperties getProperties(EntityLivingBase player, @Nonnull ItemStack armor, DamageSource source, double damage, int slot) {
        if ("quantum".equals(source.field_76373_n)) {
            return QUANTUM;
        }
        if (source.func_76363_c()) {
            int absorbMax = this.getEnergyPerDamage(armor) > 0 ? 25 * this.getEnergyStored(armor) / this.getEnergyPerDamage(armor) : 0;
            return new ISpecialArmor.ArmorProperties(0, this.absorbRatio * (double)this.func_82812_d().func_78044_b(this.field_77881_a) * 0.025, absorbMax);
        }
        int absorbMax = this.getEnergyPerDamage(armor) > 0 ? 25 * this.getEnergyStored(armor) / this.getEnergyPerDamage(armor) : 0;
        return new ISpecialArmor.ArmorProperties(0, this.absorbRatio * (double)this.func_82812_d().func_78044_b(this.field_77881_a) * 0.05, absorbMax);
    }

    public int getArmorDisplay(EntityPlayer player, @Nonnull ItemStack armor, int slot) {
        if (this.getEnergyStored(armor) >= this.getEnergyPerDamage(armor)) {
            return Math.min(this.getBaseAbsorption(), 20) * this.getAbsorptionRatio() / 100;
        }
        return 0;
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack armor) {
        if (world.field_72995_K) {
            return;
        }
        if (this.getEnergyStored(armor) >= this.getEnergyPerDamage(armor)) {
            if (armor.func_77973_b() == ItemManager.itemLegsQuantum) {
                player.func_70690_d(new PotionEffect(MobEffects.field_76424_c, 260, 4, true, false));
            }
            if (armor.func_77973_b() == ItemManager.itemPlateQuantum) {
                player.func_70690_d(new PotionEffect(MobEffects.field_76443_y, 260, 4, true, false));
            }
            if (armor.func_77973_b() == ItemManager.itemHelmetQuantum) {
                player.func_70690_d(new PotionEffect(MobEffects.field_76439_r, 260, 0, true, false));
            }
        }
    }

    public void damageArmor(EntityLivingBase entity, @Nonnull ItemStack armor, DamageSource source, int damage, int slot) {
        if (source.func_76347_k() || source.field_76373_n.equals("darkness")) {
            return;
        }
        if (source.field_76373_n.equals("quantum")) {
            boolean p = source.func_76346_g() == null;
            this.receiveEnergy(armor, damage * (p ? this.energyPerDamage / 2 : this.getEnergyPerDamage(armor)), false);
        } else {
            this.extractEnergy(armor, damage * this.getEnergyPerDamage(armor), false);
        }
    }

    public int receiveEnergy(ItemStack container, int maxReceive, boolean simulate) {
        if (container.func_77978_p() == null) {
            EnergyHelper.setDefaultEnergyTag((ItemStack)container, (int)0);
        }
        int stored = container.func_77978_p().func_74762_e("Energy");
        int receive = Math.min(maxReceive, Math.min(this.maxEnergy - stored, this.maxTransfer));
        if (!simulate) {
            container.func_77978_p().func_74768_a("Energy", stored += receive);
        }
        return receive;
    }

    public int extractEnergy(ItemStack container, int maxExtract, boolean simulate) {
        if (container.func_77978_p() == null) {
            EnergyHelper.setDefaultEnergyTag((ItemStack)container, (int)0);
        }
        int stored = container.func_77978_p().func_74762_e("Energy");
        int extract = Math.min(maxExtract, stored);
        if (!simulate) {
            container.func_77978_p().func_74768_a("Energy", stored -= extract);
        }
        return extract;
    }

    public int getEnergyStored(ItemStack container) {
        if (container.func_77978_p() == null) {
            EnergyHelper.setDefaultEnergyTag((ItemStack)container, (int)0);
        }
        return container.func_77978_p().func_74762_e("Energy");
    }

    public int getMaxEnergyStored(ItemStack container) {
        return this.maxEnergy;
    }

    public boolean canEnchant(ItemStack itemStack, Enchantment enchantment) {
        return enchantment == CoreEnchantments.holding;
    }
}

