/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.agriculture.agricraft;

import com.google.common.collect.Lists;
import com.infinityraider.agricraft.api.v1.AgriApi;
import com.infinityraider.agricraft.api.v1.crop.IAgriCrop;
import com.infinityraider.agricraft.api.v1.plant.IAgriPlant;
import com.infinityraider.agricraft.api.v1.render.RenderMethod;
import com.infinityraider.agricraft.api.v1.requirement.BlockCondition;
import com.infinityraider.agricraft.api.v1.requirement.IGrowthReqBuilder;
import com.infinityraider.agricraft.api.v1.requirement.IGrowthRequirement;
import com.infinityraider.agricraft.api.v1.soil.IAgriSoilRegistry;
import com.infinityraider.agricraft.api.v1.stat.IAgriStat;
import com.infinityraider.agricraft.api.v1.util.BlockRange;
import com.infinityraider.agricraft.api.v1.util.FuzzyStack;
import com.infinityraider.agricraft.farming.PlantStats;
import com.infinityraider.agricraft.farming.growthrequirement.GrowthReqBuilder;
import com.infinityraider.agricraft.init.AgriItems;
import com.infinityraider.infinitylib.render.tessellation.ITessellator;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.Pair;
import thelm.jaopca.agriculture.agricraft.EnumRenderType;
import thelm.jaopca.agriculture.agricraft.IAgriPlantWithProperty;
import thelm.jaopca.agriculture.agricraft.JAOPCAPlantRenderer;
import thelm.jaopca.api.IOreEntry;
import thelm.jaopca.api.ItemEntry;
import thelm.jaopca.api.utils.Utils;

public class AgriPlantBase
implements IAgriPlant,
IAgriPlantWithProperty {
    public final IOreEntry oreEntry;
    public final ItemEntry itemEntry;
    protected List<String> seedFormats = Lists.newArrayList();
    protected double grassDropChance = 0.0;
    protected double seedDropChance = 1.0;
    protected double seedDropBonus = 0.0;
    protected Collection<FuzzyStack> seedItems = null;
    protected double growthChance = 0.9;
    protected double growthBonus = 0.025;
    protected boolean fertilizable = false;
    protected boolean weed = false;
    protected boolean aggressive = false;
    protected double spreadChance = 0.1;
    protected double spawnChance = 0.0;
    protected List<IAgriPlantWithProperty.Product> products = Lists.newArrayList();
    protected int minLight = 10;
    protected int maxLight = 16;
    protected List<String> soils = Lists.newArrayList();
    protected List<IAgriPlantWithProperty.Condition> conditions = Lists.newArrayList();
    protected IGrowthRequirement growthRequirement = null;
    protected List<List<Pair<String, Boolean>>> textures = Lists.newArrayList();
    protected EnumRenderType renderType = EnumRenderType.HASH;

    public AgriPlantBase(ItemEntry itemEntry, IOreEntry oreEntry) {
        this.itemEntry = itemEntry;
        this.oreEntry = oreEntry;
    }

    public ItemEntry getItemEntry() {
        return this.itemEntry;
    }

    public IOreEntry getOreEntry() {
        return this.oreEntry;
    }

    public String getId() {
        return Utils.to_under_score((String)this.getOreEntry().getOreName()) + '_' + this.getItemEntry().name + "_plant";
    }

    public String getUnlocalizedPlantName() {
        return "plant.jaopca." + this.itemEntry.name;
    }

    public String getPlantName() {
        return Utils.smartLocalize((String)this.getUnlocalizedPlantName(), (String)(this.getUnlocalizedPlantName() + ".%s"), (IOreEntry)this.getOreEntry());
    }

    public String getUnlocalizedInformation() {
        return "plant.desc.jaopca." + this.itemEntry.name;
    }

    public String getInformation() {
        return Utils.smartLocalize((String)this.getUnlocalizedInformation(), (String)(this.getUnlocalizedInformation() + ".%s"), (IOreEntry)this.getOreEntry());
    }

    @Override
    public AgriPlantBase setSeedFormats(List<String> seedFormats) {
        this.seedFormats = seedFormats;
        return this;
    }

    @Override
    public AgriPlantBase setGrassDropChance(double grassDropChance) {
        this.grassDropChance = grassDropChance;
        return this;
    }

    @Override
    public AgriPlantBase setSeedDropChance(double seedDropChance) {
        this.seedDropChance = seedDropChance;
        return this;
    }

    @Override
    public AgriPlantBase setSeedDropBonus(double seedDropBonus) {
        this.seedDropBonus = seedDropBonus;
        return this;
    }

    public Collection<FuzzyStack> getSeedItems() {
        if (this.seedItems == null) {
            this.seedItems = this.seedFormats.stream().map(format -> AgriPlantBase.toFuzzyStack(format, this.getOreEntry(), 1)).collect(Collectors.toList());
        }
        return this.seedItems;
    }

    public double getGrassDropChance() {
        return this.grassDropChance;
    }

    public double getSeedDropChanceBase() {
        return this.seedDropChance;
    }

    public double getSeedDropChanceBonus() {
        return this.seedDropBonus;
    }

    public ItemStack getSeed() {
        ItemStack stack = this.getSeedItems().stream().map(FuzzyStack::toStack).findFirst().orElse(new ItemStack((Item)AgriItems.getInstance().AGRI_SEED));
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a("agri_seed", this.getId());
        new PlantStats().writeToNBT(tag);
        stack.func_77982_d(tag);
        return stack;
    }

    public String getSeedName() {
        return this.getSeed().func_82833_r();
    }

    public int getTier() {
        return 1;
    }

    @Override
    public AgriPlantBase setGrowthChance(double growthChance) {
        this.growthChance = growthChance;
        return this;
    }

    @Override
    public AgriPlantBase setGrowthBonus(double growthBonus) {
        this.growthBonus = growthBonus;
        return this;
    }

    @Override
    public AgriPlantBase setFertilizable(boolean fertilizable) {
        this.fertilizable = fertilizable;
        return this;
    }

    @Override
    public AgriPlantBase setWeed(boolean weed) {
        this.weed = weed;
        return this;
    }

    @Override
    public AgriPlantBase setAggressive(boolean aggressive) {
        this.aggressive = aggressive;
        return this;
    }

    @Override
    public AgriPlantBase setSpreadChance(double spreadChance) {
        this.spreadChance = spreadChance;
        return this;
    }

    @Override
    public AgriPlantBase setSpawnChance(double spawnChance) {
        this.spawnChance = spawnChance;
        return this;
    }

    public double getGrowthChanceBase() {
        return this.growthChance;
    }

    public double getGrowthChanceBonus() {
        return this.growthBonus;
    }

    public boolean isFertilizable() {
        return this.fertilizable;
    }

    public boolean isWeed() {
        return this.weed;
    }

    public boolean isAggressive() {
        return this.aggressive;
    }

    public double getSpreadChance() {
        return this.spreadChance;
    }

    public double getSpawnChance() {
        return this.spawnChance;
    }

    @Override
    public AgriPlantBase setProducts(List<IAgriPlantWithProperty.Product> products) {
        this.products = products;
        return this;
    }

    public void getPossibleProducts(Consumer<ItemStack> consumer) {
        this.products.stream().map(product -> AgriPlantBase.toItemStack(product.format, this.getOreEntry(), 1)).forEach(consumer);
    }

    public void getHarvestProducts(Consumer<ItemStack> consumer, IAgriCrop crop, IAgriStat stat, Random rand) {
        this.products.stream().filter(product -> product.chance > rand.nextDouble()).map(product -> AgriPlantBase.toItemStack(product.format, this.getOreEntry(), product.min + rand.nextInt(product.range + 1))).forEach(consumer);
    }

    @Override
    public AgriPlantBase setMinLight(int minLight) {
        this.minLight = minLight;
        return this;
    }

    @Override
    public AgriPlantBase setMaxLight(int maxLight) {
        this.maxLight = maxLight;
        return this;
    }

    @Override
    public AgriPlantBase setSoils(List<String> soils) {
        this.soils = soils;
        return this;
    }

    @Override
    public AgriPlantBase setConditions(List<IAgriPlantWithProperty.Condition> conditions) {
        this.conditions = conditions;
        return this;
    }

    public IGrowthRequirement getGrowthRequirement() {
        if (this.growthRequirement == null) {
            GrowthReqBuilder builder = new GrowthReqBuilder();
            this.soils.stream().map(arg_0 -> ((IAgriSoilRegistry)AgriApi.getSoilRegistry()).get(arg_0)).filter(Optional::isPresent).map(Optional::get).forEach(arg_0 -> ((IGrowthReqBuilder)builder).addSoil(arg_0));
            this.conditions.stream().map(condition -> new BlockCondition(AgriPlantBase.toFuzzyStack(condition.format, this.getOreEntry(), 1), new BlockRange(condition.minX, condition.minY, condition.minZ, condition.maxX, condition.maxY, condition.maxZ))).forEach(arg_0 -> ((IGrowthReqBuilder)builder).addCondition(arg_0));
            builder.setMinLight(this.minLight);
            builder.setMaxLight(this.maxLight);
            this.growthRequirement = builder.build();
        }
        return this.growthRequirement;
    }

    @Override
    public AgriPlantBase setTextures(List<List<Pair<String, Boolean>>> textures) {
        this.textures = textures;
        return this;
    }

    public int getGrowthStages() {
        return this.textures.size();
    }

    @Override
    public AgriPlantBase setRenderType(EnumRenderType renderType) {
        this.renderType = renderType;
        return this;
    }

    public float getHeight(int meta) {
        return 0.8125f;
    }

    @SideOnly(value=Side.CLIENT)
    public List<BakedQuad> getPlantQuads(IExtendedBlockState state, int growthStage, EnumFacing direction, Function<ResourceLocation, TextureAtlasSprite> textureToIcon) {
        if (textureToIcon instanceof ITessellator) {
            JAOPCAPlantRenderer.renderPlant((ITessellator)textureToIcon, this.textures.get(growthStage), this.renderType, this.getOreEntry().getColor());
        }
        return Collections.emptyList();
    }

    @SideOnly(value=Side.CLIENT)
    public RenderMethod getRenderMethod() {
        return RenderMethod.CUSTOM;
    }

    @SideOnly(value=Side.CLIENT)
    public ResourceLocation getSeedTexture() {
        return TextureMap.field_174945_f;
    }

    @SideOnly(value=Side.CLIENT)
    public ResourceLocation getPrimaryPlantTexture(int meta) {
        return new ResourceLocation((String)this.textures.get(meta).get(0).getLeft());
    }

    @SideOnly(value=Side.CLIENT)
    public ResourceLocation getSecondaryPlantTexture(int meta) {
        return null;
    }

    public boolean equals(Object obj) {
        return obj instanceof IAgriPlant && this.getId().equals(((IAgriPlant)obj).getId());
    }

    public int hashCode() {
        return this.getId().hashCode();
    }

    public static ItemStack toItemStack(String format, IOreEntry ore, int amount) {
        return Utils.getOreStack((String)String.format(format, ore.getOreName()), (int)amount);
    }

    public static FuzzyStack toFuzzyStack(String format, IOreEntry ore, int amount) {
        return new FuzzyStack(AgriPlantBase.toItemStack(format, ore, amount), false, false, new String[]{"*"});
    }
}

