/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.agriculture.agricraft;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.function.Function;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import org.apache.commons.lang3.tuple.Pair;
import thelm.jaopca.agriculture.agricraft.AgriPlantProperties;
import thelm.jaopca.agriculture.agricraft.EnumRenderType;
import thelm.jaopca.api.EnumOreType;
import thelm.jaopca.api.IOreEntry;
import thelm.jaopca.api.utils.JsonUtils;

public class AgriPlantPropertiesDeserializer {
    public static final Type DOUBLE_FUNCTION_TYPE = new TypeToken<ToDoubleFunction<IOreEntry>>(){}.getType();
    public static final Type INT_FUNCTION_TYPE = new TypeToken<ToIntFunction<IOreEntry>>(){}.getType();

    public static AgriPlantProperties parseAgriPlantPpt(JsonObject json, JsonDeserializationContext context) throws JsonParseException {
        ArrayList seedFormatFuncs = Lists.newArrayList();
        if (JsonUtils.isJsonArray((JsonObject)json, (String)"seed_formats")) {
            JsonArray arr = JsonUtils.getJsonArray((JsonObject)json, (String)"seed_formats");
            for (JsonElement element : arr) {
                Function<EnumOreType, String> seedFormatFunc = AgriPlantPropertiesDeserializer.parseStringFunc(element, "seed_format", null);
                if (seedFormatFunc == null) continue;
                seedFormatFuncs.add(seedFormatFunc);
            }
        }
        ToDoubleFunction growthChanceFunc = (ToDoubleFunction)JsonUtils.deserializeClass((JsonObject)json, (String)"growth_chance", entry -> 0.9, (JsonDeserializationContext)context, (Type)DOUBLE_FUNCTION_TYPE);
        ToDoubleFunction growthBonusFunc = (ToDoubleFunction)JsonUtils.deserializeClass((JsonObject)json, (String)"growth_bonus", entry -> 0.025, (JsonDeserializationContext)context, (Type)DOUBLE_FUNCTION_TYPE);
        boolean fertilizable = JsonUtils.getBoolean((JsonObject)json, (String)"fertilizable", (boolean)false);
        boolean weed = JsonUtils.getBoolean((JsonObject)json, (String)"weed", (boolean)false);
        boolean aggressive = JsonUtils.getBoolean((JsonObject)json, (String)"aggressive", (boolean)false);
        ToDoubleFunction spreadChanceFunc = (ToDoubleFunction)JsonUtils.deserializeClass((JsonObject)json, (String)"spread_chance", entry -> 0.1, (JsonDeserializationContext)context, (Type)DOUBLE_FUNCTION_TYPE);
        ToDoubleFunction spawnChanceFunc = (ToDoubleFunction)JsonUtils.deserializeClass((JsonObject)json, (String)"spawn_chance", entry -> 0.0, (JsonDeserializationContext)context, (Type)DOUBLE_FUNCTION_TYPE);
        ToDoubleFunction grassDropChanceFunc = (ToDoubleFunction)JsonUtils.deserializeClass((JsonObject)json, (String)"grass_drop_chance", entry -> 0.0, (JsonDeserializationContext)context, (Type)DOUBLE_FUNCTION_TYPE);
        ToDoubleFunction seedDropChanceFunc = (ToDoubleFunction)JsonUtils.deserializeClass((JsonObject)json, (String)"seed_drop_chance", entry -> 0.0, (JsonDeserializationContext)context, (Type)DOUBLE_FUNCTION_TYPE);
        ToDoubleFunction seedDropBonusFunc = (ToDoubleFunction)JsonUtils.deserializeClass((JsonObject)json, (String)"seed_drop_bonus", entry -> 0.0, (JsonDeserializationContext)context, (Type)DOUBLE_FUNCTION_TYPE);
        ArrayList products = Lists.newArrayList();
        if (JsonUtils.isJsonArray((JsonObject)json, (String)"products")) {
            JsonArray arr = JsonUtils.getJsonArray((JsonObject)json, (String)"products");
            for (JsonElement element : arr) {
                JsonObject obj;
                Object formatFunc;
                if (!element.isJsonObject() || (formatFunc = AgriPlantPropertiesDeserializer.parseStringFunc(obj = element.getAsJsonObject(), "format", null)) == null) continue;
                ToIntFunction minFunc = (ToIntFunction)JsonUtils.deserializeClass((JsonObject)obj, (String)"min", entry -> 5, (JsonDeserializationContext)context, (Type)INT_FUNCTION_TYPE);
                ToIntFunction rangeFunc = (ToIntFunction)JsonUtils.deserializeClass((JsonObject)obj, (String)"range", entry -> 0, (JsonDeserializationContext)context, (Type)INT_FUNCTION_TYPE);
                ToDoubleFunction chanceFunc = (ToDoubleFunction)JsonUtils.deserializeClass((JsonObject)obj, (String)"chance", entry -> 0.99, (JsonDeserializationContext)context, (Type)DOUBLE_FUNCTION_TYPE);
                AgriPlantProperties.Product product = new AgriPlantProperties.Product();
                product.setMinFunc(minFunc).setRangeFunc(rangeFunc).setChanceFunc(chanceFunc).setFormatFunc((Function<EnumOreType, String>)formatFunc);
                products.add(product);
            }
        }
        int minLight = JsonUtils.getInt((JsonObject)json, (String)"min_light", (int)10);
        int maxLight = JsonUtils.getInt((JsonObject)json, (String)"max_light", (int)16);
        ArrayList soils = Lists.newArrayList();
        if (JsonUtils.isJsonArray((JsonObject)json, (String)"soils")) {
            JsonArray arr = JsonUtils.getJsonArray((JsonObject)json, (String)"soils");
            for (Iterator element : arr) {
                if (!JsonUtils.isString((JsonElement)element)) continue;
                soils.add(JsonUtils.getString((JsonElement)element, (String)"soil"));
            }
        }
        ArrayList conditions = Lists.newArrayList();
        if (JsonUtils.isJsonArray((JsonObject)json, (String)"conditions")) {
            JsonArray arr = JsonUtils.getJsonArray((JsonObject)json, (String)"conditions");
            for (JsonElement element : arr) {
                JsonObject obj;
                Function<EnumOreType, String> formatFunc;
                if (!element.isJsonObject() || (formatFunc = AgriPlantPropertiesDeserializer.parseStringFunc(obj = element.getAsJsonObject(), "format", null)) == null) continue;
                ToIntFunction amountFunc = (ToIntFunction)JsonUtils.deserializeClass((JsonObject)obj, (String)"amount", entry -> 1, (JsonDeserializationContext)context, (Type)INT_FUNCTION_TYPE);
                int minX = JsonUtils.getInt((JsonObject)obj, (String)"min_x", (int)0);
                int minY = JsonUtils.getInt((JsonObject)obj, (String)"min_y", (int)-2);
                int minZ = JsonUtils.getInt((JsonObject)obj, (String)"min_z", (int)0);
                int maxX = JsonUtils.getInt((JsonObject)obj, (String)"max_x", (int)minX);
                int maxY = JsonUtils.getInt((JsonObject)obj, (String)"max_y", (int)minY);
                int maxZ = JsonUtils.getInt((JsonObject)obj, (String)"max_z", (int)minZ);
                AgriPlantProperties.Condition condition = new AgriPlantProperties.Condition();
                condition.setAmountFunc(amountFunc).setRange(minX, minY, minZ, maxX, maxY, maxZ).setFormatFunc(formatFunc);
                conditions.add(condition);
            }
        }
        EnumRenderType renderType = EnumRenderType.fromName(JsonUtils.getString((JsonObject)json, (String)"render_type", (String)"hash"));
        ArrayList textures = Lists.newArrayList();
        if (JsonUtils.isJsonArray((JsonObject)json, (String)"textures")) {
            JsonArray arr = JsonUtils.getJsonArray((JsonObject)json, (String)"textures");
            for (JsonElement ele : arr) {
                if (!ele.isJsonArray()) continue;
                JsonArray array = ele.getAsJsonArray();
                ArrayList texture = Lists.newArrayList();
                for (JsonElement element : array) {
                    JsonObject obj;
                    String location;
                    if (!element.isJsonObject() || (location = JsonUtils.getString((JsonObject)(obj = element.getAsJsonObject()), (String)"location", null)) == null) continue;
                    boolean isTinted = JsonUtils.getBoolean((JsonObject)obj, (String)"is_tinted", (boolean)false);
                    texture.add(Pair.of((Object)location, (Object)isTinted));
                }
                textures.add(texture);
            }
        }
        AgriPlantProperties ppt = new AgriPlantProperties();
        ppt.setSeedFormatFuncs(seedFormatFuncs).setGrowthChanceFunc(growthChanceFunc).setGrowthBonusFunc(growthBonusFunc).setFertilizable(fertilizable).setWeed(weed).setAggressive(aggressive).setSpreadChanceFunc(spreadChanceFunc).setSpawnChanceFunc(spawnChanceFunc).setGrassDropChanceFunc(grassDropChanceFunc).setSeedDropChanceFunc(seedDropChanceFunc).setSeedDropBonusFunc(seedDropBonusFunc).setProducts(products).setMinLight(minLight).setMaxLight(maxLight).setSoils(soils).setConditions(conditions).setRenderType(renderType).setTextures(textures);
        return ppt;
    }

    public static Function<EnumOreType, String> parseStringFunc(JsonObject object, String memberName, Function<EnumOreType, String> fallback) throws JsonParseException {
        if (JsonUtils.hasField((JsonObject)object, (String)memberName)) {
            JsonElement element = object.get(memberName);
            return AgriPlantPropertiesDeserializer.parseStringFunc(element, memberName, fallback);
        }
        return fallback;
    }

    public static Function<EnumOreType, String> parseStringFunc(JsonElement element, String memberName, Function<EnumOreType, String> fallback) throws JsonParseException {
        if (JsonUtils.isString((JsonElement)element)) {
            String str = element.getAsString();
            return type -> str;
        }
        if (element.isJsonObject()) {
            JsonObject json = element.getAsJsonObject();
            String ingot = JsonUtils.getString((JsonObject)json, (String)"ingot", (String)"");
            String gem = JsonUtils.getString((JsonObject)json, (String)"gem", (String)"");
            String dust = JsonUtils.getString((JsonObject)json, (String)"dust", (String)"");
            String ingot_oreless = JsonUtils.getString((JsonObject)json, (String)"ingot_oreless", (String)ingot);
            String gem_oreless = JsonUtils.getString((JsonObject)json, (String)"gem_oreless", (String)gem);
            return type -> {
                switch (type) {
                    default: {
                        return ingot;
                    }
                    case GEM: {
                        return gem;
                    }
                    case DUST: {
                        return dust;
                    }
                    case INGOT_ORELESS: {
                        return ingot_oreless;
                    }
                    case GEM_ORELESS: 
                }
                return gem_oreless;
            };
        }
        return fallback;
    }
}

