/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.agriculture.mysticalagriculture;

import java.util.Arrays;

public enum EnumRecipePattern {
    HORIZONTAL(3, "EEE", Character.valueOf('E'), null),
    CIRCLE(4, " E ", "E E", " E ", Character.valueOf('E'), null),
    CROSS(5, " E ", "EEE", " E ", Character.valueOf('E'), null),
    TOPDOWN(6, "EEE", "   ", "EEE", Character.valueOf('E'), null),
    ANVIL(7, "EEE", " E ", "EEE", Character.valueOf('E'), null),
    BORDER(8, "EEE", "E E", "EEE", Character.valueOf('E'), null),
    FULL(9, "EEE", "EEE", "EEE", Character.valueOf('E'), null);

    public final int amount;
    public final Object[] inputArray;

    private EnumRecipePattern(int amount, Object ... inputArray) {
        this.amount = amount;
        this.inputArray = inputArray;
    }

    public Object[] getRecipePattern(Object input) {
        Object[] arr = Arrays.copyOf(this.inputArray, this.inputArray.length);
        arr[arr.length - 1] = input;
        return arr;
    }

    public static EnumRecipePattern getPattern(int amount, EnumRecipePattern fallback) {
        for (EnumRecipePattern pattern : EnumRecipePattern.values()) {
            if (pattern.amount != amount) continue;
            return pattern;
        }
        return fallback;
    }
}

