/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.agriculture.mysticalagriculture;

import com.blakebr0.mysticalagriculture.crafting.ReprocessorManager;
import com.blakebr0.mysticalagriculture.items.ModItems;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.event.entity.player.BonemealEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.lang3.tuple.Pair;
import thelm.jaopca.agriculture.mysticalagriculture.BlockCropsBase;
import thelm.jaopca.agriculture.mysticalagriculture.EnumRecipePattern;
import thelm.jaopca.agriculture.mysticalagriculture.ImmersiveEngineeringHandler;
import thelm.jaopca.agriculture.mysticalagriculture.ItemBlockCropsBase;
import thelm.jaopca.agriculture.mysticalagriculture.ItemEssenceBase;
import thelm.jaopca.agriculture.mysticalagriculture.ItemSeedsBase;
import thelm.jaopca.agriculture.mysticalagriculture.ModuleMysticalAgriCraft;
import thelm.jaopca.agriculture.mysticalagriculture.ThermalExpansionHandler;
import thelm.jaopca.api.EnumEntryType;
import thelm.jaopca.api.EnumOreType;
import thelm.jaopca.api.IItemRequest;
import thelm.jaopca.api.IOreEntry;
import thelm.jaopca.api.IProperties;
import thelm.jaopca.api.ItemEntry;
import thelm.jaopca.api.ItemEntryGroup;
import thelm.jaopca.api.JAOPCAApi;
import thelm.jaopca.api.ModuleBase;
import thelm.jaopca.api.block.BlockProperties;
import thelm.jaopca.api.item.ItemProperties;
import thelm.jaopca.api.utils.Utils;

public class ModuleMysticalAgriculture
extends ModuleBase {
    public static final boolean ADDITIONS_LOADED = Loader.isModLoaded((String)"mysticalagradditions");
    public static final ArrayList<String> BLACKLIST = Lists.newArrayList((Object[])new String[]{"Coal", "Iron", "Quartz", "Glowstone", "Redstone", "Gold", "Lapis", "Diamond", "Emerald", "Silicon", "Sulfur", "Aluminium", "Copper", "Saltpeter", "Tin", "Bronze", "Zinc", "Brass", "Silver", "Lead", "Graphite", "Steel", "Nickel", "Constantan", "Electrum", "Invar", "Mithril", "Tungsten", "Titanium", "Uranium", "Chromium", "Platinum", "Iridium", "Ruby", "Sapphire", "Peridot", "Amber", "Topaz", "Malachite", "Tanzanite", "Signalum", "Lumium", "Enderium", "ElectrumFlux", "HOPGraphite", "AluminiumBrass", "Knightslime", "Ardite", "Cobalt", "Manyullyn", "Bedrock", "ElecticalSteel", "RedstoneAlloy", "ConductiveIron", "Soularium", "DarkSteel", "PulsatingIron", "EnergeticAlloy", "VibrantAlloy", "EndSteel", "Manasteel", "Elementium", "Terrasteel", "Quicksilver", "Thaumium", "Void", "Dawnstone", "Osmium", "RefinedGlowstone", "RefinedObsidian", "Aquarium", "Coldiron", "Starsteel", "Adamantine", "Apatite", "Electrotine", "Alumite", "Steeleaf", "Ironwood", "Knightmetal", "Fiery", "MeteoricIron", "Desh", "Coralium", "Abyssalnite", "Dreadium", "Syrmorite", "Octine", "Valonite", "Thorium", "Boron", "Lithium", "Magnesium", "BlackQuartz", "Vinteum", "Chimerite", "BlueTopaz", "Moonstone", "Sunstone", "Aquamarine", "Starmetal", "RockCrystal", "EnderBiotite", "Dilithium", "Tritanium", "Jade", "Dark", "CompressedIron", "Amethyst", "Draconium", "Yellorium", "CertusQuartz", "Fluix", "ChargedCertusQuartz", "QuartzEnrichedIron", "BaseEssence", "Inferium", "Prudentium", "Intermedium", "Superium", "Supremium", "Soulium", "Prismarine"});
    public static final HashMap<IOreEntry, Integer> CROP_TIERS;
    public static final HashMap<IOreEntry, Pair<EnumRecipePattern, Integer>> RECIPE_PATTERNS;
    public static final HashMap<IOreEntry, ItemStack> CRUX_SPECIALS;
    public static final ItemProperties ESSENCE_PROPERTIES;
    public static final ItemProperties SEEDS_PROPERTIES;
    public static final BlockProperties CROPS_PROPERTIES;
    public static final BlockProperties CRUX_PROPERTIES;
    public static final ItemEntry ESSENCE_ENTRY;
    public static final ItemEntry SEEDS_ENTRY;
    public static final ItemEntry CROPS_ENTRY;
    public static final ItemEntry CRUX_ENTRY;

    public ModuleMysticalAgriculture() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public static void register() {
        JAOPCAApi.registerModule((ModuleBase)new ModuleMysticalAgriculture());
        if (Loader.isModLoaded((String)"agricraft")) {
            JAOPCAApi.registerModule((ModuleBase)new ModuleMysticalAgriCraft());
        }
    }

    public String getName() {
        return "mysticalagriculture";
    }

    public void registerConfigsPre(Configuration config) {
        for (IOreEntry entry : JAOPCAApi.ORE_ENTRY_LIST) {
            if (BLACKLIST.contains(entry.getOreName()) || entry.getModuleBlacklist().contains(this.getName())) continue;
            int tier = config.get(Utils.to_under_score((String)entry.getOreName()), "maTier", Utils.rarityI((IOreEntry)entry, (double)2.0) + 1).setRequiresMcRestart(true).getInt();
            if (tier >= 6 && ADDITIONS_LOADED) {
                tier = MathHelper.func_76125_a((int)tier, (int)1, (int)6);
            } else {
                tier = MathHelper.func_76125_a((int)tier, (int)1, (int)5);
                ModuleMysticalAgriculture.CRUX_ENTRY.blacklist.add(entry.getOreName());
            }
            CROP_TIERS.put(entry, tier);
        }
    }

    public List<IItemRequest> getItemRequests() {
        return Lists.newArrayList((Object[])new IItemRequest[]{ItemEntryGroup.of((ItemEntry[])new ItemEntry[]{ESSENCE_ENTRY, SEEDS_ENTRY, CROPS_ENTRY}), CRUX_ENTRY});
    }

    public void registerConfigs(Configuration config) {
        for (IOreEntry entry : JAOPCAApi.ENTRY_NAME_TO_ORES_MAP.get((Object)"essence")) {
            String name = Utils.to_under_score((String)entry.getOreName());
            EnumRecipePattern fallback = EnumRecipePattern.BORDER;
            if (CROP_TIERS.get(entry) >= 6) {
                fallback = EnumRecipePattern.FULL;
            } else if (entry.getOreType() == EnumOreType.DUST) {
                fallback = EnumRecipePattern.HORIZONTAL;
            }
            EnumRecipePattern pattern = EnumRecipePattern.getPattern(config.get(name, "maInputAmount", fallback.amount).setRequiresMcRestart(true).getInt(), fallback);
            int outputDefault = 0;
            if (CROP_TIERS.get(entry) >= 6) {
                outputDefault = (int)(3.0 * ((double)fallback.amount / (double)pattern.amount));
            } else {
                switch (entry.getOreType()) {
                    case INGOT: 
                    case INGOT_ORELESS: {
                        outputDefault = (int)(4.0 * ((double)fallback.amount / (double)pattern.amount));
                        break;
                    }
                    case DUST: {
                        outputDefault = (int)(5.0 * ((double)fallback.amount / (double)pattern.amount));
                        break;
                    }
                    case GEM: 
                    case GEM_ORELESS: {
                        outputDefault = (int)(6.0 * ((double)fallback.amount / (double)pattern.amount));
                    }
                }
            }
            Pair toPut = Pair.of((Object)((Object)pattern), (Object)config.get(name, "maOutputAmount", outputDefault).setRequiresMcRestart(true).getInt());
            RECIPE_PATTERNS.put(entry, (Pair<EnumRecipePattern, Integer>)toPut);
        }
        for (IOreEntry entry : JAOPCAApi.ENTRY_NAME_TO_ORES_MAP.get((Object)"crux")) {
            String s = "ingot";
            if (Utils.doesOreNameExist((String)("block" + entry.getOreName()))) {
                s = "block";
            } else {
                switch (entry.getOreType()) {
                    case DUST: {
                        s = "dust";
                        break;
                    }
                    case GEM: 
                    case GEM_ORELESS: {
                        s = "gem";
                        break;
                    }
                }
            }
            ItemStack stk = Utils.getOreStack((String)s, (IOreEntry)entry, (int)1);
            String special = stk.func_77973_b().getRegistryName().toString() + "@" + stk.func_77952_i();
            special = config.get(Utils.to_under_score((String)entry.getOreName()), "maCruxSpecial", special).setRequiresMcRestart(true).getString();
            CRUX_SPECIALS.put(entry, Utils.parseItemStack((String)special));
        }
    }

    public void preInit() {
        for (IOreEntry entry : JAOPCAApi.ENTRY_NAME_TO_ORES_MAP.get((Object)"essence")) {
            OreDictionary.registerOre((String)("essenceTier" + CROP_TIERS.get(entry)), (ItemStack)Utils.getOreStack((String)"essence", (IOreEntry)entry, (int)1));
        }
        for (IOreEntry entry : JAOPCAApi.ENTRY_NAME_TO_ORES_MAP.get((Object)"mysticalSeeds")) {
            OreDictionary.registerOre((String)("seedsTier" + CROP_TIERS.get(entry)), (ItemStack)Utils.getOreStack((String)"mysticalSeeds", (IOreEntry)entry, (int)1));
        }
    }

    public void init() {
        String s;
        for (IOreEntry entry : JAOPCAApi.ENTRY_NAME_TO_ORES_MAP.get((Object)"essence")) {
            ReprocessorManager.addRecipe((ItemStack)Utils.getOreStack((String)"essence", (IOreEntry)entry, (int)2), (ItemStack)Utils.getOreStack((String)"mysticalSeeds", (IOreEntry)entry, (int)1));
            Pair<EnumRecipePattern, Integer> recipe = RECIPE_PATTERNS.get(entry);
            String s2 = "ingot";
            if (CROP_TIERS.get(entry) >= 6 && Utils.doesOreNameExist((String)("nugget" + entry.getOreName()))) {
                s2 = "nugget";
            } else {
                switch (entry.getOreType()) {
                    case DUST: {
                        s2 = "dust";
                        break;
                    }
                    case GEM: 
                    case GEM_ORELESS: {
                        s2 = "gem";
                        break;
                    }
                }
            }
            Utils.addShapedOreRecipe((ItemStack)Utils.getOreStack((String)s2, (IOreEntry)entry, (int)((Integer)recipe.getRight())), (Object[])((EnumRecipePattern)((Object)recipe.getLeft())).getRecipePattern("essence" + entry.getOreName()));
            if (!Loader.isModLoaded((String)"thermalexpansion") || CROP_TIERS.get(entry) > 5) continue;
            ThermalExpansionHandler.addInsolatorRecipes(Utils.getOreStack((String)"mysticalSeeds", (IOreEntry)entry, (int)1), Utils.getOreStack((String)"essence", (IOreEntry)entry, (int)1));
        }
        for (IOreEntry entry : JAOPCAApi.ENTRY_NAME_TO_ORES_MAP.get((Object)"mysticalSeeds")) {
            s = "ingot";
            switch (entry.getOreType()) {
                case DUST: {
                    s = "dust";
                    break;
                }
                case GEM: 
                case GEM_ORELESS: {
                    s = "gem";
                    break;
                }
            }
            Utils.addShapedOreRecipe((ItemStack)Utils.getOreStack((String)"mysticalSeeds", (IOreEntry)entry, (int)1), (Object[])new Object[]{"MEM", "ESE", "MEM", Character.valueOf('M'), s + entry.getOreName(), Character.valueOf('E'), ModuleMysticalAgriculture.getEssence(CROP_TIERS.get(entry)), Character.valueOf('S'), ModuleMysticalAgriculture.getCraftingSeeds(CROP_TIERS.get(entry))});
        }
        for (IOreEntry entry : JAOPCAApi.ENTRY_NAME_TO_ORES_MAP.get((Object)"crux")) {
            s = "ingot";
            switch (entry.getOreType()) {
                case DUST: {
                    s = "dust";
                    break;
                }
                case GEM: 
                case GEM_ORELESS: {
                    s = "gem";
                    break;
                }
            }
            Utils.addShapedOreRecipe((ItemStack)Utils.getOreStack((String)"crux", (IOreEntry)entry, (int)1), (Object[])new Object[]{"MEM", "SDS", "MEM", Character.valueOf('M'), "essenceSupremium", Character.valueOf('E'), s + entry.getOreName(), Character.valueOf('S'), CRUX_SPECIALS.get(entry), Character.valueOf('D'), "blockDiamond"});
        }
    }

    public void postInit() {
        if (Loader.isModLoaded((String)"immersiveengineering")) {
            for (IOreEntry entry : JAOPCAApi.ENTRY_NAME_TO_ORES_MAP.get((Object)"essence")) {
                if (CROP_TIERS.get(entry) > 5) continue;
                ImmersiveEngineeringHandler.registerBelljarCrop(Utils.getOreStack((String)"mysticalSeeds", (IOreEntry)entry, (int)1), Utils.getOreStack((String)"essence", (IOreEntry)entry, (int)1), (Block)JAOPCAApi.BLOCKS_TABLE.get((Object)"mysticalCrops", (Object)entry.getOreName()));
            }
        }
    }

    public List<Pair<String, String>> remaps() {
        return Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)"seeds", (Object)"mysticalSeeds"), Pair.of((Object)"crops", (Object)"mysticalCrops")});
    }

    public static Object getEssence(int tier) {
        tier = MathHelper.func_76125_a((int)tier, (int)1, (int)(ADDITIONS_LOADED ? 6 : 5));
        switch (tier) {
            case 1: {
                return "essenceInferium";
            }
            case 2: {
                return "essencePrudentium";
            }
            default: {
                return "essenceIntermedium";
            }
            case 4: {
                return "essenceSuperium";
            }
            case 5: {
                return "essenceSupremium";
            }
            case 6: 
        }
        return "essenceInsanium";
    }

    public static ItemStack getCraftingSeeds(int tier) {
        tier = MathHelper.func_76125_a((int)tier, (int)1, (int)(ADDITIONS_LOADED ? 6 : 5));
        switch (tier) {
            case 1: {
                return new ItemStack((Item)ModItems.itemCrafting, 1, 17);
            }
            case 2: {
                return new ItemStack((Item)ModItems.itemCrafting, 1, 18);
            }
            default: {
                return new ItemStack((Item)ModItems.itemCrafting, 1, 19);
            }
            case 4: {
                return new ItemStack((Item)ModItems.itemCrafting, 1, 20);
            }
            case 5: {
                return new ItemStack((Item)ModItems.itemCrafting, 1, 21);
            }
            case 6: 
        }
        Item itemInsanium = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation("mysticalagradditions", "insanium"));
        return new ItemStack(itemInsanium, 1, 1);
    }

    @SubscribeEvent
    public void onBonemealEvent(BonemealEvent event) {
        EntityPlayer player = event.getEntityPlayer();
        World world = event.getWorld();
        BlockPos pos = event.getPos();
        IBlockState state = event.getBlock();
        if (state.func_177230_c() instanceof BlockCropsBase) {
            BlockCropsBase block = (BlockCropsBase)state.func_177230_c();
            if ((player.func_184614_ca().func_77973_b() == ModItems.itemFertilizedEssence || player.func_184592_cb().func_77973_b() == ModItems.itemFertilizedEssence) && block.func_176473_a(world, pos, state, world.field_72995_K)) {
                if (!world.field_72995_K) {
                    block.func_176474_b(world, world.field_73012_v, pos, state);
                }
                event.setResult(Event.Result.ALLOW);
            }
            if ((player.func_184614_ca() != null && player.func_184614_ca().func_77973_b() == ModItems.itemMysticalFertilizer || player.func_184592_cb() != null && player.func_184592_cb().func_77973_b() == ModItems.itemMysticalFertilizer) && block.func_176473_a(world, pos, state, world.field_72995_K)) {
                if (!world.field_72995_K) {
                    world.func_180501_a(pos, block.func_185528_e(block.func_185526_g()), 2);
                }
                event.setResult(Event.Result.ALLOW);
            }
        }
    }

    static {
        if (ADDITIONS_LOADED) {
            Collections.addAll(BLACKLIST, "Insanium", "NetherStar", "DraconiumAwakened", "Neutronium");
        }
        CROP_TIERS = Maps.newHashMap();
        RECIPE_PATTERNS = Maps.newHashMap();
        CRUX_SPECIALS = Maps.newHashMap();
        ESSENCE_PROPERTIES = new ItemProperties().setItemClass(ItemEssenceBase.class);
        SEEDS_PROPERTIES = new ItemProperties().setItemClass(ItemSeedsBase.class);
        CROPS_PROPERTIES = new BlockProperties().setHardnessFunc(entry -> 0.0f).setLightOpacityFunc(entry -> 0).setSoundType(SoundType.field_185850_c).setBlockClass(BlockCropsBase.class).setItemBlockClass(ItemBlockCropsBase.class);
        CRUX_PROPERTIES = new BlockProperties().setHardnessFunc(entry -> 5.0f).setResistanceFunc(entry -> 10.0f);
        ESSENCE_ENTRY = new ItemEntry(EnumEntryType.ITEM, "essence", new ModelResourceLocation("jaopca:essence"), BLACKLIST).setOreTypes(EnumOreType.values()).setProperties((IProperties)ESSENCE_PROPERTIES);
        SEEDS_ENTRY = new ItemEntry(EnumEntryType.ITEM, "mysticalSeeds", new ModelResourceLocation("jaopca:seeds#inventory"), BLACKLIST).setOreTypes(EnumOreType.values()).setProperties((IProperties)SEEDS_PROPERTIES);
        CROPS_ENTRY = new ItemEntry(EnumEntryType.BLOCK, "mysticalCrops", new ModelResourceLocation("jaopca:crops"), BLACKLIST).setOreTypes(EnumOreType.values()).setProperties((IProperties)CROPS_PROPERTIES);
        CRUX_ENTRY = new ItemEntry(EnumEntryType.BLOCK, "crux", new ModelResourceLocation("jaopca:crux#normal"), BLACKLIST).setOreTypes(EnumOreType.values()).setProperties((IProperties)CRUX_PROPERTIES);
    }
}

