/*
 * Decompiled with CFR 0.152.
 */
package flaxbeard.immersivepetroleum.api.crafting;

import blusunrize.immersiveengineering.api.tool.ChemthrowerHandler;
import blusunrize.immersiveengineering.common.Config;
import blusunrize.immersiveengineering.common.blocks.TileEntityMultiblockPart;
import flaxbeard.immersivepetroleum.api.crafting.LubricantHandler;
import flaxbeard.immersivepetroleum.common.blocks.metal.TileEntityAutoLubricator;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class LubricatedHandler {
    static final HashMap<Class<? extends TileEntity>, ILubricationHandler> lubricationHandlers = new HashMap();
    public static List<LubricatedTileInfo> lubricatedTiles = new ArrayList<LubricatedTileInfo>();

    public static void registerLubricatedTile(Class<? extends TileEntity> tileClass, ILubricationHandler handler) {
        lubricationHandlers.put(tileClass, handler);
    }

    public static ILubricationHandler getHandlerForTile(TileEntity tile) {
        if (tile == null) {
            return null;
        }
        for (Map.Entry<Class<? extends TileEntity>, ILubricationHandler> e : lubricationHandlers.entrySet()) {
            if (!e.getKey().isInstance(tile)) continue;
            return e.getValue();
        }
        return null;
    }

    public static boolean lubricateTile(TileEntity tile, int ticks) {
        return LubricatedHandler.lubricateTile(tile, ticks, false, -1);
    }

    public static boolean lubricateTile(TileEntity tile, int ticks, boolean additive, int cap) {
        if (tile instanceof TileEntityMultiblockPart) {
            tile = ((TileEntityMultiblockPart)tile).master();
        }
        if (LubricatedHandler.getHandlerForTile(tile) != null) {
            BlockPos pos = tile.func_174877_v();
            for (int i = 0; i < lubricatedTiles.size(); ++i) {
                LubricatedTileInfo info = lubricatedTiles.get(i);
                if (!info.pos.equals((Object)pos) || info.world != tile.func_145831_w().field_73011_w.getDimension()) continue;
                if (info.ticks >= ticks) {
                    if (additive) {
                        info.ticks = cap == -1 ? (info.ticks += ticks) : Math.min(cap, info.ticks + ticks);
                        return true;
                    }
                    return false;
                }
                info.ticks = ticks;
                return true;
            }
            LubricatedTileInfo lti = new LubricatedTileInfo(tile.func_145831_w().field_73011_w.getDimension(), tile.func_174877_v(), ticks);
            lubricatedTiles.add(lti);
            return true;
        }
        return false;
    }

    public static class LubricantEffect
    extends ChemthrowerHandler.ChemthrowerEffect {
        public void applyToEntity(EntityLivingBase target, EntityPlayer shooter, ItemStack thrower, Fluid fluid) {
            if (target instanceof EntityIronGolem && LubricantHandler.isValidLube(fluid)) {
                int amount = Math.max(1, Config.IEConfig.Tools.chemthrower_consumption / LubricantHandler.getLubeAmount(fluid)) * 4 / 3;
                PotionEffect activeSpeed = target.func_70660_b(MobEffects.field_76424_c);
                int ticksSpeed = amount;
                if (activeSpeed != null && activeSpeed.func_76458_c() <= 1) {
                    ticksSpeed = Math.min(activeSpeed.func_76459_b() + amount, 1200);
                }
                PotionEffect activeStrength = target.func_70660_b(MobEffects.field_76420_g);
                int ticksStrength = amount;
                if (activeStrength != null && activeStrength.func_76458_c() <= 1) {
                    ticksStrength = Math.min(activeStrength.func_76459_b() + amount, 1200);
                }
                target.func_70690_d(new PotionEffect(MobEffects.field_76424_c, ticksSpeed, 1));
                target.func_70690_d(new PotionEffect(MobEffects.field_76420_g, ticksStrength, 1));
            }
        }

        public void applyToBlock(World worldObj, RayTraceResult mop, EntityPlayer shooter, ItemStack thrower, Fluid fluid) {
            if (LubricantHandler.isValidLube(fluid)) {
                int amount = Math.max(1, Config.IEConfig.Tools.chemthrower_consumption / LubricantHandler.getLubeAmount(fluid)) * 2 / 3;
                LubricatedHandler.lubricateTile(worldObj.func_175625_s(mop.func_178782_a()), amount, true, 1200);
            }
        }
    }

    public static class LubricatedTileInfo {
        public BlockPos pos;
        public int ticks;
        public int world;

        public LubricatedTileInfo(int world, BlockPos pos, int ticks) {
            this.world = world;
            this.pos = pos;
            this.ticks = ticks;
        }

        public NBTTagCompound writeToNBT() {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74768_a("ticks", this.ticks);
            tag.func_74768_a("x", this.pos.func_177958_n());
            tag.func_74768_a("y", this.pos.func_177956_o());
            tag.func_74768_a("z", this.pos.func_177952_p());
            tag.func_74768_a("world", this.world);
            return tag;
        }

        public static LubricatedTileInfo readFromNBT(NBTTagCompound tag) {
            int ticks = tag.func_74762_e("ticks");
            int x = tag.func_74762_e("x");
            int y = tag.func_74762_e("y");
            int z = tag.func_74762_e("z");
            int world = tag.func_74762_e("world");
            return new LubricatedTileInfo(world, new BlockPos(x, y, z), ticks);
        }
    }

    public static interface ILubricationHandler<E extends TileEntity> {
        public TileEntity isPlacedCorrectly(World var1, TileEntityAutoLubricator var2, EnumFacing var3);

        public boolean isMachineEnabled(World var1, E var2);

        public void lubricate(World var1, int var2, E var3);

        public void spawnLubricantParticles(World var1, TileEntityAutoLubricator var2, EnumFacing var3, E var4);

        @SideOnly(value=Side.CLIENT)
        public void renderPipes(World var1, TileEntityAutoLubricator var2, EnumFacing var3, E var4);

        public Tuple<BlockPos, EnumFacing> getGhostBlockPosition(World var1, E var2);

        public int[] getStructureDimensions();
    }
}

