/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.holoInventory;

import com.google.common.collect.Sets;
import net.dries007.holoInventory.HICommand;
import net.dries007.holoInventory.Helper;
import net.dries007.holoInventory.client.ClientEventHandler;
import net.dries007.holoInventory.network.request.EntityRequest;
import net.dries007.holoInventory.network.request.TileRequest;
import net.dries007.holoInventory.network.response.MerchantRecipes;
import net.dries007.holoInventory.network.response.PlainInventory;
import net.dries007.holoInventory.server.ServerEventHandler;
import net.minecraft.command.ICommand;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ModMetadata;
import net.minecraftforge.fml.common.event.FMLModDisabledEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.logging.log4j.Logger;

@Mod(modid="holoinventory", name="HoloInventory", acceptableRemoteVersions="*", canBeDeactivated=true, guiFactory="net.dries007.holoInventory.client.ConfigGuiFactory", acceptedMinecraftVersions="[1.12.2]")
public class HoloInventory {
    public static final String MODID = "holoinventory";
    public static final String MODNAME = "HoloInventory";
    public static final String GUI_FACTORY = "net.dries007.holoInventory.client.ConfigGuiFactory";
    @Mod.Instance(value="holoinventory")
    private static HoloInventory instance;
    @Mod.Metadata
    private ModMetadata metadata;
    private SimpleNetworkWrapper snw;
    private Logger logger;
    private Configuration config;

    @Mod.EventHandler
    public void disableEvent(FMLModDisabledEvent event) {
        this.logger.info("Mod disabled via Mods list.");
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        this.logger = event.getModLog();
        this.config = new Configuration(event.getSuggestedConfigurationFile());
        this.updateConfig();
        int id = 0;
        this.snw = NetworkRegistry.INSTANCE.newSimpleChannel(MODID);
        this.snw.registerMessage(EntityRequest.Handler.class, EntityRequest.class, id++, Side.SERVER);
        this.snw.registerMessage(TileRequest.Handler.class, TileRequest.class, id++, Side.SERVER);
        this.snw.registerMessage(PlainInventory.Handler.class, PlainInventory.class, id++, Side.CLIENT);
        this.snw.registerMessage(MerchantRecipes.Handler.class, MerchantRecipes.class, id++, Side.CLIENT);
        if (event.getSide().isClient()) {
            ClientEventHandler.init();
        }
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)ServerEventHandler.I);
    }

    @Mod.EventHandler
    public void serverStart(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new HICommand());
    }

    @SubscribeEvent
    public void updateConfig(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals(MODID)) {
            this.updateConfig();
        }
    }

    public void saveBanned() {
        this.config.get(MODID, "banned", new String[0]).set(Helper.banned.toArray(new String[Helper.banned.size()]));
        if (this.config.hasChanged()) {
            this.config.save();
        }
    }

    private void updateConfig() {
        this.logger.info("Update config");
        Helper.showOnSneak = this.config.get(MODID, "showOnSneak", true, "Show on sneak, bypasses other keyboard settings.").setRequiresWorldRestart(false).setRequiresMcRestart(false).getBoolean();
        Helper.showOnSprint = this.config.get(MODID, "showOnSprint", true, "Show on sprint, bypasses other keyboard settings.").setRequiresWorldRestart(false).setRequiresMcRestart(false).getBoolean();
        Helper.banned = Sets.newHashSet((Object[])this.config.get(MODID, "banned", new String[0]).setRequiresWorldRestart(false).setRequiresMcRestart(false).getStringList());
        if (this.config.hasChanged()) {
            this.config.save();
        }
    }

    public static String getVersion() {
        return HoloInventory.instance.metadata.version;
    }

    public static HoloInventory getInstance() {
        return instance;
    }

    public static SimpleNetworkWrapper getSnw() {
        return HoloInventory.instance.snw;
    }

    public static Logger getLogger() {
        return HoloInventory.instance.logger;
    }

    public static Configuration getConfig() {
        return HoloInventory.instance.config;
    }
}

