/*
 * Decompiled with CFR 0.152.
 */
package net.dries007.holoInventory.server;

import net.dries007.holoInventory.Helper;
import net.dries007.holoInventory.HoloInventory;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class ServerEventHandler {
    public static final ServerEventHandler I = new ServerEventHandler();
    public static Type catchNext = Type.NONE;

    private ServerEventHandler() {
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onRightClick(PlayerInteractEvent.RightClickBlock event) {
        if (catchNext == Type.NONE) {
            return;
        }
        boolean ban = catchNext == Type.BAN;
        catchNext = Type.NONE;
        event.setCanceled(true);
        TileEntity te = event.getWorld().func_175625_s(event.getPos());
        if (te == null) {
            event.getEntityPlayer().func_145747_a(new TextComponentString("That block does not have a TileEntity.").func_150255_a(new Style().func_150238_a(TextFormatting.RED)));
            return;
        }
        if (ban) {
            if (Helper.banned.add(te.getClass().getCanonicalName())) {
                event.getEntityPlayer().func_145747_a(new TextComponentString("Banned " + te.getClass().getCanonicalName()).func_150255_a(new Style().func_150238_a(TextFormatting.GREEN)));
            } else {
                event.getEntityPlayer().func_145747_a(new TextComponentString(te.getClass().getCanonicalName() + " is already banned.").func_150255_a(new Style().func_150238_a(TextFormatting.RED)));
            }
        } else {
            boolean wasBanned = Helper.banned.remove(te.getClass().getCanonicalName());
            if (wasBanned) {
                event.getEntityPlayer().func_145747_a(new TextComponentString("Unbanned " + te.getClass().getCanonicalName()).func_150255_a(new Style().func_150238_a(TextFormatting.GREEN)));
            } else {
                event.getEntityPlayer().func_145747_a(new TextComponentString(te.getClass().getCanonicalName() + " is not banned. Perhaps it is banned on the " + (FMLCommonHandler.instance().getSide().isClient() ? "server" : "client") + "?").func_150255_a(new Style().func_150238_a(TextFormatting.RED)));
            }
        }
        HoloInventory.getInstance().saveBanned();
    }

    public static enum Type {
        NONE,
        BAN,
        UNBAN;

    }
}

