/*
 * Decompiled with CFR 0.152.
 */
package org.mcupdater.reconstructor.helpers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.EmptyHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import org.mcupdater.reconstructor.tile.TileRecon;

public class InventoryHelper {
    public static boolean canStackFitInInventory(IItemHandler target, ItemStack toInsert) {
        if (toInsert.func_190926_b()) {
            return false;
        }
        ItemStack remainingItems = toInsert.func_77946_l();
        for (int slot = 0; slot < target.getSlots() && !remainingItems.func_190926_b(); ++slot) {
            remainingItems = target.insertItem(slot, remainingItems, true);
        }
        return remainingItems.func_190926_b();
    }

    public static ItemStack insertItemStackIntoInventory(IItemHandler target, ItemStack toInsert) {
        if (toInsert.func_190926_b()) {
            return toInsert;
        }
        for (int slot = 0; slot < target.getSlots() && !toInsert.func_190926_b(); ++slot) {
            toInsert = target.insertItem(slot, toInsert, false);
        }
        return toInsert;
    }

    public static IItemHandler getWrapper(TileEntity tileEntity, EnumFacing side) {
        if (tileEntity.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side)) {
            return (IItemHandler)tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side);
        }
        if (tileEntity instanceof ISidedInventory) {
            return new SidedInvWrapper((ISidedInventory)tileEntity, side);
        }
        if (tileEntity instanceof IInventory) {
            return new InvWrapper((IInventory)tileEntity);
        }
        return EmptyHandler.INSTANCE;
    }

    public static boolean addToPriorityInventory(World world, BlockPos pos, ItemStack stack) {
        List<EnumFacing> sides = InventoryHelper.getSideList(pos, ((TileRecon)world.func_175625_s(pos)).getOrientation());
        for (EnumFacing side : sides) {
            IItemHandler invOutput;
            TileEntity target = world.func_175625_s(pos.func_177972_a(side));
            if (target == null || (invOutput = InventoryHelper.getWrapper(target, side.func_176734_d())) == EmptyHandler.INSTANCE || !InventoryHelper.canStackFitInInventory(invOutput, stack)) continue;
            ItemStack remain = InventoryHelper.insertItemStackIntoInventory(invOutput, stack);
            return remain.func_190926_b();
        }
        return false;
    }

    private static List<EnumFacing> getSideList(BlockPos pos, EnumFacing facing) {
        switch (facing) {
            case NORTH: {
                return new ArrayList<EnumFacing>(Arrays.asList(EnumFacing.DOWN, EnumFacing.WEST, EnumFacing.SOUTH, EnumFacing.EAST, EnumFacing.UP));
            }
            case EAST: {
                return new ArrayList<EnumFacing>(Arrays.asList(EnumFacing.DOWN, EnumFacing.NORTH, EnumFacing.WEST, EnumFacing.SOUTH, EnumFacing.UP));
            }
            case SOUTH: {
                return new ArrayList<EnumFacing>(Arrays.asList(EnumFacing.DOWN, EnumFacing.EAST, EnumFacing.NORTH, EnumFacing.WEST, EnumFacing.UP));
            }
            case WEST: {
                return new ArrayList<EnumFacing>(Arrays.asList(EnumFacing.DOWN, EnumFacing.SOUTH, EnumFacing.EAST, EnumFacing.NORTH, EnumFacing.UP));
            }
        }
        return new ArrayList<EnumFacing>(Arrays.asList(EnumFacing.DOWN, EnumFacing.SOUTH, EnumFacing.EAST, EnumFacing.NORTH, EnumFacing.UP));
    }
}

