/*
 * Decompiled with CFR 0.152.
 */
package org.mcupdater.reconstructor.tile;

import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.ItemTool;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntityLockableLoot;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.EnergyStorage;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import org.apache.logging.log4j.Level;
import org.mcupdater.reconstructor.Config;
import org.mcupdater.reconstructor.Reconstructor;
import org.mcupdater.reconstructor.gui.ContainerRecon;
import org.mcupdater.reconstructor.helpers.DebugHelper;
import org.mcupdater.reconstructor.helpers.InventoryHelper;
import org.mcupdater.reconstructor.helpers.ReconInvWrapper;

public class TileRecon
extends TileEntityLockableLoot
implements ITickable {
    private NonNullList<ItemStack> workspace;
    private EnumFacing orientation = EnumFacing.DOWN;
    private EnergyStorage storage = new EnergyStorage(Config.energyPerPoint * 1000);
    private IItemHandler itemHandler;

    public TileRecon() {
        this.workspace = NonNullList.func_191197_a((int)1, (Object)ItemStack.field_190927_a);
        this.itemHandler = new ReconInvWrapper(this);
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K && (Config.energyPerPoint == 0 || this.storage.getEnergyStored() > Config.energyPerPoint) && this.tryRepair()) {
            this.storage.extractEnergy(Config.energyPerPoint, false);
        }
    }

    public boolean tryRepair() {
        if (this.func_70301_a(0).func_190926_b()) {
            return false;
        }
        if (this.isExtractable()) {
            this.ejectItem();
            return false;
        }
        int repairAmount = Config.scaledRepair ? Math.max(1, (this.func_70301_a(0).func_77958_k() - this.func_70301_a(0).func_77952_i()) / 100) : 1;
        this.func_70301_a(0).func_77964_b(this.func_70301_a(0).func_77952_i() - repairAmount);
        NBTTagCompound tag = this.func_70301_a(0).func_77978_p();
        if (tag != null && tag.func_74764_b("Stats")) {
            NBTTagCompound stats = tag.func_74775_l("Stats");
            stats.func_74757_a("Broken", false);
            tag.func_74782_a("Stats", (NBTBase)stats);
            this.func_70301_a(0).func_77982_d(tag);
        }
        return true;
    }

    public boolean isExtractable() {
        return !this.func_70301_a(0).func_77951_h() || !this.func_70301_a(0).func_77973_b().isRepairable() && !this.isWhitelisted(this.func_70301_a(0).func_77973_b().getClass().toString()) || Config.blacklist.contains(this.func_70301_a(0).func_77973_b().func_77658_a()) || Config.restrictRepairs && !(this.func_70301_a(0).func_77973_b() instanceof ItemTool) && !(this.func_70301_a(0).func_77973_b() instanceof ItemArmor) && !(this.func_70301_a(0).func_77973_b() instanceof ItemSword) && !(this.func_70301_a(0).func_77973_b() instanceof ItemBow);
    }

    private boolean isWhitelisted(String className) {
        for (String entry : Config.whitelist) {
            if (!className.contains(entry)) continue;
            return true;
        }
        return false;
    }

    private void ejectItem() {
        if (Config.debug) {
            ItemStack stack = this.func_70301_a(0);
            Reconstructor.instance.getLogger().log(Level.INFO, "Is Damaged: " + stack.func_77951_h());
            Reconstructor.instance.getLogger().log(Level.INFO, "Is Repairable: " + stack.func_77973_b().isRepairable());
            Reconstructor.instance.getLogger().log(Level.INFO, "Is Whitelisted: " + this.isWhitelisted(stack.func_77973_b().getClass().toString()));
            Reconstructor.instance.getLogger().log(Level.INFO, "Is Blacklisted: " + Config.blacklist.contains(stack.func_77973_b().func_77658_a()));
            Reconstructor.instance.getLogger().log(Level.INFO, "Is Restricted: " + (Config.restrictRepairs && !(stack.func_77973_b() instanceof ItemTool) && !(stack.func_77973_b() instanceof ItemArmor) && !(stack.func_77973_b() instanceof ItemSword) && !(stack.func_77973_b() instanceof ItemBow)));
            Reconstructor.instance.getLogger().log(Level.INFO, "Class hierarchy: " + stack.func_77973_b().getClass().toString());
            Set<Class<?>> classes = DebugHelper.getAllExtendedOrImplementedTypesRecursively(stack.func_77973_b().getClass());
            for (Class<?> clazz : classes) {
                Reconstructor.instance.getLogger().log(Level.INFO, "  " + clazz.getName());
            }
        }
        if (InventoryHelper.addToPriorityInventory(this.func_145831_w(), this.field_174879_c, this.func_70301_a(0).func_77946_l())) {
            this.func_70298_a(0, 1);
            return;
        }
    }

    public boolean func_70300_a(EntityPlayer player) {
        if (this.field_145850_b == null) {
            return true;
        }
        if (this.field_145850_b.func_175625_s(this.field_174879_c) != this) {
            return false;
        }
        return player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public int func_70302_i_() {
        return this.workspace.size();
    }

    public ItemStack func_70301_a(int slot) {
        return (ItemStack)this.workspace.get(slot);
    }

    public ItemStack func_70298_a(int index, int count) {
        this.func_184281_d(null);
        if (this.isExtractable()) {
            ItemStack itemstack = ItemStackHelper.func_188382_a(this.func_190576_q(), (int)index, (int)count);
            if (!itemstack.func_190926_b()) {
                this.func_70296_d();
            }
            return itemstack;
        }
        return ItemStack.field_190927_a;
    }

    public ItemStack func_70304_b(int index) {
        this.func_184281_d(null);
        return this.isExtractable() ? ItemStackHelper.func_188383_a(this.func_190576_q(), (int)index) : ItemStack.field_190927_a;
    }

    public int func_70297_j_() {
        return 1;
    }

    public void func_70296_d() {
        super.func_70296_d();
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        return itemstack.func_77973_b().func_77645_m();
    }

    public void func_145839_a(NBTTagCompound data) {
        super.func_145839_a(data);
        this.workspace = NonNullList.func_191197_a((int)this.func_70302_i_(), (Object)ItemStack.field_190927_a);
        ItemStackHelper.func_191283_b((NBTTagCompound)data, this.workspace);
        if (data.func_74764_b("energy")) {
            this.storage.receiveEnergy(data.func_74762_e("energy"), false);
        }
        this.orientation = EnumFacing.field_82609_l[data.func_74771_c("orientation")];
    }

    public NBTTagCompound func_189515_b(NBTTagCompound data) {
        super.func_189515_b(data);
        ItemStackHelper.func_191282_a((NBTTagCompound)data, this.workspace);
        data.func_74768_a("energy", this.storage.getEnergyStored());
        data.func_74774_a("orientation", (byte)this.orientation.ordinal());
        return data;
    }

    public String func_70005_c_() {
        return "Reconstructor";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public ITextComponent func_145748_c_() {
        return null;
    }

    public EnumFacing getOrientation() {
        return this.orientation;
    }

    public void setOrientation(EnumFacing orientation) {
        this.orientation = orientation;
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74774_a("orientation", (byte)this.orientation.ordinal());
        return new SPacketUpdateTileEntity(this.field_174879_c, 0, compound);
    }

    public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY) {
            return (T)CapabilityEnergy.ENERGY.cast((Object)this.storage);
        }
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)(this.itemHandler == null ? (this.itemHandler = new ReconInvWrapper(this)) : this.itemHandler);
        }
        return (T)super.getCapability(capability, facing);
    }

    public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || capability == CapabilityEnergy.ENERGY || super.hasCapability(capability, facing);
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    public NonNullList<ItemStack> func_190576_q() {
        return this.workspace;
    }

    public boolean func_191420_l() {
        for (ItemStack itemstack : this.workspace) {
            if (itemstack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public Container func_174876_a(InventoryPlayer playerInventory, EntityPlayer playerIn) {
        return new ContainerRecon(playerInventory, this);
    }

    public String func_174875_k() {
        return "reconstructor:reconstructorblock";
    }
}

