/*
 * Decompiled with CFR 0.152.
 */
package de.zekro.fdrpc.config;

import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Objects;
import net.minecraft.util.Tuple;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;

public class Config {
    private final File mainConfigFile;
    private String discordAppID = "";
    private String mainImageAlt = "";
    private boolean allowInvites = true;
    private HashMap<String, String> dimensionNames = new HashMap();

    public Config(FMLPreInitializationEvent event) {
        File mainConfigLocation = new File(event.getModConfigurationDirectory() + "/" + "fdrpc");
        this.mainConfigFile = new File(mainConfigLocation.getPath(), "fdrpc.cfg");
    }

    public void init() {
        Configuration mainConfig = new Configuration(this.mainConfigFile);
        String category = "discord";
        mainConfig.addCustomCategoryComment(category, "General Discord API app settings");
        this.discordAppID = mainConfig.getString("app_id", category, "732500956130050079", "The ID of the Discord API application created at https://discordapp.com/developers/applications.");
        this.mainImageAlt = mainConfig.getString("main_image_alt", category, "", "The alt text of the main Discord RPC image.");
        category = "invites";
        mainConfig.addCustomCategoryComment(category, "Server Invites");
        this.allowInvites = mainConfig.getBoolean("allow_invites", category, this.allowInvites, "Wether to allow requesting server invites via Discord Rich Presence.");
        category = "misc";
        mainConfig.addCustomCategoryComment(category, "Miscellaneous settings");
        String[] dimensionNameList = mainConfig.getStringList("dimension_names", category, new String[]{"overworld:Overworld", "the_nether:!In The Nether", "the_end:The End"}, "ID of the dimension and the display name separated with a colon (':').\nYou can prefix the value with '!' to bypass the default dimension prefix 'In ',\nso that way, you can define custom display formats.\n");
        Arrays.stream(dimensionNameList).map(Config::formatDimensionEntry).filter(Objects::nonNull).forEach(t -> this.dimensionNames.put((String)t.func_76341_a(), (String)t.func_76340_b()));
        mainConfig.save();
    }

    public String getDiscordAppID() {
        return this.discordAppID;
    }

    public String getMainImageAlt() {
        return this.mainImageAlt;
    }

    public boolean getAllowInvites() {
        return this.allowInvites;
    }

    public HashMap<String, String> getDimensionNames() {
        return this.dimensionNames;
    }

    private static Tuple<String, String> formatDimensionEntry(String e) {
        String[] split = e.split(":");
        if (split.length < 2) {
            return null;
        }
        String v = split[1].startsWith("!") ? split[1].substring(1) : "In " + split[1];
        return new Tuple((Object)split[0], (Object)v);
    }
}

