/*
 * Decompiled with CFR 0.152.
 */
package de.zekro.fdrpc.handler;

import de.zekro.fdrpc.rpc.RPCHandler;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.network.NetHandlerPlayClient;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Mod.EventBusSubscriber
public class EventHandler {
    private static final List<World> loadedWorlds = new ArrayList<World>();
    private static int currentServerPlayers;
    private static int currentServerSlots;

    @SubscribeEvent
    public static void playerEvent(PlayerEvent event) {
        if (event.getEntity() instanceof EntityPlayer) {
            EventHandler.update();
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static void selfLoggedInEvent(WorldEvent.Load event) {
        World world = event.getWorld();
        if (!(world instanceof WorldClient)) {
            return;
        }
        loadedWorlds.add(world);
        currentServerSlots = 0;
        currentServerPlayers = 0;
        RPCHandler.setDimension(world);
    }

    @SubscribeEvent
    public static void selfLoggedOutEvent(WorldEvent.Unload event) {
        World world = event.getWorld();
        if (!(world instanceof WorldClient)) {
            return;
        }
        loadedWorlds.remove(world);
        if (loadedWorlds.size() < 1) {
            RPCHandler.setMainMenu();
            RPCHandler.updatePresence();
        }
    }

    public static void update(boolean force) {
        NetHandlerPlayClient netHandlerPlayClient = Minecraft.func_71410_x().func_147114_u();
        if (netHandlerPlayClient == null) {
            return;
        }
        boolean singlePlayer = Minecraft.func_71410_x().func_71356_B();
        Collection playerInfoMap = netHandlerPlayClient.func_175106_d();
        int playersSize = playerInfoMap.size();
        int slots = netHandlerPlayClient.field_147304_c;
        if (!force && playersSize == currentServerPlayers && slots == currentServerSlots) {
            return;
        }
        currentServerPlayers = playerInfoMap.size();
        currentServerSlots = netHandlerPlayClient.field_147304_c;
        if (singlePlayer) {
            RPCHandler.setSinglePlayer();
        } else {
            RPCHandler.setMultiPlayer(currentServerPlayers, currentServerSlots);
        }
        RPCHandler.updatePresence();
    }

    public static void update() {
        EventHandler.update(false);
    }
}

