/*
 * Decompiled with CFR 0.152.
 */
package de.zekro.fdrpc.rpc;

import de.zekro.fdrpc.ForgeDiscordRPC;
import de.zekro.fdrpc.gui.GuiJoinRequest;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;
import net.arikia.dev.drpc.DiscordEventHandlers;
import net.arikia.dev.drpc.DiscordRPC;
import net.arikia.dev.drpc.DiscordRichPresence;
import net.arikia.dev.drpc.DiscordUser;
import net.arikia.dev.drpc.callbacks.ErroredCallback;
import net.arikia.dev.drpc.callbacks.ReadyCallback;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiMainMenu;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.multiplayer.GuiConnecting;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class RPCHandler {
    private static final String IMAGE_MAIN_LOGO = "mainicon";
    private static long startTime = 0L;
    private static String state = "Initializing...";
    private static String details = "Initializing...";
    private static int currentPlayers = 0;
    private static int maxPlayers = 0;
    private static boolean singlePlayer = true;
    private static final Object discordCallbackExecutor = new Object(){

        @SubscribeEvent
        public void tickEvent(TickEvent.ClientTickEvent e) {
            DiscordRPC.discordRunCallbacks();
        }
    };
    private static final ReadyCallback connectHandler = user -> ForgeDiscordRPC.getLogger().info(String.format("Discord RPC connected to user account %s#%s (%s)", user.username, user.discriminator, user.userId));
    private static final ErroredCallback errorHandler = (error, errStr) -> ForgeDiscordRPC.getLogger().error((Object)error);

    public static void connect() {
        DiscordEventHandlers handlers = new DiscordEventHandlers.Builder().setReadyEventHandler(connectHandler).setErroredEventHandler(errorHandler).setJoinRequestEventHandler(RPCHandler::joinRequestHandler).setJoinGameEventHandler(RPCHandler::joinGameHandler).build();
        DiscordRPC.discordInitialize(ForgeDiscordRPC.getConfig().getDiscordAppID(), handlers, true);
        MinecraftForge.EVENT_BUS.register(discordCallbackExecutor);
    }

    public static void setInitializing() {
        startTime = System.currentTimeMillis();
        details = "Initializing...";
        state = "Initializing Forge & Minecraft...";
    }

    public static void setMainMenu() {
        details = "In Main Menu";
        state = "";
    }

    public static void setDimension(World worldIn) {
        String displayName;
        String dimensionName = worldIn.field_73011_w.func_186058_p().func_186065_b();
        state = displayName = ForgeDiscordRPC.getConfig().getDimensionNames().getOrDefault(dimensionName, dimensionName);
    }

    public static void setSinglePlayer() {
        singlePlayer = true;
        currentPlayers = 0;
        maxPlayers = 0;
        details = "In Singleplayer Game";
    }

    public static void setMultiPlayer(int curr, int max) {
        singlePlayer = false;
        currentPlayers = curr;
        maxPlayers = max;
        details = "In Multiplayer Game";
    }

    public static void updatePresence() {
        DiscordRichPresence.Builder builder = RPCHandler.getDefaultPresenceBuilder(state, ForgeDiscordRPC.getConfig().getMainImageAlt()).setDetails(details);
        if (!singlePlayer && currentPlayers != 0 && maxPlayers != 0) {
            builder.setParty("Party", currentPlayers, maxPlayers);
        }
        ServerData currentServer = Minecraft.func_71410_x().func_147104_D();
        if (!singlePlayer && ForgeDiscordRPC.getConfig().getAllowInvites() && currentServer != null) {
            builder.setSecrets(RPCHandler.encodeServerData(currentServer), "");
        }
        DiscordRPC.discordUpdatePresence(builder.build());
    }

    public static void shutdown() {
        DiscordRPC.discordShutdown();
        MinecraftForge.EVENT_BUS.unregister(discordCallbackExecutor);
    }

    private static DiscordRichPresence.Builder getDefaultPresenceBuilder(String state, String bigImageAlt) {
        return new DiscordRichPresence.Builder(state).setBigImage(IMAGE_MAIN_LOGO, bigImageAlt).setStartTimestamps(startTime);
    }

    private static void joinRequestHandler(DiscordUser user) {
        Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiJoinRequest(user, res -> DiscordRPC.discordRespond(user.userId, res)));
    }

    private static void joinGameHandler(String payload) {
        Minecraft mc = Minecraft.func_71410_x();
        if (mc.func_147104_D() != null || mc.func_71387_A()) {
            if (mc.field_71441_e != null) {
                mc.field_71441_e.func_72882_A();
            }
            mc.func_71403_a(null);
            Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiMainMenu());
        }
        mc.func_147108_a((GuiScreen)new GuiConnecting((GuiScreen)(mc.field_71462_r != null ? mc.field_71462_r : new GuiMainMenu()), mc, RPCHandler.decodeServerData(payload)));
    }

    private static String encodeServerData(ServerData data) {
        return String.format("n=%s;ip=%s;l=%b", data.field_78847_a, data.field_78845_b, data.func_181041_d());
    }

    private static ServerData decodeServerData(String data) {
        Map<String, String> map = Arrays.stream(data.split(";")).filter(kv -> kv.length() > 0).map(kv -> kv.split("=")).collect(Collectors.toMap(kv -> kv[0], kv -> kv[1]));
        String name = map.get("n");
        String ip = map.get("ip");
        boolean isLan = Boolean.parseBoolean(map.get("l"));
        return new ServerData(name, ip, isLan);
    }
}

