/*
 * Decompiled with CFR 0.152.
 */
package kenijey.rwg.biome.heightmods;

import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import kenijey.rwg.biome.heightmods.ParamHeightMod;
import kenijey.rwg.generator.biome.BiomeModParameter;
import kenijey.rwg.noise.Noise;
import kenijey.rwg.noise.OctaveNoise;
import kenijey.rwg.noise.RidgeNoise;
import kenijey.rwg.noise.TailoredNoise;
import kenijey.rwg.util.MathUtil;

public class HeightModMesa
extends ParamHeightMod {
    protected Noise mesanoise;
    protected Noise roughness;
    protected Noise rifts;
    protected Noise spires;

    public HeightModMesa() {
        this.parameters.put("variant", new BiomeModParameter.VariantParameter(2));
        this.parameters.put("spires", new BiomeModParameter.BooleanParameter(false));
        Random rand = new Random(329047298523L);
        this.mesanoise = new TailoredNoise(rand, 100.0, 0.1, 50.0, 0.5, 20.0, 0.1, 8.0, 0.01);
        this.roughness = new OctaveNoise(rand, 30.0, 3);
        this.rifts = new RidgeNoise(rand, 150.0, 4);
        this.spires = new OctaveNoise(rand, 10.0, 3, 0.5, 0.6);
    }

    @Override
    public double getModifiedHeight(int x, int z, double height, @Nullable Map<String, Object> args) {
        int variant = (Integer)this.parameter("variant", args);
        boolean hasSpires = (Boolean)this.parameter("spires", args);
        int nx = variant == 1 ? x / 2 + 37492 : x;
        int nz = variant == 1 ? z / 2 + 85477 : z;
        double n = height + (this.mesanoise.getValue(nx, nz) - 0.35) * 0.5;
        double spire = 0.0;
        if (hasSpires) {
            spire = this.spires.getValue(x, z);
            spire *= spire * spire;
            spire = Math.max(0.0, spire) * 0.2;
            spire += height;
        }
        if (variant == 1) {
            n += 0.054901960784313725;
        }
        for (int i = 0; i < 15; ++i) {
            int h = i * 16 + 8;
            n = MathUtil.plateau(n, h - 8, h, h + 8, 5.0, false);
            if (!hasSpires) continue;
            spire = MathUtil.plateau(spire, h - 8, h, h + 8, 5.0, false);
        }
        double mix = 0.992;
        n = n * mix + height * (1.0 - mix);
        n += this.roughness.getValue(x, z) * 0.01;
        n += 0.011764705882352941;
        double r = this.rifts.getValue(x, z);
        r *= r * r;
        r = Math.max(0.0, r - 0.75);
        n = Math.max(height - 0.01, n - r);
        if (hasSpires) {
            n = MathUtil.polymax(n, spire, 0.03137254901960784);
        }
        return MathUtil.polymax(n, height, 0.047058823529411764);
    }
}

