/*
 * Decompiled with CFR 0.152.
 */
package kenijey.rwg.compat;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kenijey.rwg.RWG;
import kenijey.rwg.compat.BiomeModule;
import kenijey.rwg.compat.builtin.BOPModule;
import kenijey.rwg.compat.builtin.ProvidedBiomeModule;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.event.FMLInterModComms;

public class ModCompat {
    private Map<String, Set<String>> messageSenders = new HashMap<String, Set<String>>();
    public List<ProvidedBiomeModule> builtInBiomeModules = new ArrayList<ProvidedBiomeModule>();

    public void preInit() {
    }

    public void init() {
    }

    public void postInit() {
        new BOPModule();
    }

    public void registerBuiltInModules() {
        for (ProvidedBiomeModule module : this.builtInBiomeModules) {
            if (!Loader.isModLoaded((String)module.modid) || this.messageSenders.containsKey(module.modid) && this.messageSenders.get(module.modid).contains("biomeModule")) continue;
            RWG.logger.info("Registering built-in biome module: {} for {}", (Object)module.name, (Object)module.modid);
            RWG.globalRegistry.biomeModules.add(module);
        }
    }

    public void processIMC(Collection<FMLInterModComms.IMCMessage> messages) {
        for (FMLInterModComms.IMCMessage message : messages) {
            this.processIMC(message);
        }
    }

    private void processIMC(FMLInterModComms.IMCMessage message) {
        if (!this.messageSenders.containsKey(message.getSender())) {
            this.messageSenders.put(message.getSender(), new HashSet());
        }
        this.messageSenders.get(message.getSender()).add(message.key);
        switch (message.key) {
            case "biomeModule": {
                BiomeModule.fromIMC(message);
            }
        }
    }
}

