/*
 * Decompiled with CFR 0.152.
 */
package kenijey.rwg.generator;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import kenijey.rwg.generator.structure.WoodlandMansionRWG;
import net.minecraft.block.Block;
import net.minecraft.block.BlockFalling;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldEntitySpawner;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkPrimer;
import net.minecraft.world.gen.ChunkGeneratorSettings;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraft.world.gen.MapGenBase;
import net.minecraft.world.gen.MapGenCaves;
import net.minecraft.world.gen.MapGenRavine;
import net.minecraft.world.gen.NoiseGeneratorPerlin;
import net.minecraft.world.gen.feature.WorldGenDungeons;
import net.minecraft.world.gen.feature.WorldGenLakes;
import net.minecraft.world.gen.structure.MapGenMineshaft;
import net.minecraft.world.gen.structure.MapGenScatteredFeature;
import net.minecraft.world.gen.structure.MapGenStronghold;
import net.minecraft.world.gen.structure.MapGenStructure;
import net.minecraft.world.gen.structure.MapGenVillage;
import net.minecraft.world.gen.structure.StructureOceanMonument;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.terraingen.InitMapGenEvent;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.event.terraingen.TerrainGen;

public class ChunkProviderBasic
implements IChunkGenerator {
    protected final World world;
    protected final LinkedHashMap<String, MapGenStructure> structureGenerators = Maps.newLinkedHashMap();
    protected final List<MapGenBase> featureGenerators = Lists.newArrayList();
    protected final Map<MapGenStructure, FeatureSpawnListAction> featureSpawnListActions = Maps.newHashMap();
    protected final Random random;
    protected final boolean structuresEnabled;
    protected NoiseGeneratorPerlin surfaceNoise;
    protected double[] depthBuffer = new double[256];
    protected ChunkGeneratorSettings basicSettings = ChunkGeneratorSettings.Factory.func_177865_a((String)"").func_177864_b();

    public ChunkProviderBasic(World world) {
        this.world = world;
        this.random = new Random(world.func_72905_C());
        this.structuresEnabled = this.world.func_72912_H().func_76089_r();
        this.surfaceNoise = new NoiseGeneratorPerlin(this.random, 4);
        this.initFeatures();
    }

    public void initFeatures() {
        if (this.structuresEnabled) {
            this.structureGenerators.put("Village", (MapGenStructure)((MapGenVillage)TerrainGen.getModdedMapGen((MapGenBase)new MapGenVillage(), (InitMapGenEvent.EventType)InitMapGenEvent.EventType.VILLAGE)));
            MapGenScatteredFeature mgsf = (MapGenScatteredFeature)TerrainGen.getModdedMapGen((MapGenBase)new MapGenScatteredFeature(), (InitMapGenEvent.EventType)InitMapGenEvent.EventType.SCATTERED_FEATURE);
            this.structureGenerators.put("Temple", (MapGenStructure)mgsf);
            this.featureSpawnListActions.put((MapGenStructure)mgsf, (s, type, pos) -> {
                MapGenScatteredFeature gen = (MapGenScatteredFeature)s;
                if (type == EnumCreatureType.MONSTER && gen.func_175798_a(pos)) {
                    return gen.func_82667_a();
                }
                return null;
            });
            this.structureGenerators.put("Mineshaft", (MapGenStructure)((MapGenMineshaft)TerrainGen.getModdedMapGen((MapGenBase)new MapGenMineshaft(), (InitMapGenEvent.EventType)InitMapGenEvent.EventType.MINESHAFT)));
            this.structureGenerators.put("Stronghold", (MapGenStructure)((MapGenStronghold)TerrainGen.getModdedMapGen((MapGenBase)new MapGenStronghold(), (InitMapGenEvent.EventType)InitMapGenEvent.EventType.STRONGHOLD)));
            StructureOceanMonument som = (StructureOceanMonument)TerrainGen.getModdedMapGen((MapGenBase)new StructureOceanMonument(), (InitMapGenEvent.EventType)InitMapGenEvent.EventType.OCEAN_MONUMENT);
            this.structureGenerators.put("Monument", (MapGenStructure)som);
            this.featureSpawnListActions.put((MapGenStructure)som, (s, type, pos) -> {
                StructureOceanMonument gen = (StructureOceanMonument)s;
                if (type == EnumCreatureType.MONSTER && s.func_175796_a(this.world, pos)) {
                    return gen.func_175799_b();
                }
                return null;
            });
            this.structureGenerators.put("Mansion", new WoodlandMansionRWG(this));
        }
        this.featureGenerators.add(TerrainGen.getModdedMapGen((MapGenBase)new MapGenCaves(), (InitMapGenEvent.EventType)InitMapGenEvent.EventType.CAVE));
        this.featureGenerators.add(TerrainGen.getModdedMapGen((MapGenBase)new MapGenRavine(), (InitMapGenEvent.EventType)InitMapGenEvent.EventType.RAVINE));
    }

    public void generateFeatures(int x, int z, ChunkPrimer primer) {
        for (MapGenBase mapgenbase : this.featureGenerators) {
            mapgenbase.func_186125_a(this.world, x, z, primer);
        }
        for (MapGenStructure mapgenstructure : this.structureGenerators.values()) {
            mapgenstructure.func_186125_a(this.world, x, z, primer);
        }
    }

    public boolean populateFeatures(ChunkPos chunkpos) {
        boolean village = false;
        for (MapGenStructure mapgenstructure : this.structureGenerators.values()) {
            boolean flag = mapgenstructure.func_175794_a(this.world, this.random, chunkpos);
            if (!(mapgenstructure instanceof MapGenVillage)) continue;
            village |= flag;
        }
        return village;
    }

    public void replaceBiomeBlocks(int x, int z, ChunkPrimer primer, Biome[] biomesIn) {
        if (!ForgeEventFactory.onReplaceBiomeBlocks((IChunkGenerator)this, (int)x, (int)z, (ChunkPrimer)primer, (World)this.world)) {
            return;
        }
        double d0 = 0.03125;
        this.depthBuffer = this.surfaceNoise.func_151599_a(this.depthBuffer, (double)(x * 16), (double)(z * 16), 16, 16, 0.0625, 0.0625, 1.0);
        for (int i = 0; i < 16; ++i) {
            for (int j = 0; j < 16; ++j) {
                Biome biome = biomesIn[j + i * 16];
                biome.func_180622_a(this.world, this.random, primer, x * 16 + i, z * 16 + j, this.depthBuffer[j + i * 16]);
            }
        }
    }

    public Chunk func_185932_a(int x, int z) {
        ChunkPrimer chunkprimer = new ChunkPrimer();
        this.fillChunk(x, z, chunkprimer);
        Biome[] biomes = this.world.func_72959_q().func_76933_b((Biome[])null, x * 16, z * 16, 16, 16);
        this.replaceBiomeBlocks(x, z, chunkprimer, biomes);
        this.generateFeatures(x, z, chunkprimer);
        Chunk chunk = new Chunk(this.world, chunkprimer, x, z);
        byte[] abyte = chunk.func_76605_m();
        for (int l = 0; l < abyte.length; ++l) {
            abyte[l] = (byte)Biome.func_185362_a((Biome)biomes[l]);
        }
        chunk.func_76603_b();
        return chunk;
    }

    public void fillChunk(int chunkX, int chunkZ, ChunkPrimer primer) {
        IBlockState iblockstate = Blocks.field_150348_b.func_176223_P();
        for (int iy = 0; iy < 64; ++iy) {
            for (int ix = 0; ix < 16; ++ix) {
                for (int iz = 0; iz < 16; ++iz) {
                    primer.func_177855_a(ix, iy, iz, iblockstate);
                }
            }
        }
    }

    public void func_185931_b(int x, int z) {
        int fz;
        int fy;
        int fx;
        BlockFalling.field_149832_M = true;
        int blockX = x * 16;
        int blockZ = z * 16;
        BlockPos blockpos = new BlockPos(blockX, 0, blockZ);
        Biome biome = this.world.func_180494_b(blockpos.func_177982_a(16, 0, 16));
        this.random.setSeed(this.world.func_72905_C());
        long randX = this.random.nextLong() / 2L * 2L + 1L;
        long randZ = this.random.nextLong() / 2L * 2L + 1L;
        this.random.setSeed((long)x * randX + (long)z * randZ ^ this.world.func_72905_C());
        boolean hasVillage = false;
        ChunkPos chunkpos = new ChunkPos(x, z);
        ForgeEventFactory.onChunkPopulate((boolean)true, (IChunkGenerator)this, (World)this.world, (Random)this.random, (int)x, (int)z, (boolean)hasVillage);
        hasVillage = this.populateFeatures(chunkpos);
        if (biome != Biomes.field_76769_d && biome != Biomes.field_76786_s && this.basicSettings.field_177781_A && !hasVillage && this.random.nextInt(this.basicSettings.field_177782_B) == 0 && TerrainGen.populate((IChunkGenerator)this, (World)this.world, (Random)this.random, (int)x, (int)z, (boolean)hasVillage, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.LAKE)) {
            fx = this.random.nextInt(16) + 8;
            fy = this.random.nextInt(256);
            fz = this.random.nextInt(16) + 8;
            new WorldGenLakes((Block)Blocks.field_150355_j).func_180709_b(this.world, this.random, blockpos.func_177982_a(fx, fy, fz));
        }
        if (!hasVillage && this.random.nextInt(this.basicSettings.field_177777_D / 10) == 0 && this.basicSettings.field_177783_C && TerrainGen.populate((IChunkGenerator)this, (World)this.world, (Random)this.random, (int)x, (int)z, (boolean)hasVillage, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.LAVA)) {
            fx = this.random.nextInt(16) + 8;
            fy = this.random.nextInt(this.random.nextInt(248) + 8);
            fz = this.random.nextInt(16) + 8;
            if (fy < this.world.func_181545_F() || this.random.nextInt(this.basicSettings.field_177777_D / 8) == 0) {
                new WorldGenLakes((Block)Blocks.field_150353_l).func_180709_b(this.world, this.random, blockpos.func_177982_a(fx, fy, fz));
            }
        }
        if (this.basicSettings.field_177837_s && TerrainGen.populate((IChunkGenerator)this, (World)this.world, (Random)this.random, (int)x, (int)z, (boolean)hasVillage, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.DUNGEON)) {
            for (int i = 0; i < this.basicSettings.field_177835_t; ++i) {
                int fx2 = this.random.nextInt(16) + 8;
                int fy2 = this.random.nextInt(256);
                int fz2 = this.random.nextInt(16) + 8;
                new WorldGenDungeons().func_180709_b(this.world, this.random, blockpos.func_177982_a(fx2, fy2, fz2));
            }
        }
        biome.func_180624_a(this.world, this.random, new BlockPos(blockX, 0, blockZ));
        if (TerrainGen.populate((IChunkGenerator)this, (World)this.world, (Random)this.random, (int)x, (int)z, (boolean)hasVillage, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.ANIMALS)) {
            WorldEntitySpawner.func_77191_a((World)this.world, (Biome)biome, (int)(blockX + 8), (int)(blockZ + 8), (int)16, (int)16, (Random)this.random);
        }
        blockpos = blockpos.func_177982_a(8, 0, 8);
        if (TerrainGen.populate((IChunkGenerator)this, (World)this.world, (Random)this.random, (int)x, (int)z, (boolean)hasVillage, (PopulateChunkEvent.Populate.EventType)PopulateChunkEvent.Populate.EventType.ICE)) {
            for (int ix = 0; ix < 16; ++ix) {
                for (int iz = 0; iz < 16; ++iz) {
                    BlockPos blockpos1 = this.world.func_175725_q(blockpos.func_177982_a(ix, 0, iz));
                    BlockPos blockpos2 = blockpos1.func_177977_b();
                    if (this.world.func_175675_v(blockpos2)) {
                        this.world.func_180501_a(blockpos2, Blocks.field_150432_aD.func_176223_P(), 2);
                    }
                    if (!this.canSnowAt(this.world, blockpos1, true)) continue;
                    this.world.func_180501_a(blockpos1, Blocks.field_150431_aC.func_176223_P(), 2);
                }
            }
        }
        ForgeEventFactory.onChunkPopulate((boolean)false, (IChunkGenerator)this, (World)this.world, (Random)this.random, (int)x, (int)z, (boolean)hasVillage);
        BlockFalling.field_149832_M = false;
    }

    public boolean func_185933_a(Chunk chunkIn, int x, int z) {
        return false;
    }

    public List<Biome.SpawnListEntry> func_177458_a(EnumCreatureType creatureType, BlockPos pos) {
        Biome biome = this.world.func_180494_b(pos);
        for (MapGenStructure structure : this.structureGenerators.values()) {
            List<Biome.SpawnListEntry> list;
            if (!this.featureSpawnListActions.containsKey(structure) || (list = this.featureSpawnListActions.get(structure).apply(structure, creatureType, pos)) == null) continue;
            return list;
        }
        return biome.func_76747_a(creatureType);
    }

    @Nullable
    public BlockPos func_180513_a(World worldIn, String structureName, BlockPos position, boolean findUnexplored) {
        for (String name : this.structureGenerators.keySet()) {
            if (!structureName.equals(name)) continue;
            return this.structureGenerators.get(name).func_180706_b(worldIn, position, findUnexplored);
        }
        return null;
    }

    public void func_180514_a(Chunk chunkIn, int x, int z) {
        for (MapGenStructure mapgenstructure : this.structureGenerators.values()) {
            mapgenstructure.func_186125_a(this.world, x, z, (ChunkPrimer)null);
        }
    }

    public float getFloatTemperature(Biome biome, BlockPos pos) {
        return biome.func_180626_a(pos);
    }

    public boolean canSnowAt(World world, BlockPos pos, boolean checkLight) {
        IBlockState iblockstate;
        Biome biome = world.func_180494_b(pos);
        float f = this.getFloatTemperature(biome, pos);
        if (f > 0.15f) {
            return false;
        }
        if (!checkLight) {
            return true;
        }
        return pos.func_177956_o() >= 0 && pos.func_177956_o() < 256 && world.func_175642_b(EnumSkyBlock.BLOCK, pos) < 10 && (iblockstate = world.func_180495_p(pos)).func_177230_c().isAir(iblockstate, (IBlockAccess)world, pos) && Blocks.field_150431_aC.func_176196_c(world, pos);
    }

    public boolean func_193414_a(World worldIn, String structureName, BlockPos position) {
        for (String name : this.structureGenerators.keySet()) {
            if (!structureName.equals(name)) continue;
            return this.structureGenerators.get(name).func_175796_a(worldIn, position);
        }
        return false;
    }

    static interface FeatureSpawnListAction {
        public List<Biome.SpawnListEntry> apply(MapGenStructure var1, EnumCreatureType var2, BlockPos var3);
    }
}

