/*
 * Decompiled with CFR 0.152.
 */
package kenijey.rwg.generator;

import java.util.Random;
import kenijey.rwg.generator.biome.BiomeBlobs;
import kenijey.rwg.noise.DuneNoise;
import kenijey.rwg.noise.JordanTurbulence;
import kenijey.rwg.noise.Noise;
import kenijey.rwg.noise.OctaveNoise;
import kenijey.rwg.noise.RidgeNoise;
import kenijey.rwg.noise.TailoredNoise;
import kenijey.rwg.util.CoordCache;
import kenijey.rwg.util.CoordPair;
import kenijey.rwg.util.MathUtil;
import net.minecraft.world.biome.Biome;

public class CoreNoise {
    protected CoordCache<NoiseEntry> cache = new CoordCache(1024L);
    public final long seed;
    public final CoordPair heightModOffset;
    public static final double SEA_LEVEL = 0.24705882352941178;
    public static final double SWAMP_MAX = 0.30196078431372547;
    public static final double BEACH_MAX = 0.25882352941176473;
    public static final double BEACH_MIN = 0.22745098039215686;
    public static final double COAST_MIN = 0.2;
    public static final double SQUASH_HEIGHT = 0.9;
    public static final double SQUASH_DIVISOR = 0.5;
    protected Noise ledges;
    protected Noise lumps;
    protected Noise ridges;
    protected Noise oceans;
    protected Noise dunes;
    protected Noise roughness;
    protected Noise swamps;
    protected Noise temperature;
    protected Noise moisture;
    public BiomeBlobs blobs;

    public CoreNoise(long seed) {
        this.seed = seed;
        double scale = 100.0;
        Random rand = new Random(seed);
        this.ledges = new OctaveNoise(rand, scale * 5.0, 2);
        this.lumps = new JordanTurbulence(rand, scale * 3.0, 6, 2.0, 0.8, 0.65, 0.4, 0.45, 1.0, 0.6, 1.0, 2, 0.15, 0.25, 0.5);
        this.ridges = new RidgeNoise(rand, scale * 6.0, 5);
        this.oceans = new OctaveNoise(rand, scale * 10.0, 4);
        this.dunes = new DuneNoise(rand, scale * 0.3, 0.2);
        this.roughness = new OctaveNoise(rand, scale * 0.2, 3);
        this.swamps = new OctaveNoise(rand, scale * 8.0, 4, 2.0, 0.75);
        this.temperature = new TailoredNoise(rand, 1281.0, 0.87, 119.0, 0.07, 26.0, 0.06);
        this.moisture = new TailoredNoise(rand, 400.0, 0.76, 243.0, 0.16, 53.0, 0.08);
        this.blobs = new BiomeBlobs(rand.nextLong(), 64);
        this.heightModOffset = new CoordPair(rand.nextInt(), rand.nextInt());
    }

    public double getHeight(int x, int z) {
        NoiseEntry vals = this.getEntry(x, z);
        if (Double.isNaN(vals.height)) {
            this.generateHeight(vals);
        }
        return vals.height;
    }

    public double getInland(int x, int z) {
        NoiseEntry vals = this.getEntry(x, z);
        if (Double.isNaN(vals.inland)) {
            this.generateHeight(vals);
        }
        return vals.inland;
    }

    public double getSwamp(int x, int z) {
        NoiseEntry vals = this.getEntry(x, z);
        if (Double.isNaN(vals.swamp)) {
            this.generateHeight(vals);
        }
        return vals.swamp;
    }

    public double getRoughness(int x, int z) {
        NoiseEntry vals = this.getEntry(x, z);
        if (Double.isNaN(vals.roughness)) {
            this.generateHeight(vals);
        }
        return vals.roughness;
    }

    protected void generateHeight(NoiseEntry vals) {
        vals.height = 0.0;
        double lump = this.lumps.getValue(vals.x, vals.z);
        double ridge = this.ridges.getValue(vals.x, vals.z);
        double ocean = this.oceans.getValue(vals.x, vals.z);
        double rough = this.roughness.getValue(vals.x, vals.z);
        vals.inland = ocean;
        vals.roughness = rough;
        double islands = (lump * lump - 0.5) * 0.3 + 0.25 + (ocean + 0.2) * 0.4;
        double ridgelayer = ridge * 0.45 + lump * (0.05 + ridge * 0.25);
        vals.height += MathUtil.polymax(islands, ridgelayer * (ocean + 0.3), 0.2);
        if (vals.height <= 0.2) {
            double abyss = this.dunes.getValue(vals.x, vals.z) * 0.05 + 0.08;
            vals.height = MathUtil.polymax(vals.height, abyss, 0.1);
        }
        vals.swamp = 0.0;
        if (vals.height >= 0.2 && vals.height < 0.30196078431372547) {
            double temp = this.temperature.getValue(vals.x, vals.z);
            double moist = this.moisture.getValue(vals.x, vals.z);
            double swampmoist = MathUtil.clamp((moist * temp - 0.35) * 2.0, 0.0, 1.0);
            double swamp = MathUtil.clamp(this.swamps.getValue(vals.x, vals.z) * MathUtil.smoothstep(swampmoist) * 5.0, 0.0, 1.0);
            if (swamp > 0.0) {
                double factor = 1.0;
                factor = vals.height < 0.24705882352941178 ? MathUtil.smoothrange(vals.height, 0.2, 0.23500000000000001) : 1.0 - MathUtil.smoothrange(vals.height, 0.27696078431372545, 0.30196078431372547);
                double swamplevel = 0.24705882352941178 + rough * 0.01;
                vals.height = (1.0 - (factor *= MathUtil.smoothstep(MathUtil.clamp(swamp * 25.0, 0.0, 1.0)))) * vals.height + factor * swamplevel;
                vals.swamp = factor;
            }
        }
        double ledge1 = Math.min(0.975, this.ledges.getValue(-vals.x + 34273, vals.z + 86269) * 1.15);
        ledge1 *= ledge1;
        double ledgelumpfactor = 0.0;
        if (ledge1 > 0.05) {
            double ledgefactor = Math.min(1.0, (ledge1 - 0.05) * 3.0);
            double ledgelevel = vals.height;
            ledgelevel = MathUtil.plateau(ledgelevel, 60, 68, 75, 2.0, false);
            ledgelevel = MathUtil.plateau(ledgelevel, 70, 80, 90, 3.0, false);
            double diff = Math.abs(vals.height - ledgelevel);
            vals.height = vals.height * (1.0 - ledgefactor) + ledgelevel * ledgefactor;
            ledgelumpfactor += diff * ledgefactor;
        }
        double ledge2 = Math.min(0.975, this.ledges.getValue(vals.x, vals.z) * 1.15);
        if ((ledge2 *= ledge2) > 0.375) {
            double ledgefactor = Math.min(1.0, (ledge2 - 0.375) * 6.0);
            double ledgelevel = vals.height;
            ledgelevel = MathUtil.plateau(ledgelevel, 60, 70, 85, 2.0, false);
            ledgelevel = MathUtil.plateau(ledgelevel, 85, 100, 110, 3.0, false);
            ledgelevel = MathUtil.plateau(ledgelevel, 120, 140, 145, 3.0, false);
            ledgelevel = MathUtil.plateau(ledgelevel, 50, 64, 66, 2.0, false);
            double diff = Math.abs(vals.height - ledgelevel);
            vals.height = vals.height * (1.0 - ledgefactor) + ledgelevel * ledgefactor;
            ledgelumpfactor += diff * ledgefactor;
        }
        if (ledgelumpfactor > 0.0) {
            vals.height += ledgelumpfactor * (rough + 1.0) * 0.5;
        }
        if (vals.height > 0.5) {
            vals.height += (vals.height - 0.5) * 0.01 * rough;
        }
        vals.height += rough * 0.00125;
        if (vals.height > 0.9) {
            double h = (vals.height - 0.9) / 0.09999999999999998;
            double mix = MathUtil.smoothstep(MathUtil.clamp(h, 0.0, 1.0));
            h = (1.0 - mix) * h + mix * (h / (0.5 + h));
            vals.height = 0.9 + h * 0.09999999999999998;
        }
    }

    public double getTemperature(int x, int z) {
        NoiseEntry vals = this.getEntry(x, z);
        if (Double.isNaN(vals.temperature)) {
            this.generateTemperature(vals);
        }
        return vals.temperature;
    }

    protected void generateTemperature(NoiseEntry vals) {
        double height = this.getHeight(vals.x, vals.z);
        double inland = this.getInland(vals.x, vals.z);
        double inlandfactor = Math.max(0.0, inland - 0.5);
        double heightfactor = Math.max(0.0, height * 2.0 - 0.9);
        double mix = this.temperature.getValue(vals.x, vals.z) * 1.5 - 0.3;
        vals.temperature = Math.max(0.0, mix + inlandfactor * 0.25 - heightfactor * 0.65);
    }

    public double getMoisture(int x, int z) {
        NoiseEntry vals = this.getEntry(x, z);
        if (Double.isNaN(vals.moisture)) {
            this.generateMoisture(vals);
        }
        return vals.moisture;
    }

    protected void generateMoisture(NoiseEntry vals) {
        double temp = this.getTemperature(vals.x, vals.z);
        double inland = this.getInland(vals.x, vals.z);
        double inlandfactor = Math.max(-0.1, inland - 0.5);
        double tempfactor = temp - 0.45 + inlandfactor * 0.9;
        double mix = this.moisture.getValue(vals.x, vals.z) * 1.2 - 0.125;
        vals.moisture = Math.max(0.0, Math.min(1.0, mix - tempfactor * 0.35));
    }

    public NoiseEntry getEntry(int x, int z) {
        NoiseEntry vals = this.cache.get(x, z);
        if (vals == null) {
            vals = new NoiseEntry(x, z);
            this.cache.put(x, z, vals);
        }
        return vals;
    }

    public static class NoiseEntry
    extends CoordPair {
        public double height = Double.NaN;
        public double temperature = Double.NaN;
        public double moisture = Double.NaN;
        public double inland = Double.NaN;
        public double swamp = Double.NaN;
        public double roughness = Double.NaN;
        public Biome biome = null;

        public NoiseEntry(int x, int z) {
            super(x, z);
        }
    }
}

