/*
 * Decompiled with CFR 0.152.
 */
package kenijey.rwg.generator.biome;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import kenijey.rwg.RWG;
import kenijey.rwg.generator.CoreNoise;
import kenijey.rwg.generator.biome.IBiomeHeightModifier;
import kenijey.rwg.settings.BiomeSettings;
import kenijey.rwg.util.MathUtil;
import net.minecraft.init.Biomes;
import net.minecraft.world.biome.Biome;

public class BiomeRegistry {
    public Map<EnumBiomeCategory, Map<String, BiomeGroup>> biomeGroups = new HashMap<EnumBiomeCategory, Map<String, BiomeGroup>>();
    public Map<Biome, Map<Biome, Double>> subBiomes = new HashMap<Biome, Map<Biome, Double>>();
    public Map<Biome, Double> subWeightTotals = new HashMap<Biome, Double>();
    public Map<Biome, LinkedHashMap<Biome, Double>> hillBiomes = new HashMap<Biome, LinkedHashMap<Biome, Double>>();
    public Map<Biome, HeightModRegistryEntry> heightMods = new HashMap<Biome, HeightModRegistryEntry>();
    public Map<Biome, Double> smoothingOverrides = new HashMap<Biome, Double>();

    public BiomeRegistry() {
        for (EnumBiomeCategory category : EnumBiomeCategory.values()) {
            this.biomeGroups.put(category, new HashMap());
        }
    }

    public void populate(BiomeSettings settings) {
        Biome parent;
        Biome biome;
        for (BiomeSettings.GroupDefinition groupDefinition : settings.groups.values()) {
            if (groupDefinition.category == EnumBiomeCategory.UNKNOWN) continue;
            this.addGroup(groupDefinition.category, groupDefinition.name, groupDefinition.temperature, groupDefinition.moisture, groupDefinition.height, groupDefinition.minHeight, groupDefinition.maxHeight).setBlobSizeModifier(groupDefinition.blobsize).setSubBlobSizeModifier(groupDefinition.subblobsize);
        }
        for (BiomeSettings.BiomeDefinition biomeDefinition : settings.biomes.values()) {
            if (biomeDefinition.category == EnumBiomeCategory.UNKNOWN || !Biome.field_185377_q.func_148741_d((Object)biomeDefinition.name)) continue;
            biome = (Biome)Biome.field_185377_q.func_82594_a((Object)biomeDefinition.name);
            if (!this.biomeGroups.get((Object)biomeDefinition.category).containsKey(biomeDefinition.group)) continue;
            BiomeGroup group = this.biomeGroups.get((Object)biomeDefinition.category).get(biomeDefinition.group);
            group.addBiome(biome, biomeDefinition.weight);
        }
        for (BiomeSettings.SubBiomeEntry subBiomeEntry : settings.subBiomes.values()) {
            if (!Biome.field_185377_q.func_148741_d((Object)subBiomeEntry.name) || !Biome.field_185377_q.func_148741_d((Object)subBiomeEntry.parentBiome)) continue;
            biome = (Biome)Biome.field_185377_q.func_82594_a((Object)subBiomeEntry.name);
            parent = (Biome)Biome.field_185377_q.func_82594_a((Object)subBiomeEntry.parentBiome);
            this.addSubBiome(parent, biome, subBiomeEntry.weight);
        }
        for (BiomeSettings.HillBiomeEntry hillBiomeEntry : settings.hillBiomes.values()) {
            if (!Biome.field_185377_q.func_148741_d((Object)hillBiomeEntry.name) || !Biome.field_185377_q.func_148741_d((Object)hillBiomeEntry.parentBiome)) continue;
            biome = (Biome)Biome.field_185377_q.func_82594_a((Object)hillBiomeEntry.name);
            parent = (Biome)Biome.field_185377_q.func_82594_a((Object)hillBiomeEntry.parentBiome);
            this.addHillBiome(parent, biome, hillBiomeEntry.height);
        }
        this.hillBiomes.replaceAll((k, v) -> v.entrySet().stream().sorted(Map.Entry.comparingByValue()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (v1, v2) -> v1, LinkedHashMap::new)));
        for (BiomeSettings.HeightModEntry heightModEntry : settings.heightMods.values()) {
            IBiomeHeightModifier mod;
            if (!Biome.field_185377_q.func_148741_d((Object)heightModEntry.name) || (mod = RWG.globalRegistry.getHeightModifier(heightModEntry.heightMod)) == null) continue;
            Biome biome2 = (Biome)Biome.field_185377_q.func_82594_a((Object)heightModEntry.name);
            this.addHeightModifier(biome2, mod, heightModEntry.parameters);
        }
        for (BiomeSettings.SmoothingEntry smoothingEntry : settings.smoothing.values()) {
            if (!Biome.field_185377_q.func_148741_d((Object)smoothingEntry.name)) continue;
            biome = (Biome)Biome.field_185377_q.func_82594_a((Object)smoothingEntry.name);
            this.setSmoothingFactor(biome, smoothingEntry.smoothing);
        }
    }

    public BiomeGroup addGroup(EnumBiomeCategory category, String name, double temperature, double moisture, double height, double minHeight, double maxHeight) {
        BiomeGroup biomeGroup = new BiomeGroup(name, temperature, moisture, height, minHeight, maxHeight);
        this.biomeGroups.get((Object)category).put(name, biomeGroup);
        return biomeGroup;
    }

    public BiomeGroup addGroup(EnumBiomeCategory category, String name, double temperature, double moisture, double height) {
        return this.addGroup(category, name, temperature, moisture, height, 0.0, 1.0);
    }

    public void addSubBiome(Biome parent, Biome subBiome, double weight) {
        if (!this.subBiomes.containsKey(parent)) {
            this.subBiomes.put(parent, new LinkedHashMap());
            this.subWeightTotals.put(parent, 0.0);
        }
        Map<Biome, Double> subs = this.subBiomes.get(parent);
        this.subWeightTotals.put(parent, this.subWeightTotals.get(parent) + weight);
        if (!subs.containsKey(subBiome)) {
            subs.put(subBiome, weight);
        } else {
            subs.put(subBiome, subs.get(subBiome) + weight);
        }
    }

    public Biome getSubBiome(Biome parent, double value) {
        if (!this.subBiomes.containsKey(parent)) {
            return parent;
        }
        double weight = MathUtil.clamp(value, 0.0, 1.0) * (this.subWeightTotals.get(parent) + 1.0);
        if (weight <= 1.0) {
            return parent;
        }
        weight -= 1.0;
        Map<Biome, Double> weights = this.subBiomes.get(parent);
        double total = 0.0;
        for (Map.Entry<Biome, Double> entry : weights.entrySet()) {
            if (!((total += entry.getValue().doubleValue()) >= weight)) continue;
            return entry.getKey();
        }
        return null;
    }

    public void addHillBiome(Biome parent, Biome hillBiome, double height) {
        if (!this.hillBiomes.containsKey(parent)) {
            this.hillBiomes.put(parent, new LinkedHashMap());
        }
        Map hills = this.hillBiomes.get(parent);
        hills.put(hillBiome, height);
    }

    public Biome getHillBiome(Biome parent, CoreNoise noise, int x, int z) {
        if (!this.hillBiomes.containsKey(parent)) {
            return parent;
        }
        Map hills = this.hillBiomes.get(parent);
        double height = noise.getHeight(x, z) + noise.getRoughness(x, z) * 0.1;
        Biome biome = parent;
        for (Map.Entry e : hills.entrySet()) {
            if (height > (Double)e.getValue()) {
                biome = (Biome)e.getKey();
                continue;
            }
            return biome;
        }
        return biome;
    }

    public void addHeightModifier(Biome biome, IBiomeHeightModifier mod, Map<String, Object> args) {
        this.heightMods.put(biome, new HeightModRegistryEntry(mod, args));
    }

    public void addHeightModifier(Biome biome, IBiomeHeightModifier mod) {
        this.addHeightModifier(biome, mod, null);
    }

    public void addHeightModifier(Biome biome, IBiomeHeightModifier mod, int variant) {
        HashMap<String, Object> args = new HashMap<String, Object>();
        args.put("variant", variant);
        this.addHeightModifier(biome, mod, args);
    }

    public HeightModRegistryEntry getHeightModifier(Biome biome) {
        return this.heightMods.get(biome);
    }

    public void setSmoothingFactor(Biome biome, double smoothing) {
        this.smoothingOverrides.put(biome, smoothing);
    }

    public double getSmoothingFactor(Biome biome) {
        if (this.smoothingOverrides.containsKey(biome)) {
            return this.smoothingOverrides.get(biome);
        }
        return 1.0;
    }

    public static class HeightModRegistryEntry {
        public final IBiomeHeightModifier modifier;
        public final Map<String, Object> arguments;

        public HeightModRegistryEntry(IBiomeHeightModifier modifier, Map<String, Object> args) {
            this.modifier = modifier;
            this.arguments = args;
        }
    }

    public static class BiomeGroup {
        public String name;
        public double temperature;
        public double moisture;
        public double height;
        public double minHeight;
        public double maxHeight;
        public int blobSizeModifier = 0;
        public int subBlobSizeModfier = 0;
        public long salt;
        public int offsetx;
        public int offsetz;
        public Map<Biome, Double> biomes;
        public double totalweight = 0.0;

        public BiomeGroup(String name, double temperature, double moisture, double height, double minHeight, double maxHeight) {
            this.name = name;
            this.temperature = temperature;
            this.moisture = moisture;
            this.height = height;
            this.minHeight = minHeight;
            this.maxHeight = maxHeight;
            this.salt = name.hashCode();
            Random rand = new Random(this.salt);
            this.offsetx = rand.nextInt();
            this.offsetz = rand.nextInt();
            this.biomes = new LinkedHashMap<Biome, Double>();
        }

        public BiomeGroup(String name, double temperature, double moisture, double height) {
            this(name, temperature, moisture, height, 0.0, 1.0);
        }

        public BiomeGroup(String name, double temperature, double moisture) {
            this(name, temperature, moisture, 0.5);
        }

        public BiomeGroup addBiome(Biome biome, double weight) {
            if (biome != null) {
                if (!this.biomes.containsKey(biome)) {
                    this.biomes.put(biome, weight);
                } else {
                    this.biomes.put(biome, this.biomes.get(biome) + weight);
                }
                this.totalweight += weight;
            }
            return this;
        }

        public BiomeGroup addBiome(Biome biome) {
            return this.addBiome(biome, 1.0);
        }

        public Biome getBiome(double value) {
            double weight = MathUtil.clamp(value, 0.0, 1.0) * this.totalweight;
            double total = 0.0;
            for (Map.Entry<Biome, Double> entry : this.biomes.entrySet()) {
                if (!((total += entry.getValue().doubleValue()) >= weight)) continue;
                return entry.getKey();
            }
            return null;
        }

        public double getClassificationScore(Biome biome) {
            return 0.0;
        }

        public BiomeGroup setBlobSizeModifier(int size) {
            this.blobSizeModifier = size;
            return this;
        }

        public BiomeGroup setSubBlobSizeModifier(int size) {
            this.subBlobSizeModfier = size;
            return this;
        }
    }

    public static enum EnumBiomeCategory {
        UNKNOWN(Biomes.field_76772_c),
        LAND(Biomes.field_76772_c),
        OCEAN(Biomes.field_76771_b),
        BEACH(Biomes.field_76787_r),
        SWAMP(Biomes.field_76780_h);

        public final BiomeGroup fallback = new BiomeGroup(this.name() + "_fallback", 0.5, 0.5, 0.25);

        private EnumBiomeCategory(Biome fallback) {
            this.fallback.addBiome(fallback);
        }

        public String toString() {
            return this.name().toLowerCase(Locale.ENGLISH);
        }

        public static EnumBiomeCategory get(String name) {
            EnumBiomeCategory category;
            name = name.toUpperCase(Locale.ENGLISH);
            try {
                category = EnumBiomeCategory.valueOf(name);
            }
            catch (Exception e) {
                return null;
            }
            return category;
        }
    }
}

