/*
 * Decompiled with CFR 0.152.
 */
package kenijey.rwg.noise;

import java.util.Random;
import kenijey.rwg.noise.Noise;
import kenijey.rwg.noise.OpenSimplexNoise;

public class RidgeNoise
extends Noise {
    protected OpenSimplexNoise generator;
    protected int layers;
    protected double scale;

    public RidgeNoise(Random rand, double scale, int layers) {
        this.generator = new OpenSimplexNoise(rand.nextLong());
        this.scale = scale;
        this.layers = layers;
    }

    @Override
    public double getValue(int x, int z) {
        double output = 0.0;
        for (int i = 0; i < this.layers; ++i) {
            double mult = i == 0 ? 0.666 : output * output / (double)(i + 1);
            double layerscale = this.scale / (double)(i + 1);
            output += (1.0 - Math.abs(this.generator.eval((double)x / layerscale, (double)z / layerscale, (double)(i * 773) + 0.5))) * mult;
        }
        return output;
    }
}

