/*
 * Decompiled with CFR 0.152.
 */
package kenijey.rwg.noise;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import kenijey.rwg.noise.Noise;
import kenijey.rwg.noise.OpenSimplexNoise;

public class TailoredNoise
extends Noise {
    protected Map<Double, Double> layers;
    protected OpenSimplexNoise generator;

    public TailoredNoise(Random rand, double ... values) {
        this.generator = new OpenSimplexNoise(rand.nextLong());
        this.layers = new HashMap<Double, Double>();
        int i = 0;
        while (i + 1 < values.length) {
            this.layers.put(values[i], values[i + 1]);
            i += 2;
        }
    }

    @Override
    public double getValue(int x, int z) {
        double output = 0.0;
        int i = 0;
        for (Map.Entry<Double, Double> layer : this.layers.entrySet()) {
            output += (this.generator.eval((double)x / layer.getKey(), (double)z / layer.getKey(), 0.5 + (double)(i * 7)) + 1.0) * 0.5 * layer.getValue();
        }
        return output;
    }
}

