/*
 * Decompiled with CFR 0.152.
 */
package kenijey.rwg.settings;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import kenijey.rwg.RWG;
import kenijey.rwg.generator.biome.BiomeModParameter;
import kenijey.rwg.generator.biome.BiomeRegistry;
import kenijey.rwg.generator.biome.IBiomeHeightModifier;
import kenijey.rwg.settings.Settings;
import kenijey.rwg.util.JsonUtil;
import net.minecraft.init.Biomes;
import net.minecraft.util.ResourceLocation;

public class BiomeSettings
extends Settings
implements Comparable<BiomeSettings> {
    public LinkedHashMap<String, GroupDefinition> groups = new LinkedHashMap();
    public LinkedHashMap<String, GroupEntry> groupRemovals = new LinkedHashMap();
    public LinkedHashMap<String, BiomeReplacement> replacements = new LinkedHashMap();
    public LinkedHashMap<String, BiomeDefinition> biomes = new LinkedHashMap();
    public LinkedHashMap<String, GroupedBiomeEntry> removals = new LinkedHashMap();
    public LinkedHashMap<String, SubBiomeEntry> subBiomes = new LinkedHashMap();
    public LinkedHashMap<String, ParentBiomeEntry> subRemovals = new LinkedHashMap();
    public LinkedHashMap<String, HillBiomeEntry> hillBiomes = new LinkedHashMap();
    public LinkedHashMap<String, ParentBiomeEntry> hillRemovals = new LinkedHashMap();
    public LinkedHashMap<String, HeightModEntry> heightMods = new LinkedHashMap();
    public LinkedHashMap<String, BiomeEntry> heightModRemovals = new LinkedHashMap();
    public LinkedHashMap<String, SmoothingEntry> smoothing = new LinkedHashMap();

    public void apply(BiomeSettings toApply) {
        String key;
        for (BiomeReplacement biomeReplacement : toApply.replacements.values()) {
            BiomeEntry def;
            ArrayList<BiomeDefinition> toReAdd = new ArrayList<BiomeDefinition>();
            Iterator<Map.Entry<String, BiomeEntry>> iter = this.biomes.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry<String, BiomeDefinition> entry = iter.next();
                def = entry.getValue();
                if (!def.name.equals((Object)biomeReplacement.replace)) continue;
                def.name = biomeReplacement.name;
                toReAdd.add((BiomeDefinition)def);
                iter.remove();
            }
            for (BiomeDefinition biomeDefinition : toReAdd) {
                this.biomes.put(biomeDefinition.getMapKey(), biomeDefinition);
            }
            toReAdd = new ArrayList();
            iter = this.subBiomes.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry<String, BiomeEntry> entry = iter.next();
                def = (SubBiomeEntry)entry.getValue();
                if (!((SubBiomeEntry)def).name.equals((Object)biomeReplacement.replace) && !((SubBiomeEntry)def).parentBiome.equals((Object)biomeReplacement.replace)) continue;
                if (((SubBiomeEntry)def).name.equals((Object)biomeReplacement.replace)) {
                    ((SubBiomeEntry)def).name = biomeReplacement.name;
                }
                if (((SubBiomeEntry)def).parentBiome.equals((Object)biomeReplacement.replace)) {
                    ((SubBiomeEntry)def).parentBiome = biomeReplacement.name;
                }
                toReAdd.add((BiomeDefinition)def);
                iter.remove();
            }
            for (SubBiomeEntry subBiomeEntry : toReAdd) {
                this.subBiomes.put(subBiomeEntry.getMapKey(), subBiomeEntry);
            }
            toReAdd = new ArrayList();
            iter = this.hillBiomes.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry<String, BiomeEntry> entry = iter.next();
                def = (HillBiomeEntry)entry.getValue();
                if (!((HillBiomeEntry)def).name.equals((Object)biomeReplacement.replace) && !((HillBiomeEntry)def).parentBiome.equals((Object)biomeReplacement.replace)) continue;
                if (((HillBiomeEntry)def).name.equals((Object)biomeReplacement.replace)) {
                    ((HillBiomeEntry)def).name = biomeReplacement.name;
                }
                if (((HillBiomeEntry)def).parentBiome.equals((Object)biomeReplacement.replace)) {
                    ((HillBiomeEntry)def).parentBiome = biomeReplacement.name;
                }
                toReAdd.add((BiomeDefinition)def);
                iter.remove();
            }
            for (HillBiomeEntry hillBiomeEntry : toReAdd) {
                this.hillBiomes.put(hillBiomeEntry.getMapKey(), hillBiomeEntry);
            }
            toReAdd = new ArrayList();
            iter = this.heightMods.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry<String, BiomeEntry> entry = iter.next();
                def = (HeightModEntry)entry.getValue();
                if (!((HeightModEntry)def).name.equals((Object)biomeReplacement.replace)) continue;
                ((HeightModEntry)def).name = biomeReplacement.name;
                toReAdd.add((BiomeDefinition)def);
                iter.remove();
            }
            for (HeightModEntry heightModEntry : toReAdd) {
                this.heightMods.put(heightModEntry.getMapKey(), heightModEntry);
            }
        }
        for (Map.Entry entry : toApply.groupRemovals.entrySet()) {
            if (!this.groups.containsKey(entry.getKey())) continue;
            this.groups.remove(entry.getKey());
        }
        for (Map.Entry entry : toApply.removals.entrySet()) {
            if (!this.biomes.containsKey(entry.getKey())) continue;
            this.biomes.remove(entry.getKey());
        }
        for (Map.Entry entry : toApply.subRemovals.entrySet()) {
            if (!this.subBiomes.containsKey(entry.getKey())) continue;
            this.subBiomes.remove(entry.getKey());
        }
        for (Map.Entry entry : toApply.hillRemovals.entrySet()) {
            if (!this.hillBiomes.containsKey(entry.getKey())) continue;
            this.hillBiomes.remove(entry.getKey());
        }
        for (Map.Entry entry : toApply.heightModRemovals.entrySet()) {
            if (!this.heightMods.containsKey(entry.getKey())) continue;
            this.heightMods.remove(entry.getKey());
        }
        this.groups.putAll(toApply.groups);
        for (Map.Entry entry : toApply.biomes.entrySet()) {
            key = (String)entry.getKey();
            if (this.biomes.containsKey(key)) {
                this.biomes.get((Object)key).weight += toApply.biomes.get((Object)key).weight;
                continue;
            }
            this.biomes.put(key, (BiomeDefinition)entry.getValue());
        }
        for (Map.Entry entry : toApply.subBiomes.entrySet()) {
            key = (String)entry.getKey();
            if (this.subBiomes.containsKey(key)) {
                this.subBiomes.get((Object)key).weight += toApply.subBiomes.get((Object)key).weight;
                continue;
            }
            this.subBiomes.put(key, (SubBiomeEntry)entry.getValue());
        }
        this.hillBiomes.putAll(toApply.hillBiomes);
        this.heightMods.putAll(toApply.heightMods);
        this.smoothing.putAll(toApply.smoothing);
    }

    @Override
    public BiomeSettings readFromJson(String input) {
        return (BiomeSettings)super.readFromJson(input);
    }

    @Override
    public void readData(JsonObject json) {
        Settings.IJsonMappable.readJsonableMap(json, this.groups, "groups", GroupDefinition.class);
        Settings.IJsonMappable.readJsonableMap(json, this.groupRemovals, "groupremove", GroupEntry.class);
        Settings.IJsonMappable.readJsonableMap(json, this.replacements, "replace", BiomeReplacement.class);
        GroupedBiomeEntry.readGroupedEntryMap(json, this.biomes, "biomes", BiomeDefinition.class);
        GroupedBiomeEntry.readGroupedEntryMap(json, this.removals, "biomeremove", GroupedBiomeEntry.class);
        Settings.IJsonMappable.readJsonableMap(json, this.subBiomes, "subbiomes", SubBiomeEntry.class);
        Settings.IJsonMappable.readJsonableMap(json, this.subRemovals, "subremove", ParentBiomeEntry.class);
        Settings.IJsonMappable.readJsonableMap(json, this.hillBiomes, "hillbiomes", HillBiomeEntry.class);
        Settings.IJsonMappable.readJsonableMap(json, this.hillRemovals, "hillremove", ParentBiomeEntry.class);
        Settings.IJsonMappable.readJsonableMap(json, this.heightMods, "heightmods", HeightModEntry.class);
        Settings.IJsonMappable.readJsonableMap(json, this.heightModRemovals, "heightmodremoval", BiomeEntry.class);
        Settings.IJsonMappable.readJsonableMap(json, this.smoothing, "smoothing", SmoothingEntry.class);
    }

    @Override
    public void writeData(JsonObject json) {
        Settings.IJsonMappable.writeJsonableMap(json, this.groups, "groups");
        Settings.IJsonMappable.writeJsonableMap(json, this.groupRemovals, "groupremove");
        Settings.IJsonMappable.writeJsonableMap(json, this.replacements, "replace");
        GroupedBiomeEntry.writeGroupedEntryMap(json, this.biomes, "biomes");
        GroupedBiomeEntry.writeGroupedEntryMap(json, this.removals, "biomeremove");
        Settings.IJsonMappable.writeJsonableMap(json, this.subBiomes, "subbiomes");
        Settings.IJsonMappable.writeJsonableMap(json, this.subRemovals, "subremove");
        Settings.IJsonMappable.writeJsonableMap(json, this.hillBiomes, "hillbiomes");
        Settings.IJsonMappable.writeJsonableMap(json, this.hillRemovals, "hillremove");
        Settings.IJsonMappable.writeJsonableMap(json, this.heightMods, "heightmods");
        Settings.IJsonMappable.writeJsonableMap(json, this.heightModRemovals, "heightmodremove");
        Settings.IJsonMappable.writeJsonableMap(json, this.smoothing, "smoothing");
    }

    @Override
    public BiomeSettings copy() {
        BiomeSettings copy = new BiomeSettings();
        Settings.IJsonMappable.copyMap(this.groups, copy.groups);
        Settings.IJsonMappable.copyMap(this.groupRemovals, copy.groupRemovals);
        Settings.IJsonMappable.copyMap(this.replacements, copy.replacements);
        Settings.IJsonMappable.copyMap(this.biomes, copy.biomes);
        Settings.IJsonMappable.copyMap(this.removals, copy.removals);
        Settings.IJsonMappable.copyMap(this.subBiomes, copy.subBiomes);
        Settings.IJsonMappable.copyMap(this.subRemovals, copy.subRemovals);
        Settings.IJsonMappable.copyMap(this.hillBiomes, copy.hillBiomes);
        Settings.IJsonMappable.copyMap(this.hillRemovals, copy.hillRemovals);
        Settings.IJsonMappable.copyMap(this.heightMods, copy.heightMods);
        Settings.IJsonMappable.copyMap(this.heightModRemovals, copy.heightModRemovals);
        Settings.IJsonMappable.copyMap(this.smoothing, copy.smoothing);
        return copy;
    }

    @Override
    public int compareTo(BiomeSettings o) {
        return 0;
    }

    public static class SmoothingEntry
    extends BiomeEntry {
        public double smoothing = 1.0;

        @Override
        public JsonObject toJson() {
            JsonObject o = super.toJson();
            o.addProperty("s", (Number)this.smoothing);
            return o;
        }

        @Override
        public void fromJson(JsonObject o) {
            super.fromJson(o);
            if (o.has("s")) {
                this.smoothing = JsonUtil.get(o, "s", 1.0);
            }
        }

        @Override
        public SmoothingEntry copy() {
            SmoothingEntry copy = new SmoothingEntry();
            copy.name = new ResourceLocation(this.name.toString());
            copy.smoothing = this.smoothing;
            return copy;
        }
    }

    public static class HeightModEntry
    extends BiomeEntry {
        public String heightMod = "";
        public Map<String, Object> parameters = new HashMap<String, Object>();

        @Override
        public JsonObject toJson() {
            Map<String, BiomeModParameter> params;
            JsonObject o = super.toJson();
            o.addProperty("mod", this.heightMod);
            JsonObject po = new JsonObject();
            IBiomeHeightModifier mod = RWG.globalRegistry.getHeightModifier(this.heightMod);
            if (mod != null && (params = mod.getSettings()) != null) {
                for (Map.Entry<String, BiomeModParameter> e : params.entrySet()) {
                    Object val;
                    String key = e.getKey();
                    BiomeModParameter param = e.getValue();
                    if (!this.parameters.containsKey(key) || (val = this.parameters.get(key)).equals(param.defaultValue)) continue;
                    param.writeToJson(po, key, val);
                }
            }
            if (!po.entrySet().isEmpty()) {
                o.add("params", (JsonElement)po);
            }
            return o;
        }

        @Override
        public void fromJson(JsonObject o) {
            super.fromJson(o);
            if (o.has("mod")) {
                this.heightMod = JsonUtil.get(o, "mod", "");
            }
            if (o.has("params")) {
                Map<String, BiomeModParameter> params;
                JsonObject po = JsonUtil.getAsObject(o, "params");
                IBiomeHeightModifier mod = RWG.globalRegistry.getHeightModifier(this.heightMod);
                if (mod != null && (params = mod.getSettings()) != null) {
                    for (Map.Entry<String, BiomeModParameter> e : params.entrySet()) {
                        String key = e.getKey();
                        BiomeModParameter param = e.getValue();
                        if (!po.has(key)) continue;
                        this.parameters.put(key, param.readFromJson(po, key));
                    }
                }
            }
        }

        @Override
        public HeightModEntry copy() {
            HeightModEntry copy = new HeightModEntry();
            copy.name = new ResourceLocation(this.name.toString());
            copy.heightMod = this.heightMod;
            copy.parameters.putAll(this.parameters);
            return copy;
        }
    }

    public static class HillBiomeEntry
    extends ParentBiomeEntry {
        public double height = 1.0;

        @Override
        public JsonObject toJson() {
            JsonObject o = super.toJson();
            o.addProperty("height", (Number)this.height);
            return o;
        }

        @Override
        public void fromJson(JsonObject o) {
            super.fromJson(o);
            if (o.has("height")) {
                this.height = JsonUtil.get(o, "height", 0.25);
            }
        }

        @Override
        public HillBiomeEntry copy() {
            HillBiomeEntry copy = new HillBiomeEntry();
            copy.name = new ResourceLocation(this.name.toString());
            copy.parentBiome = new ResourceLocation(this.parentBiome.toString());
            copy.height = this.height;
            return copy;
        }

        @Override
        public String getMapKey() {
            return this.name + "_" + this.parentBiome + "_" + this.height;
        }
    }

    public static class SubBiomeEntry
    extends ParentBiomeEntry {
        public double weight = 1.0;

        @Override
        public JsonObject toJson() {
            JsonObject o = super.toJson();
            o.addProperty("weight", (Number)this.weight);
            return o;
        }

        @Override
        public void fromJson(JsonObject o) {
            super.fromJson(o);
            if (o.has("weight")) {
                this.weight = JsonUtil.get(o, "weight", 1.0);
            }
        }

        @Override
        public SubBiomeEntry copy() {
            SubBiomeEntry copy = new SubBiomeEntry();
            copy.name = new ResourceLocation(this.name.toString());
            copy.parentBiome = new ResourceLocation(this.parentBiome.toString());
            copy.weight = this.weight;
            return copy;
        }
    }

    public static class ParentBiomeEntry
    extends BiomeEntry {
        public ResourceLocation parentBiome = null;

        @Override
        public JsonObject toJson() {
            JsonObject o = super.toJson();
            o.addProperty("parent", this.parentBiome.toString());
            return o;
        }

        @Override
        public void fromJson(JsonObject o) {
            super.fromJson(o);
            if (o.has("parent")) {
                this.parentBiome = new ResourceLocation(JsonUtil.get(o, "parent", "invalid"));
            }
        }

        @Override
        public String getMapKey() {
            return this.name + "_" + this.parentBiome;
        }

        @Override
        public ParentBiomeEntry copy() {
            ParentBiomeEntry copy = new ParentBiomeEntry();
            copy.name = new ResourceLocation(this.name.toString());
            copy.parentBiome = new ResourceLocation(this.parentBiome.toString());
            return copy;
        }
    }

    public static class BiomeReplacement
    extends BiomeEntry {
        public static final ResourceLocation DEFAULT_BIOME_TARGET = Biomes.field_185440_P.getRegistryName();
        public ResourceLocation replace = DEFAULT_BIOME_TARGET;

        @Override
        public JsonObject toJson() {
            JsonObject o = super.toJson();
            o.addProperty("replace", this.replace.toString());
            return o;
        }

        @Override
        public void fromJson(JsonObject o) {
            super.fromJson(o);
            if (o.has("replace")) {
                this.replace = new ResourceLocation(JsonUtil.get(o, "replace", "invalid"));
            }
        }

        @Override
        public BiomeReplacement copy() {
            BiomeReplacement copy = new BiomeReplacement();
            copy.name = new ResourceLocation(this.name.toString());
            copy.replace = new ResourceLocation(this.replace.toString());
            return copy;
        }
    }

    public static class BiomeDefinition
    extends GroupedBiomeEntry {
        public double weight = 1.0;

        @Override
        public JsonObject toJson() {
            JsonObject o = super.toJson();
            o.addProperty("weight", (Number)this.weight);
            return o;
        }

        @Override
        public void fromJson(JsonObject o) {
            super.fromJson(o);
            if (o.has("weight")) {
                this.weight = JsonUtil.get(o, "weight", 1.0);
            }
        }

        @Override
        public BiomeDefinition copy() {
            BiomeDefinition copy = new BiomeDefinition();
            copy.name = new ResourceLocation(this.name.toString());
            copy.category = this.category;
            copy.group = this.group;
            copy.weight = this.weight;
            return copy;
        }
    }

    public static class GroupedBiomeEntry
    extends BiomeEntry {
        public BiomeRegistry.EnumBiomeCategory category = BiomeRegistry.EnumBiomeCategory.UNKNOWN;
        public String group = "";

        protected static <T extends GroupedBiomeEntry> void readGroupedEntryMap(JsonObject readFrom, LinkedHashMap<String, T> list, String tagname, Class<T> clazz) {
            list.clear();
            if (readFrom.has(tagname)) {
                JsonObject b = JsonUtil.getAsObject(readFrom, tagname);
                GroupedBiomeEntry.readGroupedEntryMap(b, list, clazz);
            }
        }

        protected static <T extends GroupedBiomeEntry> void readGroupedEntryMap(JsonObject o, LinkedHashMap<String, T> list, Class<T> clazz) {
            for (Map.Entry entry : o.entrySet()) {
                BiomeRegistry.EnumBiomeCategory category = BiomeRegistry.EnumBiomeCategory.get((String)entry.getKey());
                if (category == null) continue;
                JsonObject cgroups = JsonUtil.asObject((JsonElement)entry.getValue());
                for (Map.Entry groupentry : cgroups.entrySet()) {
                    String group = (String)groupentry.getKey();
                    JsonArray gbiomes = JsonUtil.asArray((JsonElement)groupentry.getValue());
                    for (JsonElement biome : gbiomes) {
                        GroupedBiomeEntry bd = (GroupedBiomeEntry)Settings.IJsonable.create(clazz);
                        if (bd == null) {
                            return;
                        }
                        bd.fromJson(JsonUtil.asObject(biome));
                        bd.category = category;
                        bd.group = group;
                        list.put(bd.getMapKey(), bd);
                    }
                }
            }
        }

        protected static <T extends GroupedBiomeEntry> void writeGroupedEntryMap(JsonObject writeTo, LinkedHashMap<String, T> list, String tagname) {
            if (!list.isEmpty()) {
                JsonObject categories = new JsonObject();
                GroupedBiomeEntry.writeGroupedEntryMap(categories, list);
                writeTo.add(tagname, (JsonElement)categories);
            }
        }

        protected static <T extends GroupedBiomeEntry> void writeGroupedEntryMap(JsonObject o, LinkedHashMap<String, T> list) {
            for (GroupedBiomeEntry biome : list.values()) {
                JsonObject catobject;
                String catname = biome.category.toString();
                if (!o.has(catname)) {
                    o.add(catname, (JsonElement)new JsonObject());
                }
                if (!(catobject = JsonUtil.getAsObject(o, catname)).has(biome.group)) {
                    catobject.add(biome.group, (JsonElement)new JsonArray());
                }
                JsonArray groupobject = JsonUtil.getAsArray(catobject, biome.group);
                groupobject.add((JsonElement)biome.toJson());
            }
        }

        @Override
        public String getMapKey() {
            return (Object)((Object)this.category) + "_" + this.group + "_" + this.name.toString();
        }

        @Override
        public GroupedBiomeEntry copy() {
            GroupedBiomeEntry copy = new GroupedBiomeEntry();
            copy.name = new ResourceLocation(this.name.toString());
            copy.category = this.category;
            copy.group = this.group;
            return copy;
        }
    }

    public static class BiomeEntry
    implements Settings.IJsonMappable {
        public static final ResourceLocation DEFAULT_BIOME_NAME = Biomes.field_76772_c.getRegistryName();
        public ResourceLocation name = DEFAULT_BIOME_NAME;

        @Override
        public JsonObject toJson() {
            JsonObject o = new JsonObject();
            o.addProperty("biome", this.name.toString());
            return o;
        }

        @Override
        public void fromJson(JsonObject o) {
            if (o.has("biome")) {
                this.name = new ResourceLocation(JsonUtil.get(o, "biome", "invalid"));
            }
        }

        @Override
        public String getMapKey() {
            return this.name.toString();
        }

        @Override
        public BiomeEntry copy() {
            BiomeEntry copy = new BiomeEntry();
            copy.name = new ResourceLocation(this.name.toString());
            return copy;
        }
    }

    public static class GroupDefinition
    extends GroupEntry {
        public double height = 0.25;
        public double temperature = 0.5;
        public double moisture = 0.5;
        public double minHeight = 0.0;
        public double maxHeight = 1.0;
        public int blobsize = 0;
        public int subblobsize = 0;

        @Override
        public JsonObject toJson() {
            JsonObject o = super.toJson();
            o.addProperty("height", (Number)this.height);
            o.addProperty("temp", (Number)this.temperature);
            o.addProperty("moisture", (Number)this.moisture);
            if (this.minHeight != 0.0) {
                o.addProperty("minheight", (Number)this.minHeight);
            }
            if (this.maxHeight != 1.0) {
                o.addProperty("maxheight", (Number)this.maxHeight);
            }
            if (this.blobsize != 0) {
                o.addProperty("blobsize", (Number)this.blobsize);
            }
            if (this.subblobsize != 0) {
                o.addProperty("subblobsize", (Number)this.subblobsize);
            }
            return o;
        }

        @Override
        public void fromJson(JsonObject o) {
            super.fromJson(o);
            if (o.has("height")) {
                this.height = JsonUtil.get(o, "height", 0.25);
            }
            if (o.has("temp")) {
                this.temperature = JsonUtil.get(o, "temp", 0.5);
            }
            if (o.has("moisture")) {
                this.moisture = JsonUtil.get(o, "moisture", 0.5);
            }
            if (o.has("minheight")) {
                this.minHeight = JsonUtil.get(o, "minheight", 0.0);
            }
            if (o.has("maxheight")) {
                this.maxHeight = JsonUtil.get(o, "maxheight", 1.0);
            }
            if (o.has("blobsize")) {
                this.blobsize = JsonUtil.get(o, "blobsize", 0);
            }
            if (o.has("subblobsize")) {
                this.subblobsize = JsonUtil.get(o, "subblobsize", 0);
            }
        }

        @Override
        public GroupDefinition copy() {
            GroupDefinition copy = new GroupDefinition();
            copy.category = this.category;
            copy.name = this.name;
            copy.height = this.height;
            copy.temperature = this.temperature;
            copy.moisture = this.moisture;
            copy.minHeight = this.minHeight;
            copy.maxHeight = this.maxHeight;
            copy.blobsize = this.blobsize;
            copy.subblobsize = this.subblobsize;
            return copy;
        }
    }

    public static class GroupEntry
    implements Settings.IJsonMappable {
        public BiomeRegistry.EnumBiomeCategory category = BiomeRegistry.EnumBiomeCategory.UNKNOWN;
        public String name = "New Group";

        @Override
        public JsonObject toJson() {
            JsonObject o = new JsonObject();
            o.addProperty("type", this.category.toString());
            o.addProperty("name", this.name);
            return o;
        }

        @Override
        public void fromJson(JsonObject o) {
            if (o.has("type")) {
                this.category = BiomeRegistry.EnumBiomeCategory.get(JsonUtil.get(o, "type", "UNKNOWN"));
            }
            if (o.has("name")) {
                this.name = JsonUtil.get(o, "name", "Invalid Group");
            }
        }

        @Override
        public String getMapKey() {
            return (Object)((Object)this.category) + "_" + this.name;
        }

        @Override
        public GroupEntry copy() {
            GroupEntry copy = new GroupEntry();
            copy.category = this.category;
            copy.name = this.name;
            return copy;
        }
    }
}

