/*
 * Decompiled with CFR 0.152.
 */
package kenijey.rwg.util;

import java.util.Random;

public abstract class MathUtil {
    private static Random fuzz = new Random();

    public static double clamp(double num, double min, double max) {
        return Math.max(min, Math.min(max, num));
    }

    public static int clamp(int num, int min, int max) {
        return Math.max(min, Math.min(max, num));
    }

    public static double polymax(double a, double b, double div) {
        double h = MathUtil.clamp(0.5 + 0.5 * (b - a) / div, 0.0, 1.0);
        return b * h + a * (1.0 - h) + div * h * (1.0 - h);
    }

    public static double plateau(double height, int minHeight, int plateauHeight, int maxHeight, double exponent, boolean limit) {
        double out = height;
        if ((height *= 255.0) >= (double)minHeight && height <= (double)maxHeight) {
            int iheight = (int)height;
            if (height >= (double)minHeight && height <= (double)plateauHeight) {
                int range = plateauHeight - minHeight;
                int diff = plateauHeight - iheight;
                double rdiff = (double)plateauHeight - height;
                double factor = diff / range;
                factor = Math.pow(factor, exponent);
                double rfactor = rdiff / (double)range;
                rfactor = Math.pow(rfactor, exponent);
                double ffactor = Math.min(1.0, factor * 0.25 + rfactor * 0.75);
                out = ((double)plateauHeight - ffactor * (double)range) / 255.0;
            } else if (height <= (double)maxHeight && height > (double)plateauHeight) {
                int range = maxHeight - plateauHeight;
                int diff = iheight - plateauHeight;
                double rdiff = height - (double)plateauHeight;
                double factor = diff / range;
                factor = Math.pow(factor, exponent);
                double rfactor = rdiff / (double)range;
                rfactor = Math.pow(rfactor, exponent);
                double ffactor = Math.min(1.0, factor * 0.25 + rfactor * 0.75);
                out = ((double)plateauHeight + ffactor * (double)range) / 255.0;
            }
        }
        if (limit) {
            out = MathUtil.clamp(out, (double)minHeight / 255.0, (double)maxHeight / 255.0);
        }
        return out;
    }

    public static final long xorShift64(long a) {
        a ^= a << 21;
        a ^= a >> 35;
        a ^= a << 4;
        return a;
    }

    public static final long coordRandom(long x, long z, long seed) {
        return MathUtil.xorShift64(MathUtil.xorShift64(x) + Long.rotateLeft(MathUtil.xorShift64(z), 32)) + seed;
    }

    public static final long coordSeed(long x, long z, long seed) {
        return seed ^ Long.rotateLeft(MathUtil.xorShift64(x), 16) ^ Long.rotateLeft(MathUtil.xorShift64(z), 48);
    }

    public static double smoothstep(double n) {
        return n * n * (3.0 - 2.0 * n);
    }

    public static double smoothrange(double n, double min, double max) {
        n = MathUtil.clamp((n - min) / (max - min), 0.0, 1.0);
        return MathUtil.smoothstep(n);
    }

    public static double spreadRange(double n, double fulcrum, double mult, double offset) {
        return MathUtil.spreadRange(n, fulcrum, mult, offset, 0.0, 1.0);
    }

    public static double spreadRange(double n, double fulcrum, double mult, double offset, double min, double max) {
        return Math.max(min, Math.min(max, (n - fulcrum) * mult + fulcrum * mult + offset));
    }

    public static double getFuzz(int x, int z, int salt) {
        double out = 0.0;
        int ox = 3847234;
        int oz = 8362482;
        long xm = x * ox;
        long zm = z * oz;
        fuzz.setSeed((xm ^ zm) + (long)salt);
        out += fuzz.nextDouble();
        fuzz.setSeed((xm + (long)ox ^ zm) + (long)salt);
        out += fuzz.nextDouble();
        fuzz.setSeed((xm - (long)ox ^ zm) + (long)salt);
        out += fuzz.nextDouble();
        fuzz.setSeed((xm ^ zm + (long)oz) + (long)salt);
        out += fuzz.nextDouble();
        fuzz.setSeed((xm ^ zm - (long)oz) + (long)salt);
        return (out += fuzz.nextDouble()) * 0.2 - 0.5;
    }

    public static int coordHash(int x, int z) {
        int hash = 31;
        hash = (hash + x << 13) - (hash + x);
        hash = (hash + z << 13) - (hash + z);
        return hash;
    }
}

