/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.aiotbotania.util;

import de.melanx.aiotbotania.blocks.ModBlocks;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockGrass;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.UseHoeEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.client.core.handler.ItemsRemainingRenderHandler;
import vazkii.botania.common.core.helper.ItemNBTHelper;
import vazkii.botania.common.item.equipment.tool.ToolCommons;

public class ToolUtil {
    private static final Pattern TORCH_PATTERN = Pattern.compile("(?:(?:(?:[A-Z-_.:]|^)torch)|(?:(?:[a-z-_.:]|^)Torch))(?:[A-Z-_.:]|$)");
    private static final Pattern SAPLING_PATTERN = Pattern.compile("(?:(?:(?:[A-Z-_.:]|^)sapling)|(?:(?:[a-z-_.:]|^)Sapling))(?:[A-Z-_.:]|$)");

    public static void onUpdate(ItemStack stack, World world, Entity player, int MPD) {
        if (!world.field_72995_K && player instanceof EntityPlayer && stack.func_77952_i() > 0 && ManaItemHandler.requestManaExactForTool((ItemStack)stack, (EntityPlayer)((EntityPlayer)player), (int)(MPD * 2), (boolean)true)) {
            stack.func_77964_b(stack.func_77952_i() - 1);
        }
    }

    public static boolean hitEntity(ItemStack stack, EntityLivingBase entity, int MPD) {
        ToolCommons.damageItem((ItemStack)stack, (int)1, (EntityLivingBase)entity, (int)MPD);
        return true;
    }

    public static boolean onBlockDestroyed(ItemStack stack, World world, IBlockState state, BlockPos pos, EntityLivingBase entity, int MPD) {
        if (state.func_185887_b(world, pos) != 0.0f) {
            ToolCommons.damageItem((ItemStack)stack, (int)1, (EntityLivingBase)entity, (int)MPD);
        }
        return true;
    }

    public static void toggleMode(EntityPlayer player, ItemStack stack) {
        ITextComponent text;
        if (ItemNBTHelper.getBoolean((ItemStack)stack, (String)"hoemode", (boolean)true)) {
            ItemNBTHelper.setBoolean((ItemStack)stack, (String)"hoemode", (boolean)false);
            text = new TextComponentTranslation("aiotbotania.toggleMode", new Object[0]).func_150258_a(" ").func_150255_a(new Style().func_150238_a(TextFormatting.DARK_BLUE).func_150217_b(Boolean.valueOf(true))).func_150257_a(new TextComponentTranslation("aiotbotania.utilityMode", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.AQUA).func_150217_b(Boolean.valueOf(true))));
        } else {
            ItemNBTHelper.setBoolean((ItemStack)stack, (String)"hoemode", (boolean)true);
            text = new TextComponentTranslation("aiotbotania.toggleMode", new Object[0]).func_150258_a(" ").func_150255_a(new Style().func_150238_a(TextFormatting.DARK_BLUE).func_150217_b(Boolean.valueOf(true))).func_150257_a(new TextComponentTranslation("aiotbotania.hoeMode", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.AQUA).func_150217_b(Boolean.valueOf(true))));
        }
        player.func_146105_b(text, true);
    }

    private static EnumActionResult tiltBlock(EntityPlayer player, World world, BlockPos pos, ItemStack stack, Block block1, int MPD) {
        SoundType soundtype = block1.getSoundType(block1.func_176223_P(), world, pos, (Entity)player);
        world.func_184133_a(null, pos, soundtype.func_185844_d(), SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f);
        if (!world.field_72995_K) {
            world.func_175656_a(pos, block1.func_176223_P());
            ToolCommons.damageItem((ItemStack)stack, (int)1, (EntityLivingBase)player, (int)MPD);
        }
        return EnumActionResult.SUCCESS;
    }

    public static EnumActionResult hoeUse(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing side, boolean special, boolean low_tier, int MPD) {
        ItemStack stack = player.func_184586_b(hand);
        if (!player.func_175151_a(pos, side, stack)) {
            return EnumActionResult.FAIL;
        }
        UseHoeEvent event = new UseHoeEvent(player, stack, world, pos);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return EnumActionResult.FAIL;
        }
        if (event.getResult() == Event.Result.ALLOW) {
            ToolCommons.damageItem((ItemStack)stack, (int)1, (EntityLivingBase)player, (int)MPD);
            return EnumActionResult.SUCCESS;
        }
        Block block = world.func_180495_p(pos).func_177230_c();
        if (side != EnumFacing.DOWN && world.func_175623_d(pos.func_177984_a())) {
            if (block == Blocks.field_150349_c || block == Blocks.field_185774_da || block == Blocks.field_150346_d) {
                Block block1 = Blocks.field_150458_ak;
                if (special) {
                    block1 = ModBlocks.superfarmland;
                }
                return ToolUtil.tiltBlock(player, world, pos, stack, block1, MPD);
            }
            if (block == Blocks.field_150458_ak && !low_tier) {
                Block block1 = Blocks.field_150346_d;
                return ToolUtil.tiltBlock(player, world, pos, stack, block1, MPD);
            }
            if ((block == Blocks.field_150458_ak || block == ModBlocks.superfarmland) && special) {
                BlockGrass block1 = Blocks.field_150349_c;
                return ToolUtil.tiltBlock(player, world, pos, stack, (Block)block1, MPD);
            }
        }
        return EnumActionResult.SUCCESS;
    }

    @Nonnull
    public static EnumActionResult pickUse(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing side, float sx, float sy, float sz) {
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack stackAt = player.field_71071_by.func_70301_a(i);
            if (stackAt.func_190926_b() || !TORCH_PATTERN.matcher(stackAt.func_77973_b().func_77658_a()).find()) continue;
            ItemStack saveHeldStack = player.func_184586_b(hand);
            player.func_184611_a(hand, stackAt);
            EnumActionResult did = stackAt.func_77973_b().func_180614_a(player, world, pos, hand, side, sx, sy, sz);
            player.func_184611_a(hand, saveHeldStack);
            ItemsRemainingRenderHandler.set((EntityPlayer)player, (ItemStack)new ItemStack(Blocks.field_150478_aa), (Pattern)TORCH_PATTERN);
            return did;
        }
        return EnumActionResult.PASS;
    }

    @Nonnull
    public static EnumActionResult axeUse(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing side, float sx, float sy, float sz) {
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack stackAt = player.field_71071_by.func_70301_a(i);
            if (stackAt.func_190926_b() || !SAPLING_PATTERN.matcher(stackAt.func_77973_b().func_77658_a()).find()) continue;
            ItemStack saveHeldStack = player.func_184586_b(hand);
            player.func_184611_a(hand, stackAt);
            EnumActionResult did = stackAt.func_77973_b().func_180614_a(player, world, pos, hand, side, sx, sy, sz);
            player.func_184611_a(hand, saveHeldStack);
            ItemsRemainingRenderHandler.set((EntityPlayer)player, (ItemStack)new ItemStack(Blocks.field_150345_g), (Pattern)SAPLING_PATTERN);
            return did;
        }
        return EnumActionResult.PASS;
    }

    public static EnumActionResult shovelUse(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing side, int MPD) {
        ItemStack stack = player.func_184586_b(hand);
        if (!player.func_175151_a(pos, side, stack)) {
            return EnumActionResult.FAIL;
        }
        UseHoeEvent event = new UseHoeEvent(player, stack, world, pos);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            return EnumActionResult.FAIL;
        }
        if (event.getResult() == Event.Result.ALLOW) {
            ToolCommons.damageItem((ItemStack)stack, (int)1, (EntityLivingBase)player, (int)MPD);
            return EnumActionResult.SUCCESS;
        }
        Block block = world.func_180495_p(pos).func_177230_c();
        if (side != EnumFacing.DOWN && world.func_180495_p(pos.func_177984_a()).func_177230_c().isAir(world.func_180495_p(pos.func_177984_a()), (IBlockAccess)world, pos.func_177984_a()) && (block == Blocks.field_150349_c || block == Blocks.field_150346_d)) {
            Block block1 = Blocks.field_185774_da;
            ToolUtil.tiltBlock(player, world, pos, stack, block1, MPD);
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.SUCCESS;
    }
}

