/*
 * Decompiled with CFR 0.152.
 */
package com.Mrbysco.LiquidBlocks.config;

import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Config(modid="liquidblocks")
@Config.LangKey(value="liquidblocks.config.title")
public class LiquidConfigGen {
    @Config.Comment(value={"General settings"})
    public static General general = new General();
    @Config.Comment(value={"Liquid settings"})
    public static Liquid liquid = new Liquid();
    @Config.Comment(value={"Crafting settings"})
    public static Crafting crafting = new Crafting();

    @Mod.EventBusSubscriber(modid="liquidblocks")
    private static class EventHandler {
        private EventHandler() {
        }

        @SubscribeEvent
        public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
            if (event.getModID().equals("liquidblocks")) {
                ConfigManager.sync((String)"liquidblocks", (Config.Type)Config.Type.INSTANCE);
            }
        }
    }

    public static class Crafting {
        @Config.Comment(value={"Enable crafting buckets with ice [default: true]"})
        public boolean enableCraftingWithIce = true;
        @Config.Comment(value={"Enable crafting buckets with a water bottle where applicable [default: true]"})
        public boolean enableCraftingWithWater = true;
        @Config.Comment(value={"Enable crafting buckets with a bucket of the fitting liquid [default: true]"})
        public boolean enableCraftingWithBucket = true;
        @Config.Comment(value={"Enables the crafting of the Liquid Ore bucket [default: true]"})
        public boolean enableCraftingLiquidOre = true;
    }

    public static class Liquid {
        @Config.Comment(value={"The time liquid dirt types take to solidify [default: 220]"})
        public int dirtSolidifyTime = 220;
        @Config.Comment(value={"The time liquid stone types take to solidify [default: 200]"})
        public int stoneSolidifyTime = 200;
        @Config.Comment(value={"The time liquid sandstone type takes to solidify [default: 200]"})
        public int sandstoneSolidifyTime = 200;
        @Config.Comment(value={"The time liquid sand types take to solidify [default: 200]"})
        public int sandSolidifyTime = 200;
        @Config.Comment(value={"The time liquid gravel takes to solidify [default: 200]"})
        public int gravelSolidifyTime = 200;
        @Config.Comment(value={"The time liquid nether liquid types take to solidify [default: 200]"})
        public int netherSolidifyTime = 200;
        @Config.Comment(value={"The time liquid clay types take to solidify [default: 200]"})
        public int claySolidifyTime = 200;
        @Config.Comment(value={"The time liquid terracotta types take to solidify [default: 200]"})
        public int terracottaSolidifyTime = 200;
        @Config.Comment(value={"The time liquid concrete types take to solidify [default: 200]"})
        public int concreteSolidifyTime = 200;
    }

    public static class General {
        @Config.Comment(value={"Water based liquids causing nausea when swam in [default: true]"})
        public boolean liquidsCausesNausea = true;
        @Config.Comment(value={"Water based liquids causing when swam in [default: true]"})
        public boolean liquidsCausesSlowness = true;
        @Config.Comment(value={"Turning this to true will make every bit of the liquid turn into a full block [default: true]"})
        public boolean completelyFill = true;
        @Config.Comment(value={"Makes liquid netherrack have a 1 in X chance of drying with fire on top (0 = disabled) [default: 30]"})
        public int netherrackFireChance = 30;
        @Config.Comment(value={"Makes liquid ore have a 1 in X chance of drying into an ore block (higher = less chance) [default: 64]"})
        @Config.RangeInt(min=6)
        public int oreChance = 64;
    }
}

