/*
 * Decompiled with CFR 0.152.
 */
package com.Mrbysco.LiquidBlocks.init;

import com.Mrbysco.LiquidBlocks.LiquidBlocks;
import com.Mrbysco.LiquidBlocks.blocks.BlockLiquidBlock;
import com.Mrbysco.LiquidBlocks.blocks.BlockLiquidOre;
import com.Mrbysco.LiquidBlocks.blocks.LiquidMolten;
import com.Mrbysco.LiquidBlocks.config.LiquidConfigGen;
import com.Mrbysco.LiquidBlocks.util.LiquidUtil;
import java.util.ArrayList;
import java.util.Locale;
import net.minecraft.block.Block;
import net.minecraft.block.BlockColored;
import net.minecraft.block.BlockDirt;
import net.minecraft.block.BlockSand;
import net.minecraft.block.BlockStainedHardenedClay;
import net.minecraft.block.BlockStone;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fluids.BlockFluidBase;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber
public class LiquidRegistry {
    public static LiquidMolten liquidDirt;
    public static LiquidMolten liquidCoarseDirt;
    public static LiquidMolten liquidPodzol;
    public static LiquidMolten liquidStone;
    public static LiquidMolten liquidGranite;
    public static LiquidMolten liquidDiorite;
    public static LiquidMolten liquidAndesite;
    public static LiquidMolten liquidSandstone;
    public static LiquidMolten liquidRedSandstone;
    public static LiquidMolten liquidSand;
    public static LiquidMolten liquidRedsand;
    public static LiquidMolten liquidGravel;
    public static LiquidMolten liquidNetherrack;
    public static LiquidMolten liquidSoulsand;
    public static LiquidMolten liquidMagmablock;
    public static LiquidMolten liquidGlowstone;
    public static LiquidMolten liquidOre;
    public static LiquidMolten liquidClay;
    public static LiquidMolten liquidTerracotta;
    public static LiquidMolten[] liquidStainedTerracotta;
    public static LiquidMolten[] liquidConcrete;
    public static ArrayList<Fluid> LIQUIDS;

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        IForgeRegistry registry = event.getRegistry();
        liquidDirt = LiquidRegistry.createLiquid("liquiddirt", 3746848);
        LiquidRegistry.registerFluidBlock((IForgeRegistry<Block>)registry, liquidDirt, Material.field_151586_h, Blocks.field_150346_d.func_176223_P(), LiquidConfigGen.liquid.dirtSolidifyTime);
        liquidCoarseDirt = LiquidRegistry.createLiquid("liquidcoarsedirt", 3746848);
        LiquidRegistry.registerFluidBlock((IForgeRegistry<Block>)registry, liquidCoarseDirt, Material.field_151586_h, Blocks.field_150346_d.func_176223_P().func_177226_a((IProperty)BlockDirt.field_176386_a, (Comparable)BlockDirt.DirtType.COARSE_DIRT), LiquidConfigGen.liquid.dirtSolidifyTime);
        liquidPodzol = LiquidRegistry.createLiquid("liquidpodzol", 4467220);
        LiquidRegistry.registerFluidBlock((IForgeRegistry<Block>)registry, liquidPodzol, Material.field_151586_h, Blocks.field_150346_d.func_176223_P().func_177226_a((IProperty)BlockDirt.field_176386_a, (Comparable)BlockDirt.DirtType.PODZOL), LiquidConfigGen.liquid.dirtSolidifyTime);
        liquidStone = LiquidRegistry.createLiquid("liquidstone", 0x7F7F7F);
        LiquidRegistry.registerFluidBlock((IForgeRegistry<Block>)registry, liquidStone, Material.field_151587_i, Blocks.field_150348_b.func_176223_P().func_177226_a((IProperty)BlockStone.field_176247_a, (Comparable)BlockStone.EnumType.STONE), LiquidConfigGen.liquid.stoneSolidifyTime);
        liquidGranite = LiquidRegistry.createLiquid("liquidgranite", 11831415);
        LiquidRegistry.registerFluidBlock((IForgeRegistry<Block>)registry, liquidGranite, Material.field_151587_i, Blocks.field_150348_b.func_176223_P().func_177226_a((IProperty)BlockStone.field_176247_a, (Comparable)BlockStone.EnumType.GRANITE), LiquidConfigGen.liquid.stoneSolidifyTime);
        liquidDiorite = LiquidRegistry.createLiquid("liquiddiorite", 0xE0E0E3);
        LiquidRegistry.registerFluidBlock((IForgeRegistry<Block>)registry, liquidDiorite, Material.field_151587_i, Blocks.field_150348_b.func_176223_P().func_177226_a((IProperty)BlockStone.field_176247_a, (Comparable)BlockStone.EnumType.DIORITE), LiquidConfigGen.liquid.stoneSolidifyTime);
        liquidAndesite = LiquidRegistry.createLiquid("liquidandesite", 0xABABAC);
        LiquidRegistry.registerFluidBlock((IForgeRegistry<Block>)registry, liquidAndesite, Material.field_151587_i, Blocks.field_150348_b.func_176223_P().func_177226_a((IProperty)BlockStone.field_176247_a, (Comparable)BlockStone.EnumType.ANDESITE), LiquidConfigGen.liquid.stoneSolidifyTime);
        liquidSandstone = LiquidRegistry.createLiquid("liquidsandstone", 15129006);
        LiquidRegistry.registerFluidBlock((IForgeRegistry<Block>)registry, liquidSandstone, Material.field_151587_i, Blocks.field_150322_A.func_176223_P(), LiquidConfigGen.liquid.sandstoneSolidifyTime);
        liquidRedSandstone = LiquidRegistry.createLiquid("liquidredsandstone", 11820582);
        LiquidRegistry.registerFluidBlock((IForgeRegistry<Block>)registry, liquidRedSandstone, Material.field_151587_i, Blocks.field_180395_cM.func_176223_P(), LiquidConfigGen.liquid.sandstoneSolidifyTime);
        liquidNetherrack = LiquidRegistry.createLiquid("liquidnetherrack", 10378589);
        LiquidRegistry.registerFluidBlock((IForgeRegistry<Block>)registry, liquidNetherrack, Material.field_151587_i, Blocks.field_150424_aL.func_176223_P(), LiquidConfigGen.liquid.netherSolidifyTime);
        liquidSoulsand = LiquidRegistry.createLiquid("liquidsoulsand", 6902339);
        LiquidRegistry.registerFluidBlock((IForgeRegistry<Block>)registry, liquidSoulsand, Material.field_151587_i, Blocks.field_150425_aM.func_176223_P(), LiquidConfigGen.liquid.netherSolidifyTime);
        liquidMagmablock = LiquidRegistry.createGlowyLiquid("liquidmagmablock", 13258246);
        LiquidRegistry.registerFluidBlock((IForgeRegistry<Block>)registry, liquidMagmablock, Material.field_151587_i, Blocks.field_189877_df.func_176223_P(), LiquidConfigGen.liquid.netherSolidifyTime);
        liquidGlowstone = LiquidRegistry.createGlowyLiquid("liquidglowstone", 16372892);
        LiquidRegistry.registerFluidBlock((IForgeRegistry<Block>)registry, liquidGlowstone, Material.field_151587_i, Blocks.field_150426_aN.func_176223_P(), LiquidConfigGen.liquid.netherSolidifyTime);
        liquidSand = LiquidRegistry.createLiquid("liquidsand", 15129006);
        LiquidRegistry.registerFluidBlock((IForgeRegistry<Block>)registry, liquidSand, Material.field_151586_h, Blocks.field_150354_m.func_176223_P(), LiquidConfigGen.liquid.sandSolidifyTime);
        liquidRedsand = LiquidRegistry.createLiquid("liquidredsand", 11820582);
        LiquidRegistry.registerFluidBlock((IForgeRegistry<Block>)registry, liquidRedsand, Material.field_151586_h, Blocks.field_150354_m.func_176223_P().func_177226_a((IProperty)BlockSand.field_176504_a, (Comparable)BlockSand.EnumType.RED_SAND), LiquidConfigGen.liquid.sandSolidifyTime);
        liquidGravel = LiquidRegistry.createLiquid("liquidgravel", 8486783);
        LiquidRegistry.registerFluidBlock((IForgeRegistry<Block>)registry, liquidGravel, Material.field_151586_h, Blocks.field_150351_n.func_176223_P(), LiquidConfigGen.liquid.gravelSolidifyTime);
        liquidOre = LiquidRegistry.createLiquid("liquidore", 0x7F7F7F, 2000);
        LiquidRegistry.registerFluidOreBlock((IForgeRegistry<Block>)registry, liquidOre, Material.field_151587_i, LiquidConfigGen.liquid.stoneSolidifyTime);
        liquidClay = LiquidRegistry.createLiquid("liquidclay", 11120571);
        LiquidRegistry.registerFluidBlock((IForgeRegistry<Block>)registry, liquidClay, Material.field_151586_h, Blocks.field_150435_aG.func_176223_P(), LiquidConfigGen.liquid.claySolidifyTime);
        liquidTerracotta = LiquidRegistry.createLiquid("liquidterracotta", 9656640);
        LiquidRegistry.registerFluidBlock((IForgeRegistry<Block>)registry, liquidTerracotta, Material.field_151587_i, Blocks.field_150405_ch.func_176223_P(), LiquidConfigGen.liquid.terracottaSolidifyTime);
        liquidStainedTerracotta = LiquidRegistry.registerTerracottaLiquid("liquidstainedterracotta", (IForgeRegistry<Block>)registry);
        liquidConcrete = LiquidRegistry.registerConcreteLiquid("liquidconcrete", (IForgeRegistry<Block>)registry);
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        IForgeRegistry registry = event.getRegistry();
        FluidRegistry.addBucketForFluid((Fluid)liquidDirt);
        FluidRegistry.addBucketForFluid((Fluid)liquidCoarseDirt);
        FluidRegistry.addBucketForFluid((Fluid)liquidPodzol);
        FluidRegistry.addBucketForFluid((Fluid)liquidStone);
        FluidRegistry.addBucketForFluid((Fluid)liquidGranite);
        FluidRegistry.addBucketForFluid((Fluid)liquidDiorite);
        FluidRegistry.addBucketForFluid((Fluid)liquidAndesite);
        FluidRegistry.addBucketForFluid((Fluid)liquidSandstone);
        FluidRegistry.addBucketForFluid((Fluid)liquidRedSandstone);
        FluidRegistry.addBucketForFluid((Fluid)liquidNetherrack);
        FluidRegistry.addBucketForFluid((Fluid)liquidSoulsand);
        FluidRegistry.addBucketForFluid((Fluid)liquidMagmablock);
        FluidRegistry.addBucketForFluid((Fluid)liquidGlowstone);
        FluidRegistry.addBucketForFluid((Fluid)liquidSand);
        FluidRegistry.addBucketForFluid((Fluid)liquidRedsand);
        FluidRegistry.addBucketForFluid((Fluid)liquidGravel);
        FluidRegistry.addBucketForFluid((Fluid)liquidOre);
        FluidRegistry.addBucketForFluid((Fluid)liquidClay);
        FluidRegistry.addBucketForFluid((Fluid)liquidTerracotta);
        for (int i = 0; i < EnumDyeColor.values().length; ++i) {
            FluidRegistry.addBucketForFluid((Fluid)liquidStainedTerracotta[i]);
            FluidRegistry.addBucketForFluid((Fluid)liquidConcrete[i]);
        }
    }

    @SubscribeEvent
    public static void registerModels(ModelRegistryEvent event) {
        LiquidBlocks.proxy.registerModels();
    }

    public static LiquidMolten[] registerTerracottaLiquid(String liquidBaseName, IForgeRegistry<Block> registry) {
        LiquidMolten[] liquidTerracottas = new LiquidMolten[EnumDyeColor.values().length];
        for (int i = 0; i < EnumDyeColor.values().length; ++i) {
            EnumDyeColor color = EnumDyeColor.func_176764_b((int)i);
            liquidTerracottas[i] = LiquidRegistry.createLiquid(liquidBaseName + color.func_176762_d().toLowerCase(), LiquidUtil.getColorForTerracotta(color));
            LiquidRegistry.registerFluidBlock(registry, liquidTerracottas[i], Material.field_151587_i, Blocks.field_150406_ce.func_176223_P().func_177226_a((IProperty)BlockStainedHardenedClay.field_176581_a, (Comparable)color), LiquidConfigGen.liquid.terracottaSolidifyTime);
        }
        return liquidTerracottas;
    }

    public static LiquidMolten[] registerConcreteLiquid(String liquidBaseName, IForgeRegistry<Block> registry) {
        LiquidMolten[] liquidConcretes = new LiquidMolten[EnumDyeColor.values().length];
        for (int i = 0; i < EnumDyeColor.values().length; ++i) {
            EnumDyeColor color = EnumDyeColor.func_176764_b((int)i);
            liquidConcretes[i] = LiquidRegistry.createLiquid(liquidBaseName + color.func_176762_d().toLowerCase(), LiquidUtil.getColorForConcrete(color));
            LiquidRegistry.registerFluidBlock(registry, liquidConcretes[i], Material.field_151586_h, Blocks.field_192443_dR.func_176223_P().func_177226_a((IProperty)BlockColored.field_176581_a, (Comparable)color), LiquidConfigGen.liquid.concreteSolidifyTime);
        }
        return liquidConcretes;
    }

    public static LiquidMolten createLiquid(String liquidName, int color, int temperature, int density, int viscosity, int luminosity) {
        String texturePrefix = "liquidblocks:blocks/";
        LiquidMolten theFluid = new LiquidMolten(liquidName, color);
        theFluid.setTemperature(temperature);
        theFluid.setDensity(density);
        theFluid.setViscosity(viscosity);
        theFluid.setLuminosity(luminosity);
        theFluid.setUnlocalizedName("liquidblocks:" + theFluid.getName());
        FluidRegistry.registerFluid((Fluid)theFluid);
        return theFluid;
    }

    public static LiquidMolten createLiquid(String liquidName, int color, int temperature, int density, int viscosity) {
        String texturePrefix = "liquidblocks:blocks/";
        LiquidMolten theFluid = new LiquidMolten(liquidName, color);
        theFluid.setTemperature(temperature);
        theFluid.setDensity(density);
        theFluid.setViscosity(viscosity);
        theFluid.setUnlocalizedName("liquidblocks:" + theFluid.getName());
        FluidRegistry.registerFluid((Fluid)theFluid);
        return theFluid;
    }

    public static LiquidMolten createLiquid(String liquidName, int color, int temperature, int density) {
        String texturePrefix = "liquidblocks:blocks/";
        LiquidMolten theFluid = new LiquidMolten(liquidName, color);
        theFluid.setTemperature(temperature);
        theFluid.setDensity(density);
        theFluid.setUnlocalizedName("liquidblocks:" + theFluid.getName());
        FluidRegistry.registerFluid((Fluid)theFluid);
        return theFluid;
    }

    public static LiquidMolten createLiquid(String liquidName, int color, int temperature) {
        String texturePrefix = "liquidblocks:blocks/";
        LiquidMolten theFluid = new LiquidMolten(liquidName, color);
        theFluid.setTemperature(temperature);
        theFluid.setUnlocalizedName("liquidblocks:" + theFluid.getName());
        FluidRegistry.registerFluid((Fluid)theFluid);
        return theFluid;
    }

    public static LiquidMolten createLiquid(String liquidName, int color) {
        String texturePrefix = "liquidblocks:blocks/";
        LiquidMolten theFluid = new LiquidMolten(liquidName, color);
        theFluid.setUnlocalizedName("liquidblocks:" + theFluid.getName());
        FluidRegistry.registerFluid((Fluid)theFluid);
        return theFluid;
    }

    public static LiquidMolten createGlowyLiquid(String liquidName, int color) {
        String texturePrefix = "liquidblocks:blocks/";
        LiquidMolten theFluid = new LiquidMolten(liquidName, color);
        theFluid.setLuminosity(12);
        theFluid.setUnlocalizedName("liquidblocks:" + theFluid.getName());
        FluidRegistry.registerFluid((Fluid)theFluid);
        return theFluid;
    }

    public static BlockFluidBase registerFluidBlock(IForgeRegistry<Block> registry, Fluid fluid, Material material, IBlockState state, int solidifyTime) {
        return (BlockFluidBase)LiquidRegistry.registerBlock(registry, new BlockLiquidBlock(fluid, material, state, solidifyTime), fluid.getName());
    }

    public static BlockFluidBase registerFluidOreBlock(IForgeRegistry<Block> registry, Fluid fluid, Material material, int solidifyTime) {
        return (BlockFluidBase)LiquidRegistry.registerBlock(registry, new BlockLiquidOre(fluid, material, solidifyTime), fluid.getName());
    }

    protected static <T extends Block> T registerBlock(IForgeRegistry<Block> registry, T block, String name) {
        if (!name.equals(name.toLowerCase(Locale.US))) {
            throw new IllegalArgumentException(String.format("Unlocalized names need to be all lowercase! Block: %s", name));
        }
        String prefixedName = "liquidblocks:" + name;
        block.func_149663_c(prefixedName);
        LiquidRegistry.register(registry, block, name);
        return block;
    }

    protected static <T extends IForgeRegistryEntry<T>> T register(IForgeRegistry<T> registry, T thing, String name) {
        thing.setRegistryName(new ResourceLocation("liquidblocks", name));
        registry.register(thing);
        return thing;
    }

    static {
        LIQUIDS = new ArrayList();
    }
}

