/*
 * Decompiled with CFR 0.152.
 */
package tk.zeitheron.solarflux.api;

import com.google.common.reflect.TypeToken;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.fml.common.FMLContainer;
import net.minecraftforge.fml.common.InjectedModContainer;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.IRegistryDelegate;
import tk.zeitheron.solarflux.api.RegistryDelegate;
import tk.zeitheron.solarflux.api.SolarInstance;
import tk.zeitheron.solarflux.block.BlockBaseSolar;
import tk.zeitheron.solarflux.block.tile.TileBaseSolar;
import tk.zeitheron.solarflux.init.SolarsSF;
import tk.zeitheron.solarflux.shaded.hammerlib.cfg.ConfigEntryCategory;

public class SolarInfo
implements Consumer<SolarInstance>,
IForgeRegistryEntry<SolarInfo> {
    public List<Supplier<IRecipe>> recipes = new ArrayList<Supplier<IRecipe>>();
    public String compatMod;
    public long baseGeneration;
    public long baseTransfer;
    public long baseCapacity;
    public float baseHeight = 0.375f;
    public boolean baseConnectTextures = true;
    public boolean isCustom = false;
    public Map<String, String> localizations = null;
    public SolarConfigInstance configInstance;
    private BlockBaseSolar block;
    protected ResourceLocation tex;
    private TypeToken<SolarInfo> token = new TypeToken<SolarInfo>(this.getClass()){};
    public final IRegistryDelegate<SolarInfo> delegate = new RegistryDelegate<SolarInfo>(this, this.token.getRawType());
    private ResourceLocation registryName = null;

    public SolarInfo(long mgen, long mtranf, long mcap) {
        this.baseGeneration = mgen;
        this.baseTransfer = mtranf;
        this.baseCapacity = mcap;
    }

    public SolarInfo(long mgen, long mtranf, long mcap, float height) {
        this.baseGeneration = mgen;
        this.baseTransfer = mtranf;
        this.baseCapacity = mcap;
        this.baseHeight = height;
    }

    public SolarInfo noConnectTexture() {
        this.baseConnectTextures = false;
        return this;
    }

    protected BlockBaseSolar createBlock() {
        return new BlockBaseSolar(this);
    }

    public BlockBaseSolar getBlock() {
        if (this.block == null) {
            this.block = this.createBlock();
        }
        return this.block;
    }

    public ResourceLocation getTexture() {
        if (this.tex != null) {
            return this.tex;
        }
        this.tex = new ResourceLocation(this.getRegistryName().func_110624_b(), "blocks/solar_topf_" + this.getRegistryName().func_110623_a());
        return this.tex;
    }

    @Override
    public void accept(SolarInstance t) {
        SolarConfigInstance data = this.getConfigInstance();
        t.gen = data.generation;
        t.cap = data.capacity;
        t.transfer = data.transfer;
        t.infoDelegate = this;
        t.delegate = this.getRegistryName();
    }

    public SolarInfo setCompatMod(String compatMod) {
        this.compatMod = compatMod;
        return this;
    }

    public String getCompatMod() {
        return this.compatMod;
    }

    public float getHeight() {
        return this.getConfigInstance().height;
    }

    public long getGeneration() {
        return this.getConfigInstance().generation;
    }

    public long getTransfer() {
        return this.getConfigInstance().transfer;
    }

    public long getCapacity() {
        return this.getConfigInstance().capacity;
    }

    public void configureBase(ConfigEntryCategory cat) {
        this.configInstance = new SolarConfigInstance(cat, this);
    }

    public void resetConfigInstance() {
        this.configInstance = new SolarConfigInstance(this);
    }

    public SolarConfigInstance getConfigInstance() {
        if (this.configInstance == null) {
            this.resetConfigInstance();
        }
        return this.configInstance;
    }

    public float computeSunIntensity(TileBaseSolar solar) {
        if (!solar.doesSeeSky()) {
            return 0.0f;
        }
        float celestialAngleRadians = solar.func_145831_w().func_72929_e(1.0f);
        if ((double)celestialAngleRadians > Math.PI) {
            celestialAngleRadians = (float)(Math.PI * 2 - (double)celestialAngleRadians);
        }
        boolean lowLightCount = false;
        float multiplicator = 1.5f - (float)lowLightCount * 0.122f;
        float displacement = 1.2f + (float)lowLightCount * 0.08f;
        return MathHelper.func_76131_a((float)(multiplicator * MathHelper.func_76134_b((float)(celestialAngleRadians / displacement))), (float)0.0f, (float)1.0f);
    }

    public final SolarInfo setRegistryName(String name) {
        if (this.getRegistryName() != null) {
            throw new IllegalStateException("Attempted to set registry name with existing registry name! New: " + name + " Old: " + this.getRegistryName());
        }
        this.registryName = SolarInfo.checkPrefix(name);
        return this;
    }

    public static ResourceLocation checkPrefix(String name) {
        String prefix;
        int index = name.lastIndexOf(58);
        String oldPrefix = index == -1 ? "" : name.substring(0, index).toLowerCase(Locale.ROOT);
        name = index == -1 ? name : name.substring(index + 1);
        ModContainer mc = Loader.instance().activeModContainer();
        String string = prefix = mc == null || mc instanceof InjectedModContainer && ((InjectedModContainer)mc).wrappedContainer instanceof FMLContainer ? "solarflux" : mc.getModId().toLowerCase(Locale.ROOT);
        if (!oldPrefix.equals(prefix) && oldPrefix.length() > 0) {
            prefix = oldPrefix;
        }
        return new ResourceLocation(prefix, name);
    }

    public final SolarInfo setRegistryName(ResourceLocation name) {
        return this.setRegistryName(name.toString());
    }

    public final SolarInfo setRegistryName(String modID, String name) {
        return this.setRegistryName(modID + ":" + name);
    }

    @Nullable
    public final ResourceLocation getRegistryName() {
        if (this.delegate.name() != null) {
            return this.delegate.name();
        }
        return this.registryName != null ? this.registryName : null;
    }

    public final Class<SolarInfo> getRegistryType() {
        return SolarInfo.class;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder customBuilder() {
        Builder b = new Builder();
        b.custom = true;
        return b;
    }

    public LanguageData langBuilder() {
        return new LanguageData(this);
    }

    public RecipeBuilder recipeBuilder() {
        return new RecipeBuilder(this);
    }

    public boolean hasConnectedTextures() {
        return this.getConfigInstance().connectTextures;
    }

    public static class SolarConfigInstance {
        public final long generation;
        public final long capacity;
        public final long transfer;
        public final float height;
        public final boolean connectTextures;

        public SolarConfigInstance(ConfigEntryCategory cat, SolarInfo base) {
            this.generation = cat.getLongEntry("Generation Rate", base.baseGeneration, 1L, Long.MAX_VALUE).setDescription("How many RF/FE does this solar panel produce per tick?").getValue();
            this.transfer = cat.getLongEntry("Transfer Rate", base.baseTransfer, 1L, Long.MAX_VALUE).setDescription("How many RF/FE does this solar panel emit to other blocks, per tick?").getValue();
            this.capacity = cat.getLongEntry("Capacity", base.baseCapacity, 1L, Long.MAX_VALUE).setDescription("How many RF/FE does this solar panel store?").getValue();
            this.connectTextures = cat.getBooleanEntry("Connected Texture", base.baseConnectTextures).setDescription("Does this solar panel connect textures with other panels of this type?").getValue();
            this.height = cat.getFloatEntry("Height", base.baseHeight * 16.0f, 0.0f, 16.0f).setDescription("How high is this solar panel?").getValue().floatValue() / 16.0f;
        }

        public SolarConfigInstance(SolarInfo base) {
            this.generation = base.baseGeneration;
            this.capacity = base.baseCapacity;
            this.transfer = base.baseTransfer;
            this.height = base.baseHeight;
            this.connectTextures = base.baseConnectTextures;
        }

        public SolarConfigInstance(long generation, long capacity, long transfer, float height, boolean connectTextures) {
            this.generation = generation;
            this.capacity = capacity;
            this.transfer = transfer;
            this.height = height;
            this.connectTextures = connectTextures;
        }

        public NBTTagCompound serialize() {
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74772_a("MG", this.generation);
            nbt.func_74772_a("MC", this.capacity);
            nbt.func_74772_a("MT", this.transfer);
            nbt.func_74776_a("SH", this.height);
            nbt.func_74757_a("CT", this.connectTextures);
            return nbt;
        }
    }

    public static class RecipeBuilder {
        final SolarInfo panel;
        List<Object> args = new ArrayList<Object>();

        public RecipeBuilder(SolarInfo panel) {
            this.panel = panel;
        }

        public RecipeBuilder shape(String ... strings) {
            this.args.addAll(Arrays.asList(strings));
            return this;
        }

        public RecipeBuilder bind(String ch, Object output) {
            if (ch.length() != 1) {
                throw new IllegalArgumentException(ch + " is not a single character!");
            }
            this.args.add(Character.valueOf(ch.charAt(0)));
            this.args.add(output);
            return this;
        }

        public SolarInfo build() {
            return this.build(1);
        }

        public SolarInfo build(int amount) {
            this.panel.recipes.add(() -> {
                Object[] objs = this.args.toArray(new Object[this.args.size()]);
                for (int i = 0; i < objs.length; ++i) {
                    Object j = objs[i];
                    if (!(j instanceof Supplier)) continue;
                    objs[i] = ((Supplier)j).get();
                }
                return new ShapedOreRecipe(new ResourceLocation("solarflux"), new ItemStack((Block)this.panel.getBlock(), amount), objs);
            });
            return this.panel;
        }
    }

    public static class LanguageData {
        public final Map<String, String> langToName = new HashMap<String, String>();
        public String def;
        final SolarInfo panel;

        public LanguageData(SolarInfo panel) {
            this.panel = panel;
        }

        public LanguageData put(String lang, String loc) {
            if ((lang = lang.toLowerCase()).equals("en_us")) {
                this.def = loc;
            }
            this.langToName.put(lang, loc);
            return this;
        }

        public String getName(String lang) {
            return this.langToName.getOrDefault(lang, this.def);
        }

        public SolarInfo build() {
            if (this.def == null) {
                throw new RuntimeException("Unable to apply languages: no 'en_us' value found!");
            }
            this.panel.localizations = this.langToName;
            return this.panel;
        }
    }

    public static class Builder {
        String name;
        Long generation;
        Long capacity;
        Long transfer;
        float height = 0.375f;
        boolean custom = false;

        public Builder name(String s) {
            this.name = s;
            return this;
        }

        public Builder height(float f) {
            this.height = f;
            return this;
        }

        public Builder generation(Number n) {
            if (n instanceof Long) {
                this.generation = (Long)n;
                return this;
            }
            return this.generation(Long.toString(n.longValue()));
        }

        public Builder generation(String s) {
            this.generation = new Long(s);
            return this;
        }

        public Builder capacity(Number n) {
            if (n instanceof Long) {
                this.capacity = (Long)n;
                return this;
            }
            return this.capacity(Long.toString(n.longValue()));
        }

        public Builder capacity(String s) {
            this.capacity = new Long(s);
            return this;
        }

        public Builder transfer(Number n) {
            if (n instanceof Long) {
                this.transfer = (Long)n;
                return this;
            }
            return this.transfer(Long.toString(n.longValue()));
        }

        public Builder transfer(String s) {
            this.transfer = new Long(s);
            return this;
        }

        public SolarInfo build() {
            if (this.name == null) {
                throw new NullPointerException("name == null");
            }
            if (this.generation == null) {
                throw new NullPointerException("generation == null");
            }
            if (this.capacity == null) {
                throw new NullPointerException("capacity == null");
            }
            if (this.transfer == null) {
                throw new NullPointerException("transfer == null");
            }
            SolarInfo info = new SolarInfo(this.generation, this.transfer, this.capacity);
            info.isCustom = this.custom;
            info.setRegistryName(this.name);
            info.baseHeight = this.height;
            return info;
        }

        public SolarInfo buildAndRegister() {
            SolarInfo info = this.build();
            SolarsSF.modSolars.add(info);
            return info;
        }
    }
}

