/*
 * Decompiled with CFR 0.152.
 */
package tk.zeitheron.solarflux.gui;

import java.util.Arrays;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import tk.zeitheron.solarflux.block.tile.TileBaseSolar;
import tk.zeitheron.solarflux.gui.SlotChargable;
import tk.zeitheron.solarflux.gui.SlotUpgrade;
import tk.zeitheron.solarflux.net.ExpandedContainerListener;

public class ContainerBaseSolar
extends Container {
    public final TileBaseSolar tile;
    public final long[] prev;
    public ExpandedContainerListener networking;
    boolean fsync;

    public ContainerBaseSolar(TileBaseSolar tile, InventoryPlayer playerInv) {
        this.tile = tile;
        this.prev = new long[tile.getVarCount()];
        this.addPlayerInventorySlotsToContainer(playerInv, 8, 98);
        this.addPlayerActionSlotsToContainer(playerInv, 8, 156);
        for (int i = 0; i < tile.upgradeInventory.func_70302_i_(); ++i) {
            this.func_75146_a(new SlotUpgrade(tile, i, i * 18 + 9, 61));
        }
        this.func_75146_a(new SlotChargable(tile.chargeInventory, 0, 151, 9));
        if (playerInv.field_70458_d instanceof EntityPlayerMP) {
            this.networking = new ExpandedContainerListener((EntityPlayerMP)playerInv.field_70458_d);
        }
        Arrays.fill(this.prev, -1L);
    }

    public void func_75142_b() {
        int j;
        super.func_75142_b();
        if (!this.fsync) {
            this.fsync = true;
            if (this.networking != null) {
                for (j = 0; j < this.tile.getVarCount(); ++j) {
                    this.networking.sendWindowProperty2(this, j, this.tile.getVar(j));
                    this.prev[j] = this.tile.getVar(j);
                }
            }
        }
        if (this.networking != null) {
            for (j = 0; j < this.tile.getVarCount(); ++j) {
                if (this.prev[j] == this.tile.getVar(j)) continue;
                this.networking.sendWindowProperty2(this, j, this.tile.getVar(j));
                this.prev[j] = this.tile.getVar(j);
            }
        }
    }

    public void func_75137_b(int id, int data) {
        this.tile.setVar(id, data);
    }

    public void updateProgressBar2(int id, long data) {
        this.prev[id] = data;
        this.tile.setVar(id, data);
    }

    protected void addPlayerInventorySlotsToContainer(InventoryPlayer pInventoryPlayer, int pLeft, int pTop) {
        for (int inventoryRowIndex = 0; inventoryRowIndex < 3; ++inventoryRowIndex) {
            for (int inventoryColumnIndex = 0; inventoryColumnIndex < 9; ++inventoryColumnIndex) {
                this.func_75146_a(new Slot((IInventory)pInventoryPlayer, inventoryColumnIndex + inventoryRowIndex * 9 + 9, pLeft + inventoryColumnIndex * 18, pTop + inventoryRowIndex * 18));
            }
        }
    }

    protected void addPlayerActionSlotsToContainer(InventoryPlayer player, int x, int y) {
        for (int i = 0; i < 9; ++i) {
            this.func_75146_a(new Slot((IInventory)player, i, x + i * 18, y));
        }
    }

    public boolean func_75145_c(EntityPlayer playerIn) {
        return this.tile.upgradeInventory.isUsableByPlayer(playerIn, this.tile.func_174877_v());
    }

    public ItemStack func_82846_b(EntityPlayer playerIn, int index) {
        return ItemStack.field_190927_a;
    }
}

