/*
 * Decompiled with CFR 0.152.
 */
package tk.zeitheron.solarflux.shaded.hammerlib.cfg;

import java.util.Objects;
import tk.zeitheron.solarflux.shaded.hammerlib.cfg.ConfigEntrySerializer;
import tk.zeitheron.solarflux.shaded.hammerlib.cfg.Configuration;
import tk.zeitheron.solarflux.shaded.hammerlib.cfg.IConfigEntry;

public class ConfigEntryInt
implements IConfigEntry {
    final Configuration cfg;
    public int min = Integer.MIN_VALUE;
    public int max = Integer.MAX_VALUE;
    String description;
    String name;
    Integer value;
    Integer initialValue;

    public ConfigEntryInt(Configuration cfg, Integer initialValue) {
        this.value = initialValue;
        this.initialValue = initialValue;
        this.cfg = cfg;
    }

    public ConfigEntryInt setDescription(String description) {
        this.description = description;
        return this;
    }

    public ConfigEntryInt setMinValue(int min) {
        this.min = min;
        if (this.value != null) {
            this.value = Math.max(min, Math.min(this.max, this.value));
        }
        return this;
    }

    public ConfigEntryInt setMaxValue(int max) {
        this.max = max;
        if (this.value != null) {
            this.value = Math.max(this.min, Math.min(max, this.value));
        }
        return this;
    }

    public ConfigEntryInt setName(String name) {
        if (!Objects.equals(name, this.name)) {
            this.name = name;
            this.cfg.markChanged();
        }
        return this;
    }

    public ConfigEntryInt setValue(Integer value) {
        if (value != null) {
            value = Math.max(this.min, Math.min(this.max, value));
        }
        if (!Objects.equals(value, this.value)) {
            this.value = value;
            this.cfg.markChanged();
        }
        return this;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public Integer getValue() {
        if (this.value == null) {
            this.setValue(this.initialValue);
        }
        return this.value;
    }

    @Override
    public ConfigEntrySerializer<?> getSerializer() {
        return Configuration.SERIALIZER_INT;
    }
}

