/*
 * Decompiled with CFR 0.152.
 */
package tk.zeitheron.solarflux.shaded.hammerlib.cfg;

import java.util.Arrays;
import java.util.Objects;
import tk.zeitheron.solarflux.shaded.hammerlib.cfg.ConfigEntrySerializer;
import tk.zeitheron.solarflux.shaded.hammerlib.cfg.Configuration;
import tk.zeitheron.solarflux.shaded.hammerlib.cfg.IConfigEntry;

public class ConfigEntryStringArray
implements IConfigEntry {
    final Configuration cfg;
    String description;
    String name;
    String[] value;
    String[] initialValue;

    public ConfigEntryStringArray(Configuration cfg, String[] initialValue) {
        this.value = initialValue;
        this.initialValue = initialValue;
        this.cfg = cfg;
    }

    public ConfigEntryStringArray setDescription(String description) {
        this.description = description;
        return this;
    }

    public ConfigEntryStringArray setName(String name) {
        if (!Objects.equals(name, this.name)) {
            this.name = name;
            this.cfg.markChanged();
        }
        return this;
    }

    public ConfigEntryStringArray setValue(String[] value) {
        if (!Arrays.equals(value, this.value)) {
            this.value = value;
            this.cfg.markChanged();
        }
        return this;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String[] getValue() {
        if (this.value == null) {
            this.setValue(this.initialValue);
        }
        return this.value;
    }

    @Override
    public ConfigEntrySerializer<?> getSerializer() {
        return Configuration.SERIALIZER_STRING_ARRAY;
    }
}

