/*
 * Decompiled with CFR 0.152.
 */
package dev.necauqua.mods.cleanse;

import com.google.common.collect.ForwardingList;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ChatLine;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiMainMenu;
import net.minecraft.client.gui.GuiMultiplayer;
import net.minecraft.client.gui.GuiNewChat;
import net.minecraft.client.gui.GuiUtilRenderComponents;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.translation.LanguageMap;
import net.minecraftforge.client.event.ClientChatReceivedEvent;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLModDisabledEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="cleanse", clientSideOnly=true, useMetadata=true, updateJSON="https://raw.githubusercontent.com/wiki/necauqua/cleanse/updates.json")
@Mod.EventBusSubscriber(value={Side.CLIENT})
public final class Cleanse {
    public static final String ID = "cleanse";
    private static final Logger logger = LogManager.getLogger((String)"Cleanse");
    private static final Set<String> vanillaKeys = new HashSet<String>();
    private static boolean enabled = true;
    private static int timeout = 20;
    private static int timer = 0;
    private static boolean checkWorldEnter = true;
    private static List<ChatLine> originalChatLines;
    private static List<ChatLine> originalDrawnChatLines;
    private static TheGreatFilter filteredChatLines;
    private static TheGreatFilter filteredDrawnChatLines;
    private static Configuration config;

    @Mod.EventHandler
    public static void on(FMLPreInitializationEvent e) {
        config = new Configuration(e.getSuggestedConfigurationFile());
        config.load();
        Cleanse.loadConfig();
        Cleanse.loadVanillaKeys();
    }

    private static void loadConfig() {
        timeout = config.getInt("timeout", "main", timeout, 1, 1200, "Time in ticks that determines the duration of the chat suppression after you enter a world");
        if (config.hasChanged()) {
            config.save();
        }
    }

    private static void loadVanillaKeys() {
        vanillaKeys.addAll(Cleanse.loadKeys("/assets/minecraft/lang/en_us.lang"));
        vanillaKeys.addAll(Cleanse.loadKeys("/assets/realms/lang/en_us.lang"));
        vanillaKeys.addAll(Cleanse.loadKeys("/assets/forge/lang/en_US.lang"));
    }

    @SubscribeEvent
    public static void on(ConfigChangedEvent.OnConfigChangedEvent e) {
        if (ID.equals(e.getModID())) {
            Cleanse.loadConfig();
        }
    }

    @Mod.EventHandler
    public static void on(FMLModDisabledEvent e) {
        enabled = false;
        logger.info("The mod was disabled from the modlist");
        if (timer != 0) {
            logger.info("Disabled the timer to reenable adding new chat lines, was {} ticks left", (Object)timer);
            timer = 0;
        }
        Minecraft mc = Minecraft.func_71410_x();
        GuiNewChat chat = mc.field_71456_v.func_146158_b();
        Cleanse.sanityCheck(chat);
        chat.field_146252_h = originalChatLines;
        chat.field_146253_i = originalDrawnChatLines;
    }

    private static Set<String> loadKeys(String path) {
        InputStream is = Cleanse.class.getResourceAsStream(path);
        return is != null ? LanguageMap.parseLangFile((InputStream)is).keySet() : Collections.emptySet();
    }

    private static boolean isVanilla(ITextComponent text) {
        return text instanceof TextComponentTranslation && vanillaKeys.contains(((TextComponentTranslation)text).func_150268_i());
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void on(GuiOpenEvent e) {
        if (!enabled) {
            return;
        }
        if (e.getGui() == null && checkWorldEnter) {
            checkWorldEnter = false;
            timer = timeout;
            logger.info("Started the timer to reenable adding new chat lines, waiting for {} ticks", (Object)timeout);
        } else if (e.getGui() instanceof GuiMainMenu || e.getGui() instanceof GuiMultiplayer) {
            GuiNewChat chat = Minecraft.func_71410_x().field_71456_v.func_146158_b();
            if (filteredChatLines == null) {
                originalChatLines = chat.field_146252_h;
                filteredChatLines = new TheGreatFilter(originalChatLines, false);
                originalDrawnChatLines = chat.field_146253_i;
                filteredDrawnChatLines = new TheGreatFilter(originalDrawnChatLines, true);
            }
            checkWorldEnter = true;
            if (timer != 0) {
                logger.info("Disabled the timer to reenable adding new chat lines, was {} ticks left", (Object)timer);
                timer = 0;
                return;
            }
            if (chat.field_146252_h == filteredChatLines && chat.field_146253_i == filteredDrawnChatLines) {
                return;
            }
            Cleanse.sanityCheck(chat);
            chat.field_146252_h = filteredChatLines;
            chat.field_146253_i = filteredDrawnChatLines;
            logger.info("Disabled adding new chat lines");
        }
    }

    @SubscribeEvent
    public static void on(TickEvent.ClientTickEvent e) {
        if (e.phase != TickEvent.Phase.END || timer == 0 || --timer != 0) {
            return;
        }
        GuiNewChat chat = Minecraft.func_71410_x().field_71456_v.func_146158_b();
        Cleanse.sanityCheck(chat);
        chat.field_146252_h = originalChatLines;
        chat.field_146253_i = originalDrawnChatLines;
        logger.info("Reenabled adding new chat lines");
    }

    private static void sanityCheck(GuiNewChat chat) {
        if (chat.field_146252_h != originalChatLines && chat.field_146252_h != filteredChatLines) {
            logger.error("SOME OTHER MOD DID THE SAME DIRTY HACK WE DID, THE `chatLines` FIELD WAS REPLACED WITH SOMETHING ELSE, THIS WILL BREAK THEIR THINGS");
        }
        if (chat.field_146253_i != originalDrawnChatLines && chat.field_146253_i != filteredDrawnChatLines) {
            logger.error("SOME OTHER MOD DID THE SAME DIRTY HACK WE DID, THE `drawnChatLines` FIELD WAS REPLACED WITH SOMETHING ELSE, THIS WILL BREAK THEIR THINGS");
        }
    }

    @SubscribeEvent
    public static void on(ClientChatReceivedEvent e) {
        if (!enabled || !Cleanse.isVanilla(e.getMessage())) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        GuiNewChat chat = mc.field_71456_v.func_146158_b();
        int i = MathHelper.func_76141_d((float)((float)chat.func_146228_f() / chat.func_146244_h()));
        filteredChatLines.allowedLines = (filteredDrawnChatLines.allowedLines = GuiUtilRenderComponents.func_178908_a((ITextComponent)e.getMessage(), (int)i, (FontRenderer)mc.field_71466_p, (boolean)false, (boolean)false));
    }

    private static final class TheGreatFilter
    extends ForwardingList<ChatLine> {
        private final List<ChatLine> list;
        private final boolean split;
        private List<ITextComponent> allowedLines = Collections.emptyList();

        public TheGreatFilter(List<ChatLine> list, boolean split) {
            this.list = list;
            this.split = split;
        }

        public void add(int index, ChatLine element) {
            ITextComponent text = element.func_151461_a();
            if (!this.split) {
                if (Cleanse.isVanilla(text)) {
                    super.add(index, (Object)element);
                }
            } else if (!this.allowedLines.isEmpty() && text.func_150254_d().equals(this.allowedLines.get(0).func_150254_d())) {
                this.allowedLines.remove(0);
                super.add(index, (Object)element);
            }
        }

        protected List<ChatLine> delegate() {
            return this.list;
        }
    }
}

