/*
 * Decompiled with CFR 0.152.
 */
package com.agricraft.agricore.registry;

import com.agricraft.agricore.plant.AgriMutation;
import com.agricraft.agricore.registry.AgriLoadableRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class AgriMutations
implements AgriLoadableRegistry<AgriMutation> {
    private final Set<AgriMutation> mutations = new HashSet<AgriMutation>();

    public boolean hasMutation(AgriMutation mutation) {
        return this.mutations.contains(mutation);
    }

    public boolean hasMutation(String child) {
        for (AgriMutation m : this.mutations) {
            if (!m.isChild(child)) continue;
            return true;
        }
        return false;
    }

    public boolean hasMutation(String parent1, String parent2) {
        for (AgriMutation m : this.mutations) {
            if (!m.isParent(parent1) || !m.isParent(parent2)) continue;
            return true;
        }
        return false;
    }

    public boolean addMutation(AgriMutation mutation) {
        return this.mutations.add(mutation);
    }

    public List<AgriMutation> getMutation(String child) {
        ArrayList<AgriMutation> results = new ArrayList<AgriMutation>();
        this.mutations.forEach(m -> {
            if (m.isChild(child)) {
                results.add((AgriMutation)m);
            }
        });
        return results;
    }

    public List<AgriMutation> getMutation(String parent1, String parent2) {
        ArrayList<AgriMutation> results = new ArrayList<AgriMutation>();
        for (AgriMutation m : this.mutations) {
            if (!m.isParent(parent1) || !m.isParent(parent2)) continue;
            results.add(m);
        }
        return results;
    }

    public Collection<AgriMutation> getAll() {
        return Collections.unmodifiableCollection(this.mutations);
    }

    public void validate() {
        this.mutations.removeIf(e -> !e.validate());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("\nMutations:");
        for (AgriMutation mutation : this.mutations) {
            sb.append("\n\t- ").append(mutation).append("\n\t");
        }
        return sb.append("\n").toString();
    }

    @Override
    public boolean acceptsElement(String filename) {
        return filename.toLowerCase().endsWith("_mutation.json");
    }

    @Override
    public Class<AgriMutation> getElementClass() {
        return AgriMutation.class;
    }

    @Override
    public void registerElement(AgriMutation element) {
        this.addMutation(element);
    }

    @Override
    public void clearElements() {
        this.mutations.clear();
    }

    public int hashCode() {
        return this.mutations.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AgriMutations other = (AgriMutations)obj;
        return this.mutations.equals(other.mutations);
    }
}

