/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.api.v1.requirement;

import com.google.common.base.Preconditions;
import com.infinityraider.agricraft.api.v1.requirement.ICondition;
import com.infinityraider.agricraft.api.v1.util.BlockRange;
import com.infinityraider.agricraft.api.v1.util.FuzzyStack;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;

public class BlockCondition
implements ICondition {
    @Nonnull
    private final BlockRange range;
    @Nonnull
    private final FuzzyStack stack;
    private final int amount;
    private final int volume;

    public BlockCondition(@Nonnull FuzzyStack stack, @Nonnull BlockRange range) {
        this.stack = (FuzzyStack)Preconditions.checkNotNull((Object)stack);
        this.range = (BlockRange)Preconditions.checkNotNull((Object)range);
        this.amount = stack.toStack().func_190916_E();
        this.volume = range.getVolume();
        if (this.amount < 1) {
            throw new IndexOutOfBoundsException("The required amount of blocks must be greater than zero!");
        }
        if (this.amount > this.volume) {
            throw new IndexOutOfBoundsException("Required amount of blocks exceeds volume of range!");
        }
    }

    @Nonnull
    public FuzzyStack getStack() {
        return this.stack;
    }

    @Nonnull
    public BlockRange getRange() {
        return this.range;
    }

    @Override
    public boolean isMet(@Nonnull IBlockAccess world, @Nonnull BlockPos pos) {
        Preconditions.checkNotNull((Object)world);
        Preconditions.checkNotNull((Object)pos);
        return new BlockRange(this.range, pos).stream().map(arg_0 -> ((IBlockAccess)world).func_180495_p(arg_0)).map(FuzzyStack::from).map(o -> o.orElse(null)).filter(this.stack::equals).skip(this.amount - 1).findAny().isPresent();
    }

    @Override
    public void addDescription(@Nonnull Consumer<String> consumer) {
        Preconditions.checkNotNull(consumer);
        consumer.accept("Required Blocks");
    }

    @Override
    public int getComplexity() {
        return this.volume;
    }
}

