/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.api.v1.seed;

import com.google.common.base.Preconditions;
import com.infinityraider.agricraft.api.v1.plant.IAgriPlant;
import com.infinityraider.agricraft.api.v1.stat.IAgriStat;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public final class AgriSeed {
    @Nonnull
    private final IAgriPlant plant;
    @Nonnull
    private final IAgriStat stat;

    public AgriSeed(@Nonnull IAgriPlant plant, @Nonnull IAgriStat stat) {
        this.plant = (IAgriPlant)Preconditions.checkNotNull((Object)plant, (Object)"The plant in an AgriSeed may not be null!");
        this.stat = (IAgriStat)Preconditions.checkNotNull((Object)stat, (Object)"The stat in an AgriSeed may not be null!");
    }

    @Nonnull
    public IAgriPlant getPlant() {
        return this.plant;
    }

    @Nonnull
    public IAgriStat getStat() {
        return this.stat;
    }

    @Nonnull
    public AgriSeed withPlant(@Nonnull IAgriPlant plant) {
        return new AgriSeed(plant, this.stat);
    }

    @Nonnull
    public AgriSeed withStat(@Nonnull IAgriStat stat) {
        return new AgriSeed(this.plant, stat);
    }

    @Nonnull
    public ItemStack toStack() {
        return this.toStack(1);
    }

    @Nonnull
    public ItemStack toStack(int size) {
        ItemStack stack = (ItemStack)Preconditions.checkNotNull((Object)this.plant.getSeed());
        NBTTagCompound tag = Optional.ofNullable(stack.func_77978_p()).map(NBTTagCompound::func_74737_b).orElseGet(NBTTagCompound::new);
        this.stat.writeToNBT(tag);
        ItemStack ret = new ItemStack(stack.func_77973_b(), size, stack.func_77960_j());
        ret.func_77982_d(tag);
        return ret;
    }

    public final boolean equals(Object obj) {
        return obj instanceof AgriSeed && this.equals((AgriSeed)obj);
    }

    public final boolean equals(AgriSeed other) {
        return other != null && this.plant.equals(other.plant) && this.stat.equals(other.stat);
    }

    public int hashCode() {
        int hash = 3;
        hash = 71 * hash + Objects.hashCode(this.plant);
        hash = 71 * hash + Objects.hashCode(this.stat);
        return hash;
    }
}

