/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.renderers.blocks;

import com.infinityraider.agricraft.api.v1.util.AgriSideMetaMatrix;
import com.infinityraider.agricraft.blocks.irrigation.AbstractBlockWaterChannel;
import com.infinityraider.agricraft.renderers.blocks.RenderBlockCustomWood;
import com.infinityraider.agricraft.tiles.irrigation.TileEntityChannel;
import com.infinityraider.agricraft.utility.BaseIcons;
import com.infinityraider.infinitylib.render.RenderUtilBase;
import com.infinityraider.infinitylib.render.tessellation.ITessellator;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class RenderChannel<B extends AbstractBlockWaterChannel<T>, T extends TileEntityChannel>
extends RenderBlockCustomWood<B, T> {
    public RenderChannel(B block, T channel) {
        super(block, channel, true, true, true);
    }

    protected void renderWoodChannel(ITessellator tessellator, IBlockState state, TextureAtlasSprite icon) {
        AgriSideMetaMatrix connections = new AgriSideMetaMatrix();
        connections.readFromBlockState(state);
        this.renderBottom(tessellator, icon);
        for (EnumFacing side : EnumFacing.field_176754_o) {
            this.renderSide(tessellator, state, side, connections.get(side), icon);
        }
    }

    protected void renderBottom(ITessellator tessellator, TextureAtlasSprite matIcon) {
        tessellator.drawScaledPrism(4.0f, 4.0f, 4.0f, 12.0f, 5.0f, 12.0f, matIcon);
        tessellator.drawScaledPrism(4.0f, 5.0f, 4.0f, 5.0f, 12.0f, 5.0f, matIcon);
        tessellator.drawScaledPrism(11.0f, 5.0f, 4.0f, 12.0f, 12.0f, 5.0f, matIcon);
        tessellator.drawScaledPrism(4.0f, 5.0f, 11.0f, 5.0f, 12.0f, 12.0f, matIcon);
        tessellator.drawScaledPrism(11.0f, 5.0f, 11.0f, 12.0f, 12.0f, 12.0f, matIcon);
    }

    protected void renderSide(ITessellator tessellator, IBlockState state, EnumFacing dir, byte type, TextureAtlasSprite matIcon) {
        switch (dir) {
            case EAST: {
                if (type > 0) {
                    tessellator.drawScaledPrism(12.0f, 4.0f, 4.0f, 16.0f, 5.0f, 12.0f, matIcon);
                    tessellator.drawScaledPrism(12.0f, 5.0f, 4.0f, 16.0f, 12.0f, 5.0f, matIcon);
                    tessellator.drawScaledPrism(12.0f, 5.0f, 11.0f, 16.0f, 12.0f, 12.0f, matIcon);
                    break;
                }
                if (type != 0) break;
                tessellator.drawScaledPrism(11.0f, 5.0f, 5.0f, 12.0f, 12.0f, 11.0f, matIcon);
                break;
            }
            case WEST: {
                if (type > 0) {
                    tessellator.drawScaledPrism(0.0f, 4.0f, 4.0f, 4.0f, 5.0f, 12.0f, matIcon);
                    tessellator.drawScaledPrism(0.0f, 5.0f, 4.0f, 4.0f, 12.0f, 5.0f, matIcon);
                    tessellator.drawScaledPrism(0.0f, 5.0f, 11.0f, 4.0f, 12.0f, 12.0f, matIcon);
                    break;
                }
                if (type != 0) break;
                tessellator.drawScaledPrism(4.0f, 5.0f, 5.0f, 5.0f, 12.0f, 11.0f, matIcon);
                break;
            }
            case NORTH: {
                if (type > 0) {
                    tessellator.drawScaledPrism(4.0f, 4.0f, 0.0f, 12.0f, 5.0f, 4.0f, matIcon);
                    tessellator.drawScaledPrism(4.0f, 5.0f, 0.0f, 5.0f, 12.0f, 4.0f, matIcon);
                    tessellator.drawScaledPrism(11.0f, 5.0f, 0.0f, 12.0f, 12.0f, 4.0f, matIcon);
                    break;
                }
                if (type != 0) break;
                tessellator.drawScaledPrism(5.0f, 5.0f, 4.0f, 11.0f, 12.0f, 5.0f, matIcon);
                break;
            }
            case SOUTH: {
                if (type > 0) {
                    tessellator.drawScaledPrism(4.0f, 4.0f, 12.0f, 12.0f, 5.0f, 16.0f, matIcon);
                    tessellator.drawScaledPrism(4.0f, 5.0f, 12.0f, 5.0f, 12.0f, 16.0f, matIcon);
                    tessellator.drawScaledPrism(11.0f, 5.0f, 12.0f, 12.0f, 12.0f, 16.0f, matIcon);
                    break;
                }
                if (type != 0) break;
                tessellator.drawScaledPrism(5.0f, 5.0f, 11.0f, 11.0f, 12.0f, 12.0f, matIcon);
            }
        }
    }

    protected void drawWater(ITessellator tessellator, T channel, TextureAtlasSprite icon) {
        if (((TileEntityChannel)channel).getFluidHeight() <= ((TileEntityChannel)channel).getMinFluidHeight()) {
            return;
        }
        int l = RenderUtilBase.getMixedBrightness((World)channel.func_145831_w(), (BlockPos)channel.func_174877_v(), (Block)Blocks.field_150355_j);
        tessellator.setBrightness(l);
        tessellator.setAlpha(0.39f);
        float y = (float)(((TileEntityChannel)channel).getFluidHeight() * 16) / 1000.0f - 0.001f;
        tessellator.drawScaledFaceDouble(5.0f, 5.0f, 11.0f, 11.0f, EnumFacing.UP, icon, y);
        AgriSideMetaMatrix connections = ((TileEntityChannel)channel).getConnections();
        if (connections.get(EnumFacing.NORTH) > 0) {
            tessellator.drawScaledFaceDouble(5.0f, 0.0f, 11.0f, 5.0f, EnumFacing.UP, icon, y);
        }
        if (connections.get(EnumFacing.EAST) > 0) {
            tessellator.drawScaledFaceDouble(11.0f, 5.0f, 16.0f, 11.0f, EnumFacing.UP, icon, y);
        }
        if (connections.get(EnumFacing.SOUTH) > 0) {
            tessellator.drawScaledFaceDouble(5.0f, 11.0f, 11.0f, 16.0f, EnumFacing.UP, icon, y);
        }
        if (connections.get(EnumFacing.WEST) > 0) {
            tessellator.drawScaledFaceDouble(0.0f, 5.0f, 5.0f, 11.0f, EnumFacing.UP, icon, y);
        }
    }

    @Override
    protected void renderWorldBlockWoodDynamic(ITessellator tess, World world, BlockPos pos, B block, T tile, TextureAtlasSprite icon) {
        this.drawWater(tess, tile, BaseIcons.WATER_STILL.getIcon());
    }

    @Override
    protected void renderWorldBlockWoodStatic(ITessellator tess, IExtendedBlockState state, B block, EnumFacing side, TextureAtlasSprite icon) {
        this.renderWoodChannel(tess, (IBlockState)state, icon);
    }

    @Override
    protected void renderInventoryBlockWood(ITessellator tessellator, World world, IBlockState state, B block, T channel, ItemStack stack, EntityLivingBase entity, ItemCameraTransforms.TransformType type, TextureAtlasSprite icon) {
        this.renderBottom(tessellator, icon);
        this.renderSide(tessellator, state, EnumFacing.NORTH, (byte)0, icon);
        this.renderSide(tessellator, state, EnumFacing.EAST, (byte)0, icon);
        this.renderSide(tessellator, state, EnumFacing.SOUTH, (byte)0, icon);
        this.renderSide(tessellator, state, EnumFacing.WEST, (byte)0, icon);
    }

    public boolean applyAmbientOcclusion() {
        return true;
    }
}

