/*
 * Decompiled with CFR 0.152.
 */
package com.infinityraider.agricraft.tiles.irrigation;

import com.agricraft.agricore.core.AgriCore;
import com.agricraft.agricore.exception.ExceptionMessageBuilder;
import com.google.common.base.Preconditions;
import com.infinityraider.agricraft.api.v1.misc.IAgriConnectable;
import com.infinityraider.agricraft.api.v1.misc.IAgriFluidComponent;
import com.infinityraider.agricraft.api.v1.util.AgriSideMetaMatrix;
import com.infinityraider.agricraft.network.MessageSyncFluidAmount;
import com.infinityraider.agricraft.tiles.TileEntityCustomWood;
import com.infinityraider.agricraft.tiles.irrigation.TileEntitySprinkler;
import com.infinityraider.agricraft.utility.IAgriFluidComponentSyncable;
import com.infinityraider.infinitylib.utility.WorldHelper;
import com.infinityraider.infinitylib.utility.debug.IDebuggable;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;

public class TileEntityChannel
extends TileEntityCustomWood
implements ITickable,
IAgriFluidComponent,
IAgriFluidComponentSyncable,
IDebuggable {
    public static final int CHANNEL_FLUID_CAPACITY = 1000;
    public static final int CHANNEL_FLUID_HEIGHT_MIN = 250;
    public static final int CHANNEL_FLUID_HEIGHT_MAX = 750;
    public static final int CHANNEL_FLUID_SYNC_THRESHOLD = 100;
    public static final long CHANNEL_FLUID_SYNC_TIMEOUT = 1000L;
    private final int fluidCapacity;
    private final int fluidHeightMin;
    private final int fluidHeightMax;
    private final int fluidSyncThreshold;
    private final long fluidSyncTimeout;
    private final int fluidDensity;
    @Nonnull
    private final AgriSideMetaMatrix connections;
    private int fluidAmount;
    private int oldFluidAmount;
    private long last_update;

    public TileEntityChannel() {
        this(1000, 250, 750, 100, 1000L);
    }

    public TileEntityChannel(int fluidCapacity, int fluidHeightMin, int fluidHeightMax, int fluidSyncThreshold, long fluidSyncTimeout) {
        Preconditions.checkArgument((fluidCapacity > 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((fluidHeightMin >= 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((fluidHeightMax <= 1000 ? 1 : 0) != 0);
        Preconditions.checkArgument((fluidHeightMin < fluidHeightMax ? 1 : 0) != 0);
        Preconditions.checkArgument((fluidSyncThreshold > 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((fluidSyncTimeout >= 500L ? 1 : 0) != 0);
        this.fluidCapacity = fluidCapacity;
        this.fluidHeightMin = fluidHeightMin;
        this.fluidHeightMax = fluidHeightMax;
        this.fluidSyncThreshold = fluidSyncThreshold;
        this.fluidSyncTimeout = fluidSyncTimeout;
        this.fluidDensity = fluidCapacity / (fluidHeightMax - fluidHeightMin);
        Preconditions.checkArgument((this.fluidDensity > 0 ? 1 : 0) != 0, (String)"Invalid fluid density!\n\tfc: {0}\n\tmh: {1}\n\tMh: {2}", (Object)fluidCapacity, (Object)fluidHeightMin, (Object)fluidHeightMax);
        this.fluidAmount = 0;
        this.connections = new AgriSideMetaMatrix();
        this.last_update = 0L;
        this.refreshConnections();
    }

    @Override
    protected final void writeNBT(NBTTagCompound tag) {
        tag.func_74768_a("agri_fluid_amount", this.fluidAmount);
        this.connections.writeToNbt(tag);
        this.writeChannelNBT(tag);
    }

    void writeChannelNBT(NBTTagCompound tag) {
    }

    @Override
    protected final void readNBT(NBTTagCompound tag) {
        int newFluidAmount = 0;
        if (tag.func_74764_b("agri_fluid_amount")) {
            newFluidAmount = tag.func_74762_e("agri_fluid_amount");
        }
        if (newFluidAmount < 0) {
            AgriCore.getLogger("agricraft").warn("Save file has negative fluid amount ({0} mB) for fluid component! Replacing with 0 mB instead!", newFluidAmount);
            newFluidAmount = 0;
        } else if (newFluidAmount > this.fluidCapacity) {
            AgriCore.getLogger("agricraft").warn("Save file has fluid amount ({0} mB) that exceeds the capacity of a fluid component ({1} mB)! Replacing maximum allowed fluid amount ({1} mB) instead!", newFluidAmount, this.fluidCapacity);
            newFluidAmount = this.fluidCapacity;
        }
        this.fluidAmount = newFluidAmount;
        this.connections.readFromNbt(tag);
        this.readChannelNBT(tag);
    }

    void readChannelNBT(NBTTagCompound tag) {
    }

    @Override
    public boolean canConnectTo(EnumFacing side, IAgriConnectable connectable) {
        return side != EnumFacing.UP && connectable instanceof IAgriFluidComponent && connectable.canConnectTo(EnumFacing.UP, this);
    }

    @Override
    @Nonnull
    public AgriSideMetaMatrix getConnections() {
        return this.connections.copy();
    }

    @Override
    public final void refreshConnections() {
        for (EnumFacing side : EnumFacing.values()) {
            this.connections.set(side, this.classifyConnection(side));
        }
    }

    protected byte classifyConnection(@Nonnull EnumFacing side) {
        IAgriFluidComponent component = WorldHelper.getTile((IBlockAccess)this.field_145850_b, (BlockPos)this.field_174879_c.func_177972_a(side), IAgriFluidComponent.class).orElse(null);
        if (component == null) {
            return 0;
        }
        if (side.func_176740_k().func_176722_c()) {
            return 1;
        }
        if (component instanceof TileEntitySprinkler) {
            return 2;
        }
        return 0;
    }

    @Override
    public void setFluidAmount(int newFluidAmount) {
        if (newFluidAmount < 0) {
            AgriCore.getLogger("agricraft").warn("Attempted to set fluid amount of a component to a negative number ({0}mB)!", newFluidAmount);
            newFluidAmount = 0;
        } else if (newFluidAmount > this.fluidCapacity) {
            AgriCore.getLogger("agricraft").warn("Attempted to set fluid amount of a component with capacity {0}mB to {1}mB!", this.fluidCapacity, newFluidAmount);
            newFluidAmount = this.fluidCapacity;
        }
        this.fluidAmount = newFluidAmount;
        this.oldFluidAmount = newFluidAmount;
        this.field_145850_b.func_175646_b(this.field_174879_c, (TileEntity)this);
    }

    @Override
    public int getFluidAmount() {
        return this.fluidAmount;
    }

    @Override
    public int getFluidHeight() {
        return this.fluidHeightMin + this.fluidAmount / this.fluidDensity;
    }

    @Override
    public int getMinFluidHeight() {
        return this.fluidHeightMin;
    }

    @Override
    public int getMaxFluidHeight() {
        return this.fluidHeightMax;
    }

    @Override
    public int getFluidCapacity() {
        return this.fluidCapacity;
    }

    @Override
    public int acceptFluid(int inputHeight, int inputAmount, boolean partial, boolean simulate) {
        Preconditions.checkArgument((inputHeight >= 0 ? 1 : 0) != 0, (Object)"Negative input heights are not allowed!");
        Preconditions.checkArgument((inputAmount >= 0 ? 1 : 0) != 0, (Object)"Negative input amounts are not allowed!");
        int fluidHeight = this.getFluidHeight();
        if (fluidHeight >= inputHeight) {
            return inputAmount;
        }
        int totalFluid = this.fluidAmount + inputAmount;
        int remainingFluid = Math.max(totalFluid - this.fluidCapacity, 0);
        int consumedFluid = inputAmount - remainingFluid;
        if (consumedFluid < 0) {
            ExceptionMessageBuilder eb = new ExceptionMessageBuilder();
            eb.withTitle("Irrigation Component Error");
            eb.withDescription("With %1$d mB of total fluid, somehow consumed %2$d mB, which should be impossible!", totalFluid, consumedFluid);
            eb.withContext("Component Fluid Amount", this.fluidAmount + "mB");
            eb.withContext("Component Fluid Capacity", this.fluidCapacity + "mB");
            eb.withContext("Input Fluid Amount", inputAmount + "mB");
            eb.withContext("Total Fluid Amount", totalFluid + "mB");
            eb.withContext("Remaining Fluid Amount", remainingFluid + "mB");
            eb.withContext("Consumed Fluid Amount", consumedFluid + "mB");
            throw new AssertionError((Object)eb.build());
        }
        if (!partial && remainingFluid != 0) {
            return inputAmount;
        }
        if (!simulate && remainingFluid != inputAmount) {
            this.fluidAmount += consumedFluid;
            this.field_145850_b.func_175646_b(this.field_174879_c, (TileEntity)this);
        }
        return remainingFluid;
    }

    public void func_73660_a() {
        long currentTime;
        Object component;
        if (this.connections.get(EnumFacing.DOWN) > 0 && (component = (IAgriFluidComponent)WorldHelper.getTile((IBlockAccess)this.field_145850_b, (BlockPos)this.field_174879_c.func_177972_a(EnumFacing.DOWN), IAgriFluidComponent.class).orElse(null)) != null) {
            int newFluidAmount = component.acceptFluid(1000, this.fluidAmount, true, false);
            if (newFluidAmount < 0) {
                throw new AssertionError((Object)"A component acccepted too much fluid!");
            }
            this.fluidAmount = newFluidAmount;
        }
        for (EnumFacing side : EnumFacing.field_176754_o) {
            IAgriFluidComponent component2;
            if (this.connections.get(side) <= 0 || (component2 = (IAgriFluidComponent)WorldHelper.getTile((IBlockAccess)this.field_145850_b, (BlockPos)this.field_174879_c.func_177972_a(side), IAgriFluidComponent.class).orElse(null)) == null) continue;
            this.pushToComponent(component2);
        }
        if (Math.abs(this.oldFluidAmount - this.fluidAmount) > this.fluidSyncThreshold && (currentTime = System.currentTimeMillis()) - this.last_update > this.fluidSyncTimeout) {
            this.oldFluidAmount = this.fluidAmount;
            if (!this.field_145850_b.field_72995_K) {
                new MessageSyncFluidAmount(this.field_145850_b, this.field_174879_c, this.fluidAmount).sendToAll();
            }
        }
        if (this.fluidAmount != this.oldFluidAmount) {
            this.field_145850_b.func_175646_b(this.field_174879_c, (TileEntity)this);
        }
    }

    private void pushToComponent(@Nonnull IAgriFluidComponent component) {
        int pushHeight;
        int pushAmount;
        int usedAmount;
        Preconditions.checkNotNull((Object)component);
        int fluidHeight = this.getFluidHeight();
        int otherHeight = component.getFluidHeight();
        if (fluidHeight < 0) {
            throw new AssertionError((Object)("A IAgriFluidComponent reported an negative fluid height of " + fluidHeight + "!"));
        }
        if (otherHeight < 0) {
            throw new AssertionError((Object)("A IAgriFluidComponent reported an negative fluid height of " + otherHeight + "!"));
        }
        if (fluidHeight < otherHeight) {
            return;
        }
        int deltaHeight = fluidHeight - otherHeight;
        int deltaAmount = deltaHeight * this.fluidDensity;
        if (deltaAmount < 2) {
            return;
        }
        if (deltaAmount > this.fluidAmount) {
            deltaAmount = this.fluidAmount;
        }
        if ((usedAmount = (pushAmount = deltaAmount / 2) - component.acceptFluid(pushHeight = otherHeight + deltaHeight / 2, pushAmount, true, false)) > pushAmount) {
            throw new AssertionError((Object)("Component used " + usedAmount + "mB but was only given " + pushAmount + "mb!"));
        }
        if (usedAmount < 0) {
            throw new AssertionError((Object)("Component used less than zero mB of fluid (" + usedAmount + "mB) which should be impossible!"));
        }
        if (usedAmount > this.fluidAmount) {
            throw new AssertionError((Object)"Detected possible concurrent modification issue.");
        }
        this.fluidAmount -= usedAmount;
        this.field_145850_b.func_175646_b(this.field_174879_c, (TileEntity)this);
    }

    @Override
    public void addServerDebugInfo(Consumer<String> consumer) {
        consumer.accept("CHANNEL:");
        super.addServerDebugInfo(consumer);
        consumer.accept(" - Fluid Amount: " + this.getFluidAmount() + " / " + this.getFluidCapacity());
        consumer.accept(" - Fluid Height: " + this.getFluidHeight());
        this.connections.toString(s -> consumer.accept(" " + s));
    }

    public void addClientDebugInfo(Consumer<String> consumer) {
        consumer.accept("CHANNEL:");
        super.addServerDebugInfo(consumer);
        consumer.accept(" - Fluid Amount: " + this.getFluidAmount() + " / " + this.getFluidCapacity());
        consumer.accept(" - Fluid Height: " + this.getFluidHeight());
        this.connections.toString(s -> consumer.accept(" " + s));
    }

    @Override
    public void addDisplayInfo(@Nonnull Consumer<String> information) {
        super.addDisplayInfo(information);
        information.accept(AgriCore.getTranslator().translate("agricraft_tooltip.waterLevel") + ": " + this.getFluidAmount() + "/" + this.getFluidCapacity());
    }
}

