/*
 * Decompiled with CFR 0.152.
 */
package cofh.nonvflash;

import java.io.File;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.client.resources.SimpleReloadableResourceManager;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.MobEffects;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;

@Mod(modid="nonvflash", name="No Night Vision Flashing", version="1.2.0", dependencies="required-after:forge@[14.0.0.0,15.0.0.0);", clientSideOnly=true, acceptedMinecraftVersions="[1.12.2]")
public class NoNVFlash {
    public static final String MOD_ID = "nonvflash";
    public static final String MOD_NAME = "No Night Vision Flashing";
    public static final String VERSION = "1.2.0";
    public static final String DEPENDENCIES = "required-after:forge@[14.0.0.0,15.0.0.0);";
    @Mod.Instance(value="nonvflash")
    public static NoNVFlash instance;
    public static Configuration config;
    public static boolean fadeOut;
    public static int fadeTicks;
    public static float maxBrightness;
    public static float fadeRate;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        config = new Configuration(new File(event.getModConfigurationDirectory(), "/cofh/nonvflash/client.cfg"), VERSION, true);
        config.load();
        String category = "General";
        String comment = "Adjust this value to change the default brightness of the Night Vision effect. Setting this to 0 will effectively disable it.";
        maxBrightness = config.getFloat("Brightness", category, maxBrightness, 0.0f, 1.0f, comment);
        comment = "If TRUE, Night Vision brightness will gradually fade over a number of ticks instead of abruptly stopping.";
        fadeOut = config.getBoolean("FadeOutEffect", category, fadeOut, comment);
        comment = "If the fade out option is enabled (TRUE), adjust this value to change the duration of the fade.";
        fadeTicks = config.getInt("FadeOutTicks", category, fadeTicks, 10, 200, comment);
        fadeRate = maxBrightness / (float)fadeTicks;
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        config.save();
        SimpleReloadableResourceManager manager = (SimpleReloadableResourceManager)Minecraft.func_71410_x().func_110442_L();
        int index = manager.field_110546_b.indexOf(Minecraft.func_71410_x().field_71460_t);
        manager.field_110546_b.remove(index);
        Minecraft.func_71410_x().field_71460_t = new EntityRenderer(Minecraft.func_71410_x(), Minecraft.func_71410_x().func_110442_L()){

            public float func_180438_a(EntityLivingBase entitylivingbaseIn, float partialTicks) {
                if (!fadeOut) {
                    return maxBrightness;
                }
                int i = entitylivingbaseIn.func_70660_b(MobEffects.field_76439_r).func_76459_b();
                return i > fadeTicks ? maxBrightness : (float)i * fadeRate;
            }
        };
        manager.func_110542_a((IResourceManagerReloadListener)Minecraft.func_71410_x().field_71460_t);
    }

    static {
        fadeOut = true;
        fadeTicks = 20;
        maxBrightness = 1.0f;
        fadeRate = maxBrightness / (float)fadeTicks;
    }
}

