/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.gui.controls;

import binnie.core.api.gui.IWidget;
import binnie.core.gui.Attribute;
import binnie.core.gui.CraftGUI;
import binnie.core.gui.controls.core.Control;
import binnie.core.gui.controls.core.IControlValue;
import binnie.core.gui.events.EventKey;
import binnie.core.gui.events.EventMouse;
import binnie.core.gui.events.EventTextEdit;
import binnie.core.gui.events.EventWidget;
import binnie.core.gui.resource.textures.CraftGUITexture;
import net.minecraft.client.gui.GuiTextField;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ControlTextEdit
extends Control
implements IControlValue<String> {
    private final GuiTextField field = new GuiTextField(0, this.getWindow().getGui().getFontRenderer(), 0, 0, 10, 10);
    private String cachedValue = "";

    public ControlTextEdit(IWidget parent, int x, int y, int width, int height) {
        super(parent, x, y, width, height);
        this.addAttribute(Attribute.CAN_FOCUS);
        this.addAttribute(Attribute.MOUSE_OVER);
        this.field.func_146185_a(false);
        this.addSelfEventHandler(EventKey.Down.class, event -> {
            this.field.func_146201_a(event.getCharacter(), event.getKey());
            String text = this.getValue();
            if (!text.equals(this.cachedValue)) {
                this.cachedValue = text;
                this.callEvent(new EventTextEdit((IWidget)this, this.cachedValue));
                this.onTextEdit(this.cachedValue);
            }
        });
        this.addSelfEventHandler(EventMouse.Down.class, event -> this.field.func_146192_a(this.getRelativeMousePosition().xPos(), this.getRelativeMousePosition().yPos(), event.getButton()));
        this.addSelfEventHandler(EventWidget.GainFocus.class, event -> this.field.func_146195_b(true));
        this.addSelfEventHandler(EventWidget.LoseFocus.class, event -> this.field.func_146195_b(false));
    }

    @Override
    public String getValue() {
        return this.field.func_146179_b() == null ? "" : this.field.func_146179_b();
    }

    @Override
    public void setValue(String value) {
        if (!this.getValue().equals(value)) {
            this.field.func_146180_a(value);
        }
    }

    protected void onTextEdit(String value) {
    }

    @Override
    public void onRenderBackground(int guiWidth, int guiHeight) {
        CraftGUI.RENDER.texture((Object)CraftGUITexture.SLOT, this.getArea());
        this.renderTextField();
    }

    protected void renderTextField() {
        this.field.field_146218_h = this.getWidth();
        this.field.field_146219_i = this.getHeight();
        this.field.field_146209_f = (int)(((float)this.getHeight() - 8.0f) / 2.0f);
        this.field.field_146210_g = (int)(((float)this.getHeight() - 8.0f) / 2.0f);
        this.field.func_146194_f();
    }
}

